/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns;

import rdt.Wraith.IRobot;
import rdt.Wraith.IRoundStartedEventHandler;
import rdt.Wraith.ISubsystemMode;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.Targeting.ITargeting;
import rdt.Wraith.Targeting.Target;
import rdt.Wraith.Utils.MathUtils;
import rdt.Wraith.Waves.IWaveManager;
import rdt.Wraith.Waves.WaveData;
import robocode.Rules;
import robocode.util.Utils;

public class ClosestTargetMode
implements ISubsystemMode,
IRoundStartedEventHandler {
    private final IRobot _robot;
    private final ITargeting _targeting;
    private final IWaveManager _friendlyWaveManager;
    private double _nextFirePower;
    private long _nextFireTurn;
    private final double[] _bulletAngle = new double[1];

    public ClosestTargetMode(IRobot robot, ITargeting targeting, IWaveManager friendlyWaveManager) {
        this._robot = robot;
        this._targeting = targeting;
        this._friendlyWaveManager = friendlyWaveManager;
        this._robot.RegisterForEventHandling(this);
    }

    @Override
    public void UpdateHighestPriority() {
        if (!this._targeting.HasValidTarget()) {
            return;
        }
        Target target = this._targeting.GetCurrentTarget();
        if (!target.Alive) {
            return;
        }
        if (this._robot.getEnergy() <= 0.0) {
            this.AimDirectlyAtTarget();
            return;
        }
        this._nextFirePower = 1.7;
        if (this._robot.getTime() - target.LastUpdatedTick > 3L) {
            this.AimDirectlyAtTarget();
            this.FireVirtualWave(target);
            return;
        }
        if (this._robot.getTime() <= 3L) {
            this.AimDirectlyAtTarget();
            this.FireVirtualWave(target);
            return;
        }
        if (this._nextFirePower <= 0.0) {
            this.AimDirectlyAtTarget();
            this.FireVirtualWave(target);
            return;
        }
        if (this._robot.getGunHeat() > 0.1) {
            this.AimDirectlyAtTarget();
            this.FireVirtualWave(target);
            return;
        }
        if (this._nextFireTurn == this._robot.getTime() && this._robot.getGunTurnRemaining() == 0.0 && this._robot.getGunHeat() <= 0.0) {
            this._friendlyWaveManager.FireWave(this._robot.getX(), this._robot.getY(), WaveData.eWaveType.Real, this._nextFirePower, this._robot.getTime(), null, target.RobotSnapshots.Read(this._robot.getTime()));
            this._robot.setFire(this._nextFirePower);
            return;
        }
        this.FireVirtualWave(target);
        double bulletVelocity = Rules.getBulletSpeed((double)this._nextFirePower);
        long safePredictedTick = this._robot.GetSafePredictedTick(this._robot.getTime() + 1L);
        RobotSnapshot nextSnapshot = this._robot.ReadRobotSnapshot(safePredictedTick);
        target.GunsFiredAtTarget.PredictAngles(nextSnapshot.LocationX, nextSnapshot.LocationY, this._robot.getTime(), bulletVelocity, 1, this._bulletAngle);
        this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this._bulletAngle[0] - this._robot.getGunHeadingRadians())));
        this._nextFireTurn = this._robot.getTime() + 1L;
    }

    private void AimDirectlyAtTarget() {
        if (!this._targeting.HasValidTarget()) {
            return;
        }
        Target target = this._targeting.GetCurrentTarget();
        if (!target.Alive) {
            return;
        }
        RobotSnapshot targetSnapshot = target.RobotSnapshots.Read(this._robot.getTime());
        double targetAbsBearing = MathUtils.GetAngle(this._robot.getX(), this._robot.getY(), targetSnapshot.LocationX, targetSnapshot.LocationY);
        this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(targetAbsBearing - this._robot.getGunHeadingRadians())));
    }

    private void FireVirtualWave(Target target) {
        this._friendlyWaveManager.FireWave(this._robot.getX(), this._robot.getY(), WaveData.eWaveType.Virtual, this._nextFirePower, this._robot.getTime(), null, target.RobotSnapshots.Read(this._robot.getTime()));
    }

    @Override
    public float GetPriority() {
        if (!this._targeting.HasValidTarget()) {
            return 0.0f;
        }
        Target target = this._targeting.GetCurrentTarget();
        if (!target.Alive) {
            return 0.0f;
        }
        if (Utils.isNear((double)this._robot.getEnergy(), (double)0.0)) {
            return 0.0f;
        }
        if (this._robot.getTime() - target.LastUpdatedTick > 3L) {
            return 0.0f;
        }
        if (this._robot.getTime() <= 3L) {
            return 0.0f;
        }
        if (target.Disabled) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public void Update() {
    }

    @Override
    public void OnRoundStartedEvent() {
        this._nextFireTurn = -1L;
    }
}

