/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns.GunImplementations.DC;

import rdt.Wraith.Guns.FiringData;
import rdt.Wraith.Guns.FiringSolutions;
import rdt.Wraith.Guns.Gun;
import rdt.Wraith.Guns.GunImplementations.DC.DCDebug;
import rdt.Wraith.Guns.GunImplementations.DC.DimensionConfiguration;
import rdt.Wraith.Guns.GunImplementations.DC.GuessFactorPayload;
import rdt.Wraith.Guns.GunImplementations.Segmented.GuessFactor.KernelDensity;
import rdt.Wraith.Guns.GunImplementations.Segmented.GuessFactor.KernelDensityFunctionBase;
import rdt.Wraith.Guns.GunImplementations.Segmented.GuessFactor.KernelDensityFunctionGaussian;
import rdt.Wraith.IRobot;
import rdt.Wraith.KDTree.KdTree;
import rdt.Wraith.KDTree.NearestNeighborIterator;
import rdt.Wraith.KDTree.SquareEuclideanDistanceFunction;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.RobotSnapshots.RobotSnapshots;
import rdt.Wraith.Stats.IStats;
import rdt.Wraith.Targeting.Target;
import rdt.Wraith.Utils.MathUtils;
import rdt.Wraith.Waves.IWaveEventHandler;
import rdt.Wraith.Waves.IWaveManager;
import rdt.Wraith.Waves.WaveData;
import robocode.BulletHitBulletEvent;
import robocode.HitByBulletEvent;
import robocode.util.Utils;

public class DCGun
extends Gun
implements IWaveEventHandler {
    private final long _firingTickOffset;
    private final KdTree<GuessFactorPayload> _kdTree;
    private final DimensionConfiguration _dimensionConfiguration;
    private final KernelDensityFunctionBase _densityEstimator = new KernelDensityFunctionGaussian(0.04);
    private final DCDebug _dcDebug;

    public DCGun(String ownerName, IRobot robot, RobotSnapshots targetSnapshots, IStats stats, long firingTickOffset, IWaveManager waveManager, DimensionConfiguration dimensionConfiguration) {
        super(ownerName + " : DC", robot, targetSnapshots, stats);
        waveManager.RegisterWaveEventHandler(this);
        this._firingTickOffset = firingTickOffset;
        this._dimensionConfiguration = dimensionConfiguration;
        this._dimensionConfiguration.SetRobot(robot);
        this._kdTree = new KdTree(dimensionConfiguration.NumDimensions);
        this._dcDebug = null;
    }

    @Override
    public void GetFiringSolutions(FiringData firingData, FiringSolutions outSolutions) {
        if (this._kdTree.size() < 1) {
            return;
        }
        int NumGFs = Math.min(100, this._kdTree.size());
        NearestNeighborIterator<GuessFactorPayload> iterator = this._kdTree.getNearestNeighborIterator(this._dimensionConfiguration.ConvertFromSnapshot(firingData.TargetAtFiringTick, firingData.MEA), NumGFs, new SquareEuclideanDistanceFunction());
        double[] GuessFactors = new double[NumGFs];
        double[] Weights = new double[NumGFs];
        int NumGuessFactors = 0;
        while (iterator.hasNext()) {
            GuessFactorPayload payload = iterator.next();
            GuessFactors[NumGuessFactors] = payload.GuessFactor;
            double distance = iterator.distance();
            double waveWeighting = payload.WaveType == WaveData.eWaveType.Real ? 1.0 : 0.1;
            Weights[NumGuessFactors] = Math.min(0.1, Math.abs(1.0 - distance)) * waveWeighting;
            ++NumGuessFactors;
        }
        KernelDensity kernelDensity = new KernelDensity();
        this._densityEstimator.RecalculateKernelDensity(GuessFactors, Weights, NumGuessFactors, kernelDensity);
        double hotAngle = firingData.TargetHeadOnAbsoluteBearingAtFiringTick;
        double forwardPeakBandwidth = firingData.TargetWidthRadians / Math.abs(firingData.MEA.ForwardRelative * 2.0);
        double rearPeakBandwidth = firingData.TargetWidthRadians / Math.abs(firingData.MEA.RearRelative * 2.0);
        assert (forwardPeakBandwidth >= 0.0);
        assert (rearPeakBandwidth >= 0.0);
        for (int peakIndex = 0; peakIndex < kernelDensity.SortedPeaks.length && kernelDensity.IsValidPeak(peakIndex); ++peakIndex) {
            double peakValue01 = kernelDensity.GetPeakValue01(peakIndex, forwardPeakBandwidth, rearPeakBandwidth);
            double gf = peakValue01 * 2.0 - 1.0;
            double angleOffset = firingData.MEA.GuessFactorToRelativeFiringAngle(gf);
            double firingAngle = Utils.normalAbsoluteAngle((double)(hotAngle + angleOffset));
            outSolutions.WriteSolution(firingAngle, kernelDensity.GetPeakWeight(peakIndex), this);
        }
        if (this._dcDebug != null) {
            this._dcDebug.OnDataRetrieved(kernelDensity);
        }
    }

    @Override
    public void OnWaveGeneratedEvent() {
    }

    @Override
    public void OnBulletHitBulletWithWaveEvent(BulletHitBulletEvent eventData, WaveData wave) {
    }

    @Override
    public void OnHitByBulletWithWaveEvent(HitByBulletEvent eventData, WaveData wave) {
    }

    @Override
    public void OnWavePassed(WaveData wave, Target target) {
        RobotSnapshot targetSnapshot = this._targetSnapshots.Read(wave.ActivationTick - this._firingTickOffset);
        RobotSnapshot targetAtFiringTime = this._targetSnapshots.Read(wave.ActivationTick);
        RobotSnapshot targetNow = this._targetSnapshots.Read(this._robot.getTime());
        double originalAbsAngle = targetAtFiringTime.AbsoluteAngleFromOpponent;
        double finalAbsAngle = MathUtils.GetAngle(wave.OriginX, wave.OriginY, targetNow.LocationX, targetNow.LocationY);
        double relativeAngle = Utils.normalRelativeAngle((double)(finalAbsAngle - originalAbsAngle));
        double gF = wave.MEA.RelativeAngleToGuessFactor(relativeAngle);
        GuessFactorPayload payload = new GuessFactorPayload(gF, wave.WaveType);
        this._kdTree.addPoint(this._dimensionConfiguration.ConvertFromSnapshot(targetSnapshot, wave.MEA), (Object)payload);
    }
}

