/*
 * Decompiled with CFR 0.152.
 */
package hp.core;

import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class RobocodeUtils {
    public static final double TWO_PI = Math.PI * 2;
    public static final double HALF_PI = 1.5707963267948966;

    private RobocodeUtils() {
    }

    public static double bulletVelocity(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double travelVelocity(double distance, long time) {
        return distance / (double)time;
    }

    public static double travelTime(double distance, double velocity) {
        return distance / velocity;
    }

    public static int sign(double n) {
        return n < 0.0 ? -1 : 1;
    }

    public static double pointsToAngle(Point2D source, Point2D target) {
        double sourceX = source.getX();
        double sourceY = source.getY();
        double targetX = target.getX();
        double targetY = target.getY();
        return RobocodeUtils.pointsToAngle(sourceX, sourceY, targetX, targetY);
    }

    public static double pointsToAngle(double sourceX, double sourceY, double targetX, double targetY) {
        double angle = Math.atan((targetX - sourceX) / (targetY - sourceY));
        return angle += (double)(targetY < sourceY ? 180 : 0);
    }

    public static void pointTranslate(Point2D target, Point2D translation) {
        target.setLocation(target.getX() + translation.getX(), target.getY() + translation.getY());
    }

    public static void pointTranslate(Point2D target, double x, double y) {
        target.setLocation(target.getX() + x, target.getY() + x);
    }

    public static void toLocation(double angle, double length, Point2D sourceLocation, Point2D targetLocation) {
        double X = sourceLocation.getX() + Math.sin(angle) * length;
        double Y = sourceLocation.getY() + Math.cos(angle) * length;
        targetLocation.setLocation(X, Y);
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double maxEscapeAngle(double velocity) {
        return Math.asin(8.0 / velocity);
    }

    public static void setBackAsFront(AdvancedRobot robot, double goAngle) {
        double angle = Utils.normalRelativeAngle((double)(goAngle - robot.getHeadingRadians()));
        if (Math.abs(angle) > 1.5707963267948966) {
            if (angle < 0.0) {
                robot.setTurnRightRadians(Math.PI + angle);
            } else {
                robot.setTurnLeftRadians(Math.PI - angle);
            }
            robot.setBack(100.0);
        } else {
            if (angle < 0.0) {
                robot.setTurnLeftRadians(-1.0 * angle);
            } else {
                robot.setTurnRightRadians(angle);
            }
            robot.setAhead(100.0);
        }
    }

    public static double rollingAvg(double value, double newEntry, double n, double weighting) {
        return (value * n + newEntry * weighting) / (n + weighting);
    }

    public static double dist(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static double normalizeHeading(double ang) {
        while (ang < 0.0) {
            ang += Math.PI * 2;
        }
        while (ang > Math.PI * 2) {
            ang -= Math.PI * 2;
        }
        return ang;
    }

    public static double normalizeBearing(double ang) {
        while (ang < -Math.PI) {
            ang += Math.PI * 2;
        }
        while (ang > Math.PI) {
            ang -= Math.PI * 2;
        }
        return ang;
    }

    public static double getBearing(double x1, double y1, double x2, double y2) {
        double xo = x2 - x1;
        double yo = y2 - y1;
        return Math.atan2(xo, yo);
    }
}

