/*
 * Decompiled with CFR 0.152.
 */
package com.spp.robocode;

import com.spp.robocode.BattlefieldModel;
import com.spp.robocode.movement.AntiGravityMover;
import com.spp.robocode.movement.MovementAlgo;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.HitRobotEvent;
import robocode.util.Utils;

public class MovementManager {
    private MovementAlgo currAlgo = new AntiGravityMover();

    MovementManager(AdvancedRobot r, BattlefieldModel m) {
        this.currAlgo.initialise(r, m);
    }

    void onHitRobot(HitRobotEvent event) {
        this.currAlgo.onHitRobot(event);
    }

    void move() {
        this.currAlgo.doMovement();
    }

    public static void GoToPoint(AdvancedRobot robot, Point2D p1) {
        double x = p1.getX();
        double y = p1.getY();
        double angleToTarget = Math.atan2(x -= robot.getX(), y -= robot.getY());
        double targetAngle = Utils.normalRelativeAngle((double)(angleToTarget - robot.getHeadingRadians()));
        double distance = Math.hypot(x, y);
        double turnAngle = Math.atan(Math.tan(targetAngle));
        robot.setTurnRightRadians(turnAngle);
        if (targetAngle == turnAngle) {
            robot.setAhead(distance);
        } else {
            robot.setBack(distance);
        }
    }
}

