/*
 * Decompiled with CFR 0.152.
 */
package pedersen.misc;

import java.awt.Color;
import java.awt.Graphics2D;
import pedersen.core.Constraints;
import pedersen.core.Conversions;
import pedersen.debug.GraphicalDebugger;
import pedersen.divination.CombatWave;
import pedersen.misc.Arena;
import pedersen.physics.SlopeFormula;
import pedersen.physics.StaticHeadingImpl;
import pedersen.physics.StaticPosition;
import pedersen.physics.StaticPositionImpl;

public class ShortestRoute {
    private static StaticPosition targetPosition = null;
    private static StaticPosition wallInterceptPosition = null;
    public static boolean markPositions = false;

    public static double getVelocity(StaticPosition chassisPosition, double chassisHeading, double chassisVelocity, StaticPosition targetPosition) {
        double targetVelocity;
        double relativeBearingToPointB;
        double presentRateOfTurn;
        StaticPosition wallInterceptPosition = Arena.getWallIntercept(chassisPosition, chassisHeading, chassisVelocity);
        if (markPositions) {
            ShortestRoute.wallInterceptPosition = wallInterceptPosition;
            ShortestRoute.targetPosition = targetPosition;
        }
        if ((presentRateOfTurn = Conversions.getAbsMaxTurnRateFromVelocity(chassisVelocity)) >= Math.abs(relativeBearingToPointB = Constraints.getNegativePiToPi(chassisPosition.getBearing(targetPosition) - chassisHeading)) || presentRateOfTurn >= Math.PI - Math.abs(relativeBearingToPointB)) {
            double velocityByDistanceToTarget = ShortestRoute.getMaxVelocity(chassisPosition.getDistance(targetPosition));
            double velocityByDistanceToWall = ShortestRoute.getMaxVelocity(chassisPosition.getDistance(wallInterceptPosition));
            targetVelocity = Math.min(velocityByDistanceToTarget, velocityByDistanceToWall);
        } else {
            double tangentalAngle = chassisHeading + (relativeBearingToPointB > 0.0 ? 1.5707963267948966 : -1.5707963267948966);
            double presentVehicleTurnRadius = ShortestRoute.calculateRadius(chassisVelocity);
            StaticPositionImpl centerOfArc = new StaticPositionImpl(chassisPosition, tangentalAngle, presentVehicleTurnRadius);
            double arcDistanceToTargetPosition = centerOfArc.getDistance(targetPosition);
            double arcDistanceToWallInterceptPosition = centerOfArc.getDistance(wallInterceptPosition);
            if (arcDistanceToWallInterceptPosition < arcDistanceToTargetPosition) {
                double calculatedVelocity = ShortestRoute.calculateVelocity(arcDistanceToWallInterceptPosition);
                double maximumVelocity = ShortestRoute.getMaxVelocity(chassisPosition.getDistance(wallInterceptPosition));
                targetVelocity = Math.min(calculatedVelocity, maximumVelocity);
            } else {
                double calculatedVelocity = ShortestRoute.calculateVelocity(arcDistanceToTargetPosition);
                double maximumVelocity = ShortestRoute.getMaxVelocity(chassisPosition.getDistance(targetPosition));
                targetVelocity = Math.min(calculatedVelocity, maximumVelocity);
            }
        }
        return targetVelocity;
    }

    public static double calculateRadius(double velocity) {
        velocity = Math.abs(velocity);
        return velocity / Conversions.getAbsMaxTurnRateFromVelocity(velocity);
    }

    public static double calculateVelocity(double radius) {
        double velocity = 0.0;
        if (radius != 0.0) {
            velocity = 0.17453292519943295 / (0.01308996938995747 + 1.0 / radius);
        }
        return velocity;
    }

    public static double getMaxVelocity(double distance) {
        double targetVelocity = distance < 2.0 ? distance : (distance < 3.0 ? 2.0 : (distance < 4.0 ? 2.0 : (distance < 5.0 ? distance - 2.0 : (distance < 6.0 ? distance - 2.0 : (distance < 7.0 ? 4.0 : (distance < 8.0 ? 4.0 : (distance < 9.0 ? 4.0 : (distance < 10.0 ? 4.0 : (distance < 11.0 ? distance - 6.0 : (distance < 12.0 ? distance - 6.0 : (distance < 13.0 ? 6.0 : (distance < 14.0 ? 6.0 : (distance < 15.0 ? 6.0 : (distance < 16.0 ? 6.0 : (distance < 17.0 ? 6.0 : (distance < 18.0 ? 6.0 : (distance < 19.0 ? distance - 12.0 : (distance < 20.0 ? distance - 12.0 : 8.0))))))))))))))))));
        return targetVelocity;
    }

    public static StaticPosition getOriginalGuessFactorPosition(CombatWave wave, double guessFactor) {
        double dot = wave.getWaveData().originalBearingToTarget;
        StaticPositionImpl victimPositionAtTimeOfAiming = new StaticPositionImpl(wave, dot, wave.getWaveData().originalDistanceToTarget);
        SlopeFormula tangent = new SlopeFormula((StaticPosition)victimPositionAtTimeOfAiming, StaticHeadingImpl.getTangentAngle(dot));
        double absoluteHeading = StaticHeadingImpl.getCompoundAngle(dot, wave.getWaveData().rangeOfMotion.getFactoredBearingOffset(guessFactor));
        SlopeFormula aim = new SlopeFormula((StaticPosition)wave, absoluteHeading);
        StaticPosition absoluteIntercept = aim.getPointOfIntercept(tangent);
        StaticPosition wallIntercept = Arena.getWallIntercept(wave, absoluteHeading, 1.0);
        return wave.getDistance(absoluteIntercept) < wave.getDistance(wallIntercept) ? absoluteIntercept : wallIntercept;
    }

    public static StaticPosition getGuessFactorPosition(CombatWave wave, double guessFactor) {
        double dot = wave.getWaveData().originalBearingToTarget;
        StaticPositionImpl victimPositionAdjustedToNewDistance = new StaticPositionImpl(wave, dot, wave.getDistance(wave.getVictim()));
        SlopeFormula tangent = new SlopeFormula((StaticPosition)victimPositionAdjustedToNewDistance, StaticHeadingImpl.getTangentAngle(dot));
        double absoluteHeading = StaticHeadingImpl.getCompoundAngle(dot, wave.getWaveData().rangeOfMotion.getFactoredBearingOffset(guessFactor));
        SlopeFormula aim = new SlopeFormula((StaticPosition)wave, absoluteHeading);
        StaticPosition absoluteIntercept = aim.getPointOfIntercept(tangent);
        StaticPosition wallIntercept = Arena.getWallIntercept(wave, absoluteHeading, 1.0);
        return wave.getDistance(absoluteIntercept) < wave.getDistance(wallIntercept) ? absoluteIntercept : wallIntercept;
    }

    public static void onPaint(Graphics2D console) {
        console.setColor(Color.green);
        if (targetPosition != null) {
            GraphicalDebugger.singleton.drawMarker(console, targetPosition);
        }
        console.setColor(Color.orange);
        if (wallInterceptPosition != null) {
            GraphicalDebugger.singleton.drawMarker(console, wallInterceptPosition);
        }
    }
}

