/*
 * Decompiled with CFR 0.152.
 */
package florent;

import florent.Context;
import florent.FUtils;
import florent.FloatingTadpole;
import florent.MyEnemyWave;
import florent.WaveCommand;
import florent.WaveCommandFloaterManager;
import florent.WaveCommandHit;
import florent.WaveCommandVisit;
import florent.jUtil;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.Condition;
import robocode.HitByBulletEvent;

public class WaveManagerFloater {
    public static final int GF_ZERO = 15;
    static final int GF_ONE = 30;
    private static double[][][][] hits = new double[3][3][7][31];
    private static double[][] distanceHits = new double[6][31];
    private static double[][] velocityHits = new double[3][31];
    private static double[][][] accleHits = new double[3][3][31];
    private static double[][][][] visits = new double[3][3][7][31];
    private static double[] fast = new double[31];
    static final int BOT_WIDTH = 4;
    private static int headOnHit = 0;
    protected static int hitCount = 0;
    private static int goodHit = 0;
    AdvancedRobot me;
    private Context target;
    private ArrayList waves;
    private ArrayList ripples;
    private int bullets;
    private boolean debug = false;
    private boolean saved = false;
    private double myVelocity;
    private double myLastVelocity;
    private double myLateralVelocity;
    private double distance;
    private double myBearing;
    private double myBearingDirection;
    private double time = -1.0;
    private Point2D.Double enemyLocation;
    private Point2D.Double myLocation;
    private static String name;

    public WaveManagerFloater(Context target, AdvancedRobot me) {
        this.target = target;
        this.me = me;
    }

    public void init() {
        this.waves = new ArrayList(10);
        this.ripples = new ArrayList(10);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 7) {
                    WaveManagerFloater.hits[i][j][k][15] = 0.05;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.synch();
    }

    public void newTick() {
        if (this.waves.size() == 0 && this.me.getRoundNum() + 4 > this.me.getNumRounds() && !this.saved) {
            this.saveData(name);
            this.saved = true;
        }
    }

    public void newRound() {
        this.waves.clear();
        this.ripples.clear();
    }

    private void synch() {
        this.myVelocity = this.target.getMyVelocity();
        this.myLastVelocity = this.target.getMyLastVelocity();
        this.myLateralVelocity = this.target.getMyLateralVelocity();
        this.distance = this.target.getDistance();
        this.myBearing = this.target.getMyBearing();
        this.myBearingDirection = this.target.getMyBearingDirection();
        this.myLocation = this.target.getMyLocation();
        this.target.synch();
        if (this.time == this.target.getTime()) {
            return;
        }
        this.enemyLocation = this.target.getEnemyLocation();
        this.time = this.target.getTime();
        if (name == null && this.target.getName() != null) {
            try {
                this.restoreData(this.target.getName());
                System.out.println(":" + this.target.getName());
            }
            catch (Exception e) {
                System.out.println("no data for " + this.target.getName() + "\n" + e);
            }
        }
        name = this.target.getName();
    }

    public MyEnemyWave createWave(double power, boolean fired, WaveCommand command) {
        if (this.enemyLocation == null || !fired && this.me.getOthers() == 0) {
            return null;
        }
        double enemyBulletVelocity = FloatingTadpole.bulletVelocity(power);
        double acceleration = this.myVelocity - this.myLastVelocity;
        int velIndex = (int)(Math.abs(this.myLateralVelocity) / 3.0);
        int accelIndex = acceleration > 0.0 ? 2 : (acceleration == 0.0 ? 1 : 0);
        int bftIndex = Math.min(6, (int)(this.distance / enemyBulletVelocity / 10.0));
        int distanceIndex = Math.min(5, (int)this.distance / 140);
        int velIndex2 = (int)(Math.abs(this.myVelocity) / 3.0);
        int lastVelIndex2 = (int)(Math.abs(this.myLastVelocity) / 3.0);
        MyEnemyWave wave = new MyEnemyWave(this.enemyLocation, this.time - 1.0, this.myBearing, power, this.myBearingDirection, fired);
        if (fired) {
            WaveCommandHit hitCommand = new WaveCommandHit(hits[velIndex][accelIndex][bftIndex]);
            wave.addCommand(hitCommand);
            wave.setPredictedGf(hitCommand.getBestIndex(this.distance));
        }
        wave.addCommand(new WaveCommandVisit(visits[velIndex][accelIndex][bftIndex]));
        if (fired) {
            wave.addCommand(new WaveCommandHit(fast));
        }
        if (fired) {
            wave.addCommand(new WaveCommandHit(distanceHits[distanceIndex]));
            wave.addCommand(new WaveCommandHit(velocityHits[velIndex]));
            wave.addCommand(new WaveCommandHit(accleHits[lastVelIndex2][velIndex2]));
        }
        if (fired) {
            wave.addCommand(command);
        }
        wave.addCommand(new WaveCommandFloaterManager(this.ripples));
        this.me.addCustomEvent((Condition)wave);
        this.ripples.add(wave);
        if (fired) {
            wave.addCommand(new WaveCommandFloaterManager(this.waves));
            this.waves.add(wave);
            ++this.bullets;
        }
        this.synch();
        return wave;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.synch();
        this.time = e.getTime();
        if (this.me.getOthers() <= 0) {
            return;
        }
        Point2D.Double impact = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        MyEnemyWave wave = this.getClosestBullet(impact, e.getTime());
        if (wave == null) {
            System.out.print("wave not found ");
            return;
        }
        if (this.debug) {
            System.out.println("hit distance :" + wave.distanceToImpact(impact, this.time) + ":" + wave.getGunLocation() + ":" + wave.getFireTime());
        }
        wave.hit(impact);
        ++hitCount;
        int best = wave.getPredictedGf();
        int index = Math.max(1, Math.min(30, (int)Math.round((1.0 + wave.getGF(impact)) * 15.0)));
        if (Math.abs(index - 15) < 4) {
            ++headOnHit;
        }
        if (Math.abs(index - best) < 4) {
            ++goodHit;
        }
        if (this.debug) {
            System.out.println("hit on " + index + " best:" + best + " fast:" + FloatingTadpole.getBestIndex(fast));
            System.out.println(FUtils.doubleArrayToString(fast));
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        Point2D.Double impact = new Point2D.Double(e.getBullet().getX(), e.getBullet().getY());
        MyEnemyWave wave = this.getClosestBullet(impact, e.getTime());
        if (wave == null) {
            System.out.println("wave not found");
            return;
        }
        wave.hitBullet(impact);
        this.waves.remove((Object)wave);
    }

    public boolean isHeadOn() {
        return 1.0 * (double)headOnHit / (1.0 * (double)hitCount) > 0.7;
    }

    public boolean isClearAhead() {
        return fast[30] + fast[29] < 2.0 && this.isHeadOn();
    }

    public boolean isGood() {
        return 1.0 * (double)goodHit / (1.0 * (double)hitCount) > 0.55;
    }

    public void dump() {
        System.out.println("headOn : " + this.isHeadOn() + " : " + 1.0 * (double)headOnHit / (1.0 * (double)hitCount));
        System.out.println("good : " + this.isGood() + " : " + 1.0 * (double)goodHit / (1.0 * (double)hitCount));
    }

    public MyEnemyWave getClosestBullet(Point2D location, double time) {
        MyEnemyWave closestWave = null;
        ArrayList<MyEnemyWave> toRemove = new ArrayList<MyEnemyWave>();
        double bestDistance = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.waves.size()) {
            MyEnemyWave wave = (MyEnemyWave)((Object)this.waves.get(i));
            if (Math.abs(wave.distanceToImpact(location, time)) < bestDistance) {
                bestDistance = Math.abs(wave.distanceToImpact(location, time));
                closestWave = wave;
            }
            if (wave.distanceToImpact(this.myLocation, this.time) < -40.0) {
                toRemove.add(wave);
            }
            ++i;
        }
        this.waves.removeAll(toRemove);
        return closestWave;
    }

    public MyEnemyWave getNearestBullet(Point2D location, double time) {
        if (this.waves.size() == 0) {
            return null;
        }
        MyEnemyWave nextWave = null;
        double bestDistance = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.waves.size()) {
            MyEnemyWave wave = (MyEnemyWave)((Object)this.waves.get(i));
            if (wave.distanceToImpact(location, time) < bestDistance && wave.distanceToImpact(location, time) > -18.0) {
                bestDistance = Math.abs(wave.distanceToImpact(location, time));
                nextWave = wave;
            }
            ++i;
        }
        return nextWave;
    }

    public double[] getFast() {
        return fast;
    }

    public void saveData(String enemyName) {
        byte[][][][] crib = new byte[3][3][7][31];
        int j = 0;
        while (j < 3) {
            int k = 0;
            while (k < 3) {
                int l = 0;
                while (l < 7) {
                    int m = 0;
                    while (m <= 30) {
                        crib[j][k][l][m] = (byte)(255.0 * hits[j][k][l][m]);
                        ++m;
                    }
                    ++l;
                }
                ++k;
            }
            ++j;
        }
        jUtil.saveObject(crib, this.me.getDataFile(enemyName));
    }

    public void restoreData(String enemyName) {
        Object o = jUtil.restoreObject(this.me.getDataFile(enemyName));
        try {
            byte[][][][] crib = (byte[][][][])o;
            int j = 0;
            while (j < 3) {
                int k = 0;
                while (k < 3) {
                    int l = 0;
                    while (l < 7) {
                        int m = 0;
                        while (m <= 30) {
                            WaveManagerFloater.hits[j][k][l][m] = (double)crib[j][k][l][m] / 255.0 / 3.0;
                            ++m;
                        }
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

