/*
 * Decompiled with CFR 0.152.
 */
package syl.movement.gravity;

import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import syl.core.BaseRobot;
import syl.movement.GravityMovementStrategy;
import syl.movement.gravity.GravityMovementFeature;
import syl.movement.gravity.GravityPoint;
import syl.util.Coordinate;

public class EnemyGravity
extends GravityMovementFeature {
    private GravityMovementStrategy strategy;
    private int numberOfEnemies;
    public static final double ENEMY_POWER = -2000.0;
    public static final double ENEMY_RANGE = 2.0;

    public EnemyGravity(BaseRobot robot, GravityMovementStrategy strategy) {
        this.strategy = strategy;
        strategy.addFeature(this);
        robot.addRobotListener(this);
    }

    public void updateGravityPoints(BaseRobot robot) {
    }

    public void onScannedRobot(BaseRobot robot, ScannedRobotEvent event) {
        String enemyName = event.getName();
        if (!this.strategy.containsGravityPoint(enemyName)) {
            Coordinate enemyCoordinate = Coordinate.getCoordinate(robot.getX(), robot.getY(), event.getDistance(), robot.getEnemyAngle(event.getBearing()));
            GravityPoint newGravityPoint = new GravityPoint(enemyCoordinate, -2000.0, 2.0);
            this.strategy.putGravityPoint(enemyName, newGravityPoint);
            ++this.numberOfEnemies;
        } else {
            Coordinate enemyCoordinate = Coordinate.getCoordinate(robot.getX(), robot.getY(), event.getDistance(), robot.getEnemyAngle(event.getBearing()));
            GravityPoint gravPoint = this.strategy.getGravityPoint(enemyName);
            gravPoint.setCoordinate(enemyCoordinate);
        }
    }

    public void onRobotDeath(BaseRobot robot, RobotDeathEvent event) {
        String enemyName = event.getName();
        this.strategy.removeGravityPoint(enemyName);
        --this.numberOfEnemies;
    }

    public void onHitByBullet(BaseRobot robot, HitByBulletEvent event) {
    }
}

