/*
 * Decompiled with CFR 0.152.
 */
package pedersen.misc;

import pedersen.core.Conversions;
import pedersen.debug.Debug;
import pedersen.misc.Host;

public class Metrics {
    public static final int winningPositions = 10;
    public static long turnsProcessed = 0L;
    public static long turnsSkipped = 0L;
    public static long exceptionsThrown = 0L;
    private static long firedShotCount = 0L;
    private static long bulletHitRobotCount = 0L;
    private static long bulletHitBulletCount = 0L;
    public static long bulletCancelledCount = 0L;
    public static int[] place = new int[10];
    private static double energyGainDueToShotFired = 0.0;
    private static double energyLossDueToShotFired = 0.0;
    private static double energyLossDueToDamageTaken = 0.0;
    private static long collisionWithRobotCount = 0L;
    private static long collisionWithWallCount = 0L;
    private static double energyLossCausedToTarget = 0.0;
    private static long inboundWaveCount = 0L;

    public static void place(int enemiesRemaining) {
        if (enemiesRemaining >= 0 && enemiesRemaining < 10) {
            int n = enemiesRemaining;
            place[n] = place[n] + 1;
        }
    }

    public static void shotFired(double firepower) {
        ++firedShotCount;
        energyLossDueToShotFired += firepower;
    }

    public static void bulletHitTarget(double firepower) {
        ++bulletHitRobotCount;
        energyGainDueToShotFired += Conversions.getEnergyRewardFromFirepower(firepower);
        energyLossCausedToTarget += Conversions.getBulletDamageFromFirepower(firepower);
    }

    public static void bulletHitCombatant(double firepower) {
        energyLossDueToDamageTaken += Conversions.getBulletDamageFromFirepower(firepower);
    }

    public static void collisionWithRobot() {
        ++collisionWithRobotCount;
    }

    public static void collisionWithWall() {
        ++collisionWithWallCount;
    }

    public static void addInboundWave() {
        ++inboundWaveCount;
    }

    public static long getInboundWaveCount() {
        return inboundWaveCount;
    }

    public static long getFiredShotCount() {
        return firedShotCount;
    }

    public static void incrementBulletHitBulletCount() {
        ++bulletHitBulletCount;
    }

    public static String getStatistics() {
        Debug.line("Turns processed: " + turnsProcessed + ", skipped: " + turnsSkipped + " ( " + Debug.trim(100.0 * (double)turnsSkipped / ((double)turnsProcessed + (double)turnsSkipped)) + "% )");
        Debug.line("Exceptions thrown: " + exceptionsThrown);
        Debug.line("Bullets fired: " + firedShotCount + ", hit: " + bulletHitRobotCount + " ( " + Debug.trim(100.0 * (double)bulletHitRobotCount / (double)firedShotCount) + "% )");
        Debug.line("Bullets hit bullet: " + bulletHitBulletCount + " ( " + Debug.trim(100.0 * (double)bulletHitBulletCount / (double)firedShotCount) + "% )");
        Debug.line("Average firepower: " + Debug.trim(energyLossDueToShotFired / (double)firedShotCount));
        Debug.line("Finished 1st: " + place[0]);
        Debug.line("Finished 2nd: " + place[1]);
        if (place[2] + place[3] + place[4] + place[5] + place[6] + place[7] + place[8] + place[9] > 0) {
            Debug.line("Finished 3rd: " + place[2]);
            int i = 3;
            while (i < 10) {
                Debug.line("Finished " + (i + 1) + "th: " + place[i]);
                ++i;
            }
        }
        long roundCount = Host.singleton.getRounds();
        StringBuffer buffer = new StringBuffer();
        buffer.append(" - Energy Management Statistics - ").append("\n");
        buffer.append("energyGainDueToShotFired: ").append(Debug.trim(energyGainDueToShotFired / (double)roundCount)).append("\n");
        buffer.append("energyLossDueToShotFired: ").append(Debug.trim(energyLossDueToShotFired / (double)roundCount)).append("\n");
        buffer.append("energyLossCausedToTarget: ").append(Debug.trim(energyLossCausedToTarget / (double)roundCount)).append("\n");
        buffer.append("energyLossDueToDamageTaken: ").append(Debug.trim(energyLossDueToDamageTaken / (double)roundCount)).append("\n");
        buffer.append("count of collisions with robots: ").append(collisionWithRobotCount).append("\n");
        buffer.append("count of collisions with walls: ").append(collisionWithWallCount).append("\n");
        return buffer.toString();
    }
}

