/*
 * Decompiled with CFR 0.152.
 */
package xander.core;

import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import robocode.AdvancedRobot;
import robocode.BattleEndedEvent;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.CustomEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.StatusEvent;
import robocode.WinEvent;
import xander.core.ComponentChain;
import xander.core.ComponentSet;
import xander.core.Configuration;
import xander.core.Resources;
import xander.core.RobotEvents;
import xander.core.RobotStyle;
import xander.core.drive.DriveController;
import xander.core.gun.Gun;
import xander.core.gun.GunController;
import xander.core.gun.XanderGun;
import xander.core.gun.targeter.HeadOnTargeter;
import xander.core.io.BattleStats;
import xander.core.io.FileIO;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.paint.ActiveComponentsPainter;
import xander.core.paint.CPUUtilizationPainter;
import xander.core.radar.RadarController;
import xander.core.track.RunTimeLogger;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;

public abstract class AbstractXanderRobot
extends AdvancedRobot {
    private static final Log log = Logger.getLog(AbstractXanderRobot.class);
    private static final ComponentChain componentChain = new ComponentChain();
    private static Gun disabledRobotGun;
    private static RunTimeLogger radarRTLogger;
    private static RunTimeLogger driveRTLogger;
    private static RunTimeLogger gunRTLogger;
    private static int skippedTurns;
    private static CPUUtilizationPainter cpuPainter;
    private RobotEvents robotEvents = Resources.getRobotEvents();
    private RadarController radarController;
    private DriveController driveController;
    private GunController gunController;
    private SnapshotHistory snapshotHistory;
    private Rectangle2D.Double battleFieldSize;
    private ComponentSet componentSet;

    protected void style(RobotStyle robotStyle) {
    }

    protected void configure(Configuration configuration) {
    }

    protected boolean recordBattleStats(Map<String, String> oppStats) {
        return false;
    }

    protected boolean recordCommonBattleStats(Map<String, String> commonStats) {
        return false;
    }

    protected abstract void addComponents(ComponentChain var1);

    public void onCustomEvent(CustomEvent event) {
        super.onCustomEvent(event);
        this.robotEvents.onCustomEvent(event);
    }

    public void onDeath(DeathEvent event) {
        super.onDeath(event);
        this.robotEvents.onDeath(event);
        Resources.onWinOrDeath();
    }

    public void onSkippedTurn(SkippedTurnEvent event) {
        super.onSkippedTurn(event);
        ++skippedTurns;
        this.robotEvents.onSkippedTurn(event);
    }

    public void onBattleEnded(BattleEndedEvent event) {
        BattleStats battleStats;
        super.onBattleEnded(event);
        this.robotEvents.onBattleEnded(event);
        if (skippedTurns > 0) {
            FileIO.logSkippedTurns(this, skippedTurns);
        }
        if (this.snapshotHistory.getOpponentCount() == 1 && (battleStats = FileIO.getBattleStats(Resources.getConfiguration())) != null) {
            String opponentName = this.snapshotHistory.getLastOpponentScanned().getName();
            Map<String, String> oppStats = battleStats.getStatsForRobot(opponentName, true);
            Map<String, String> commonStats = battleStats.getCommonStats();
            boolean oppStatsUpdated = this.recordBattleStats(oppStats);
            boolean commonStatsUpdated = this.recordCommonBattleStats(commonStats);
            if (oppStatsUpdated || commonStatsUpdated) {
                log.info("Updating battle statistics...");
                FileIO.saveBattleStats();
                log.info("Battle statistics updated.");
            }
        }
    }

    public void onBulletHit(BulletHitEvent event) {
        super.onBulletHit(event);
        this.robotEvents.onBulletHit(event);
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        super.onBulletHitBullet(event);
        this.robotEvents.onBulletHitBullet(event);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        super.onBulletMissed(event);
        this.robotEvents.onBulletMissed(event);
    }

    public void onHitByBullet(HitByBulletEvent event) {
        super.onHitByBullet(event);
        this.robotEvents.onHitByBullet(event);
    }

    public void onHitRobot(HitRobotEvent event) {
        super.onHitRobot(event);
        this.robotEvents.onHitRobot(event);
    }

    public void onHitWall(HitWallEvent event) {
        super.onHitWall(event);
        this.robotEvents.onHitWall(event);
    }

    public void onKeyPressed(KeyEvent e) {
        super.onKeyPressed(e);
        this.robotEvents.onKeyPressed(e);
    }

    public void onKeyReleased(KeyEvent e) {
        super.onKeyReleased(e);
        this.robotEvents.onKeyReleased(e);
    }

    public void onKeyTyped(KeyEvent e) {
        super.onKeyTyped(e);
        this.robotEvents.onKeyTyped(e);
    }

    public void onMouseClicked(MouseEvent e) {
        super.onMouseClicked(e);
        this.robotEvents.onMouseClicked(e);
    }

    public void onMouseDragged(MouseEvent e) {
        super.onMouseDragged(e);
        this.robotEvents.onMouseDragged(e);
    }

    public void onMouseEntered(MouseEvent e) {
        super.onMouseEntered(e);
        this.robotEvents.onMouseEntered(e);
    }

    public void onMouseExited(MouseEvent e) {
        super.onMouseExited(e);
        this.robotEvents.onMouseExited(e);
    }

    public void onMouseMoved(MouseEvent e) {
        super.onMouseMoved(e);
        this.robotEvents.onMouseMoved(e);
    }

    public void onMousePressed(MouseEvent e) {
        super.onMousePressed(e);
        this.robotEvents.onMousePressed(e);
    }

    public void onMouseReleased(MouseEvent e) {
        super.onMouseReleased(e);
        this.robotEvents.onMouseReleased(e);
    }

    public void onMouseWheelMoved(MouseWheelEvent e) {
        super.onMouseWheelMoved(e);
        this.robotEvents.onMouseWheelMoved(e);
    }

    public void onPaint(Graphics2D g) {
        super.onPaint(g);
        this.robotEvents.onPaint(g);
    }

    public void onRobotDeath(RobotDeathEvent event) {
        super.onRobotDeath(event);
        this.robotEvents.onRobotDeath(event);
    }

    public void onRoundEnded(RoundEndedEvent event) {
        super.onRoundEnded(event);
        this.robotEvents.onRoundEnded(event);
        Resources.endRound();
        if (skippedTurns > 0) {
            log.warn("Skipped turns so far: " + skippedTurns);
        }
        RunTimeLogger.logAll();
    }

    public void onScannedRobot(ScannedRobotEvent event) {
        super.onScannedRobot(event);
        this.robotEvents.onScannedRobot(event);
    }

    public void onStatus(StatusEvent e) {
        super.onStatus(e);
        this.robotEvents.onStatus(e);
    }

    public void onWin(WinEvent event) {
        super.onWin(event);
        this.robotEvents.onWin(event);
        Resources.onWinOrDeath();
    }

    public Rectangle2D.Double getBattleFieldSize() {
        return this.battleFieldSize;
    }

    public String getActiveRadarName() {
        if (this.componentSet == null) {
            return "";
        }
        if (this.componentSet.radar == null) {
            return "None";
        }
        return this.componentSet.radar.getName();
    }

    public String getActiveGunName() {
        if (this.componentSet == null) {
            return "";
        }
        if (this.componentSet.gun == null) {
            return "None";
        }
        return this.componentSet.gun.getName();
    }

    public String getActiveDriveName() {
        if (this.componentSet == null) {
            return "";
        }
        if (this.componentSet.drive == null) {
            return "None";
        }
        return this.componentSet.drive.getName();
    }

    private void initialize() {
        log.info("Configuring robot...");
        Configuration configuration = Resources.getConfiguration();
        this.style(Resources.getRobotStyle());
        this.configure(configuration);
        Resources.initialize(this);
        if (configuration.isAutoFireOnDisabledOpponents()) {
            disabledRobotGun = new XanderGun(new HeadOnTargeter(), configuration.getDisabledOpponentPowerSelector());
        }
        log.info("Setting up component chain...");
        this.addComponents(componentChain);
        if (configuration.isDrawActiveComponents()) {
            this.robotEvents.addPainter(new ActiveComponentsPainter());
        }
        radarRTLogger = RunTimeLogger.getLoggerFor("Radar");
        driveRTLogger = RunTimeLogger.getLoggerFor("Drive");
        gunRTLogger = RunTimeLogger.getLoggerFor("Gun");
        if (!configuration.isLogComponentRunTimes()) {
            radarRTLogger.setActive(false);
            driveRTLogger.setActive(false);
            gunRTLogger.setActive(false);
        }
        if (configuration.isDrawCPUUtilization()) {
            int dataPoints = configuration.getCPUUtilizationDataPoints();
            cpuPainter = new CPUUtilizationPainter(this.battleFieldSize, dataPoints);
            this.robotEvents.addPainter(cpuPainter);
        }
        log.info("Loading previous battle statistics...");
        FileIO.loadBattleStats(configuration);
        log.info("Ready for battle!");
    }

    public void run() {
        try {
            this.setAdjustGunForRobotTurn(true);
            this.setAdjustRadarForGunTurn(true);
            this.setAdjustRadarForRobotTurn(true);
            this.battleFieldSize = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
            if (this.getRoundNum() == 0) {
                this.initialize();
            }
            Resources.beginRound(this);
            Resources.getRobotStyle().apply((Robot)this);
            this.snapshotHistory = Resources.getSnapshotHistory();
            this.radarController = Resources.getRadarController();
            this.driveController = Resources.getDriveController();
            this.gunController = Resources.getGunController();
            this.componentSet = new ComponentSet();
            this.robotEvents.onRoundBegin();
            while (true) {
                if (cpuPainter != null) {
                    cpuPainter.onTurnBegin();
                }
                this.robotEvents.onTurnBegin();
                componentChain.loadComponents(this.componentSet);
                Snapshot targetRobot = null;
                if (this.componentSet.radar != null) {
                    radarRTLogger.start();
                    targetRobot = this.componentSet.radar.search(this.radarController);
                    radarRTLogger.stop();
                }
                if (targetRobot == null) {
                    if (this.componentSet.drive != null) {
                        driveRTLogger.start();
                        this.componentSet.drive.drive(this.driveController);
                        driveRTLogger.stop();
                    }
                } else {
                    if (this.componentSet.drive != null) {
                        driveRTLogger.start();
                        this.componentSet.drive.driveTo(targetRobot, this.driveController);
                        driveRTLogger.stop();
                    }
                    if (this.componentSet.gun != null) {
                        Snapshot myself = this.snapshotHistory.getMySnapshot(targetRobot.getTime());
                        if (targetRobot.getEnergy() <= 0.0 && disabledRobotGun != null) {
                            disabledRobotGun.fireAt(targetRobot, myself, this.gunController);
                        } else if (this.componentSet.gun.canFireAt(targetRobot)) {
                            gunRTLogger.start();
                            this.componentSet.gun.fireAt(targetRobot, myself, this.gunController);
                            gunRTLogger.stop();
                        }
                    }
                }
                this.robotEvents.onTurnEnd();
                if (cpuPainter != null) {
                    cpuPainter.onTurnEnd();
                }
                this.execute();
            }
        }
        catch (Exception e) {
            Resources.endRound();
            FileIO.logException(this, e);
            return;
        }
    }
}

