/*
 * Decompiled with CFR 0.152.
 */
package xander.core.gun;

import java.util.HashMap;
import java.util.Map;
import xander.core.Resources;
import xander.core.gun.Gun;
import xander.core.gun.GunSelector;
import xander.core.track.GunStats;
import xander.core.track.Snapshot;

public class VirtualHitRatioGunSelector
implements GunSelector {
    private GunStats gunStats;
    private Map<Gun, Double> biasMap = new HashMap<Gun, Double>();
    private double rollingRatioWeight = 0.6;

    public VirtualHitRatioGunSelector() {
        this.gunStats = Resources.getGunStats();
    }

    public void setRollingRatioWeight(double rollingRatioWeight) {
        this.rollingRatioWeight = rollingRatioWeight;
    }

    public void addBias(Gun gun, double bias) {
        this.biasMap.put(gun, bias);
    }

    @Override
    public int selectGun(Gun[] guns, Snapshot target) {
        int sGunIndex = 0;
        double sRatio = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < guns.length) {
            Gun gun = guns[i];
            double ratio = this.gunStats.getVirtualHitRatio(gun.getName());
            double rollingRatio = this.gunStats.getRollingVirtualHitRatio(gun.getName());
            ratio = ratio * (1.0 - this.rollingRatioWeight) + rollingRatio * this.rollingRatioWeight;
            Double bias = this.biasMap.get(gun);
            if (bias != null) {
                ratio += bias.doubleValue();
            }
            if (ratio > sRatio && guns[i].canFireAt(target)) {
                sGunIndex = i;
                sRatio = ratio;
            }
            ++i;
        }
        return sGunIndex;
    }
}

