/*
 * Decompiled with CFR 0.152.
 */
package pedersen.tactics.grail;

import java.util.ArrayList;
import java.util.List;
import pedersen.core.Constraints;
import pedersen.divination.WaveData;
import pedersen.tactics.grail.Segment;
import pedersen.tactics.targeting.TargetingMethod;

public abstract class SegmentBase {
    private final double maximumValue;
    private final int maxBinSize;
    protected int positiveBinSize;
    protected double positiveValuePerIndex;
    protected double positiveIndexPerValue;
    protected int negativeBinSize;
    protected double negativeValuePerIndex;
    protected double negativeIndexPerValue;
    private int positiveBufferBinSize;
    private double positiveBufferIndexPerValue;
    private int negativeBufferBinSize;
    private double negativeBufferIndexPerValue;
    private boolean[] positiveBuffer = new boolean[0];
    private boolean[] negativeBuffer = new boolean[0];
    protected List positiveWaveData = new ArrayList();
    protected List negativeWaveData = new ArrayList();
    protected Segment zero;
    protected Segment[] positive;
    protected Segment[] negative;

    protected SegmentBase(double newMaximumValue, int newMaxBinSize) {
        this.maximumValue = newMaximumValue;
        this.maxBinSize = newMaxBinSize;
        this.positiveBinSize = 1;
        this.negativeBinSize = 1;
        this.refresh();
    }

    protected SegmentBase(double newMaximumValue, int newPositiveBinSize, int newNegativeBinSize) {
        this.maximumValue = newMaximumValue;
        this.maxBinSize = 0;
        this.positiveBinSize = newPositiveBinSize;
        this.negativeBinSize = newNegativeBinSize;
        this.refresh();
    }

    private void refresh() {
        this.positiveValuePerIndex = this.maximumValue / (double)this.positiveBinSize;
        this.positiveIndexPerValue = (double)this.positiveBinSize / this.maximumValue;
        this.negativeValuePerIndex = this.maximumValue / (double)this.negativeBinSize;
        this.negativeIndexPerValue = (double)this.negativeBinSize / this.maximumValue;
        this.positiveBufferBinSize = this.positiveBinSize + 1;
        this.positiveBufferIndexPerValue = (double)this.positiveBufferBinSize / this.maximumValue;
        this.negativeBufferBinSize = this.negativeBinSize + 1;
        this.negativeBufferIndexPerValue = (double)this.negativeBufferBinSize / this.maximumValue;
        if (this.positiveBinSize < this.maxBinSize) {
            this.positiveBuffer = new boolean[this.positiveBufferBinSize];
        }
        if (this.negativeBinSize < this.maxBinSize) {
            this.negativeBuffer = new boolean[this.negativeBufferBinSize];
        }
    }

    protected int convertValueToSignedBinWithOffset(double value) {
        int signedBinWithOffset = 0;
        if (value > 0.0) {
            signedBinWithOffset = 1 + Math.min((int)(this.positiveIndexPerValue * value), this.positiveBinSize);
        }
        if (value < 0.0) {
            signedBinWithOffset = -(1 + Math.min((int)(this.negativeIndexPerValue * -value), this.negativeBinSize));
        }
        return signedBinWithOffset;
    }

    protected double convertSignedBinWithOffsetToValue(int signedBinWithOffset) {
        double value = 0.0;
        if (signedBinWithOffset > 0) {
            value = this.positiveValuePerIndex * (double)signedBinWithOffset;
        }
        if (signedBinWithOffset < 0) {
            value = this.negativeValuePerIndex * (double)signedBinWithOffset;
        }
        return value;
    }

    private int convertBufferValueToSignedBinWithOffset(double value) {
        int signedBinWithOffset = 0;
        if (value > 0.0) {
            signedBinWithOffset = 1 + Math.min((int)(this.positiveBufferIndexPerValue * value), this.positiveBufferBinSize);
        }
        if (value < 0.0) {
            signedBinWithOffset = -(1 + Math.min((int)(this.negativeBufferIndexPerValue * -value), this.negativeBufferBinSize));
        }
        return signedBinWithOffset;
    }

    protected boolean isTimeToResample(double value) {
        int i;
        boolean isTimeToResample = false;
        boolean allFlagsAreTrue = true;
        int index = this.convertBufferValueToSignedBinWithOffset(value);
        if (index > 0 && index <= this.positiveBinSize && this.positiveBinSize < this.maxBinSize) {
            this.positiveBuffer[index - 1] = true;
            i = 0;
            while (i < this.positiveBinSize) {
                allFlagsAreTrue &= this.positiveBuffer[i];
                ++i;
            }
            if (allFlagsAreTrue) {
                ++this.positiveBinSize;
                isTimeToResample = true;
            }
        }
        if (index < 0 && -index <= this.negativeBinSize && this.negativeBinSize < this.maxBinSize) {
            this.negativeBuffer[-index - 1] = true;
            i = 0;
            while (i < this.negativeBinSize) {
                allFlagsAreTrue &= this.negativeBuffer[i];
                ++i;
            }
            if (allFlagsAreTrue) {
                ++this.negativeBinSize;
                isTimeToResample = true;
            }
        }
        if (isTimeToResample) {
            this.refresh();
        }
        return isTimeToResample;
    }

    protected abstract void buildOrganicBins();

    public void addWaveData(WaveData waveData, double segmentValue) {
        if (this.isTimeToResample(segmentValue)) {
            this.buildOrganicBins();
        } else {
            this.addWaveDataBypass(waveData, segmentValue);
            int index = this.convertValueToSignedBinWithOffset(segmentValue);
            if (index > 0) {
                this.positiveWaveData.add(waveData);
            } else if (index < 0) {
                this.negativeWaveData.add(waveData);
            }
        }
    }

    public void addWaveDataBypass(WaveData waveData, double segmentValue) {
        this.getSegmentByValue(segmentValue).addWaveData(waveData);
    }

    public double getMostVisitedBearingOffset(WaveData waveData, double segmentValue) {
        return this.getSegmentByValue(segmentValue).getMostVisitedBearingOffset(waveData);
    }

    public double getLeastVisitedBearingOffset(WaveData waveData, double segmentValue) {
        return this.getSegmentByValue(segmentValue).getLeastVisitedBearingOffset(waveData);
    }

    public double getMostVisitedLinearProjection(WaveData waveData, double segmentValue) {
        return this.getSegmentByValue(segmentValue).getMostVisitedLinearProjection(waveData);
    }

    public TargetingMethod getFavoredTargetingMethod(WaveData waveData, double segmentValue) {
        return this.getSegmentByValue(segmentValue).getFavoredTargetingMethod(waveData);
    }

    public void debug(String prefix) {
        int i = 0;
        while (i < this.negative.length) {
            this.negative[i].debug(String.valueOf(prefix) + "-");
            ++i;
        }
        this.zero.debug(String.valueOf(prefix) + "0");
        i = 0;
        while (i < this.positive.length) {
            this.positive[i].debug(String.valueOf(prefix) + "+");
            ++i;
        }
    }

    public void debug() {
    }

    public long getHitCountByIndex(int index) {
        long hitCount = this.zero.getHitCountByIndex(index);
        int i = 0;
        while (i < this.positiveBinSize) {
            hitCount += this.positive[i].getHitCountByIndex(index);
            ++i;
        }
        i = 0;
        while (i < this.negativeBinSize) {
            hitCount += this.negative[i].getHitCountByIndex(index);
            ++i;
        }
        return hitCount;
    }

    private Segment getSegmentByValue(double value) {
        int index = this.convertValueToSignedBinWithOffset(value);
        Segment segment = index == 0 ? this.zero : (index > 0 ? this.positive[Constraints.getClosestLegalValue(0, index - 1, this.positiveBinSize - 1)] : this.negative[Constraints.getClosestLegalValue(0, -index - 1, this.negativeBinSize - 1)]);
        return segment;
    }
}

