/*
 * Decompiled with CFR 0.152.
 */
package ahr.ice;

import ahr.ice.AHRBot;
import ahr.ice.Math.Enemy;
import ahr.ice.VirtualBullet;
import java.awt.geom.Point2D;
import java.util.Enumeration;
import robocode.Condition;

public class AddEvents {
    public static void addEvents(final AHRBot r) {
        r.addCustomEvent(new Condition("wallclose"){

            public boolean test() {
                if (r.getX() <= 40.0) {
                    return true;
                }
                if (r.getX() >= r.getBattleFieldWidth() - 40.0) {
                    return true;
                }
                if (r.getY() <= 40.0) {
                    return true;
                }
                return r.getY() >= r.getBattleFieldHeight() - 40.0;
            }
        });
        r.addCustomEvent(new Condition("Robot Close"){

            public boolean test() {
                Enumeration n = AHRBot.targets.elements();
                while (n.hasMoreElements()) {
                    Enemy enem = (Enemy)n.nextElement();
                    if (!enem.live) continue;
                    Point2D.Double double_ = new Point2D.Double(r.getX(), r.getY());
                    if (!(double_.distance(enem.x, enem.y) < 100.0)) continue;
                    return true;
                }
                return false;
            }
        });
        r.addCustomEvent(new Condition("Bullet Close"){

            public boolean test() {
                for (VirtualBullet vb : AHRBot.virtualBullets) {
                    if (!(r.position().distance(vb) < 50.0) || !vb.target.name.equals(r.getName())) continue;
                    return true;
                }
                return false;
            }
        });
    }
}

