/*
 * Decompiled with CFR 0.152.
 */
package ahr.ice;

import ahr.ice.AHRBot;
import ahr.ice.Gun;
import ahr.ice.Math.Enemy;
import ahr.ice.Math.math;
import ahr.ice.RobotState;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import robocode.Rules;
import robocode.util.Utils;

class MeanIterativeGun
extends Gun {
    MeanIterativeGun() {
    }

    @Override
    public String getName() {
        return "Mean Iterative";
    }

    @Override
    public Color getColor() {
        return new Color(250, 120, 0);
    }

    @Override
    public double getFiringAngle(RobotState shooter, RobotState target, double bulletPower, Rectangle2D.Double battlefield) {
        Enemy en = AHRBot.setupEnemy(target.name);
        double ROBOT_WIDTH = 16.0;
        double ROBOT_HEIGHT = 16.0;
        RobotState eC = new RobotState();
        eC.setLocation(en.coords);
        double eAbsBearing = shooter.absoluteAngleTo(eC);
        double rX = shooter.x;
        double rY = shooter.y;
        double bV = Rules.getBulletSpeed((double)bulletPower);
        double eX = rX + shooter.distance(en.coords) * Math.sin(eAbsBearing);
        double eY = rY + shooter.distance(en.coords) * Math.cos(eAbsBearing);
        double eV = en.meanVelocity;
        double eHd = en.heading;
        double eHc = en.meanHeadingChange;
        double A = (eX - rX) / bV;
        double B = eV / bV * Math.sin(eHd);
        double C = (eY - rY) / bV;
        double D = eV / bV * Math.cos(eHd);
        double a = A * A + C * C;
        double b = 2.0 * (A * B + C * D);
        double c = B * B + D * D - 1.0;
        double discrim = b * b - 4.0 * a * c;
        double t1 = 2.0 * a / (-b - Math.sqrt(discrim));
        double t2 = 2.0 * a / (-b + Math.sqrt(discrim));
        double t = Math.min(t1, t2) >= 0.0 ? Math.min(t1, t2) : Math.max(t1, t2);
        double endX = math.limit(eX + eV * t * Math.sin(eHd), 8.0, this.getBattleFieldWidth(battlefield) - 8.0);
        double endY = math.limit(eY + eV * t * Math.cos(eHd), 8.0, this.getBattleFieldHeight(battlefield) - 8.0);
        return Utils.normalRelativeAngle((double)Math.atan2(endX - rX, endY - rY));
    }
}

