/*
 * Decompiled with CFR 0.152.
 */
package bjl.fire;

import bjl.BattleField;
import bjl.Blip;
import bjl.Enemy;
import bjl.FireDemand;
import bjl.Point;
import bjl.Utils;
import bjl.fire.FireStrategy;

public class Avg2Linear
extends FireStrategy {
    public String toString() {
        return "Avg2Linear";
    }

    public Point getPosition(long time) {
        Blip target = this.enemy.getLastBlip();
        double vel = this.enemy.getAvgDistVel(time - 40L, time);
        if (target.vel < 0.0) {
            vel = -vel;
        }
        double movex = vel * (double)time * Math.sin(Math.toRadians(target.head));
        double movey = vel * (double)time * Math.cos(Math.toRadians(target.head));
        return new Point(target.pos.x + movex, target.pos.y + movey);
    }

    protected FireDemand getFireDemand() {
        long time = BattleField.getTime();
        Blip target = this.enemy.getLastBlip();
        Point p = this.getPosition(time - target.time);
        double vel = this.enemy.getAvgDistVel(time - 40L, time);
        if (target.vel < 0.0) {
            vel = -vel;
        }
        Point myPos = BattleField.getPos();
        double dist = p.dist(myPos);
        double prob = this.getProb();
        double power = this.getPower(target.pos.dist(myPos));
        if (power < 0.1) {
            power = 0.1;
        }
        if (power > (double)3) {
            power = 3;
        }
        double bspeed = 20.0 - (double)3 * power;
        double phi = Math.toRadians(target.head) - 1.5707963267948966 + Math.atan2(p.y - myPos.y, p.x - myPos.x);
        double angle = Math.asin(Math.sin(phi) * vel / bspeed) * 1.06;
        double bear = Utils.normalHeading(90.0 - Math.toDegrees(Math.atan2(p.y - myPos.y, p.x - myPos.x) - angle));
        p = Point.makePoint(myPos, bear, dist *= Math.sin(Math.PI - phi) / Math.sin(phi - angle));
        if (p.isOutsideArena()) {
            return new FireDemand(0.0, -1.0, 0.0, 0.0, this);
        }
        if (this.bulletsFired < 5) {
            prob = 1.0;
        }
        return new FireDemand(power, prob, bear, dist, this);
    }

    public Avg2Linear(Enemy t) {
        super(t);
    }
}

