/*
 * Decompiled with CFR 0.152.
 */
package kid.graphics;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import kid.graphics.Colors;
import kid.graphics.Menu;
import kid.graphics.RGraphics;

public class DrawMenu {
    public static double START_X = 0.0;
    public static double START_Y = 1.0;
    public static final double RECTANGLE_WIDTH = 70.0;
    public static final double RECTANGLE_HEIGHT = 12.0;
    public static final double STRING_OFFSET_X = 2.0;
    public static final double STRING_OFFSET_Y = 2.0;
    public static final Color MENU_OPEN = Colors.TURQUOISE;
    public static final Color MENU_CLOSED = Colors.RED;
    public static final Color ITEM_ON = Colors.LIME_GREEN;
    public static final Color ITEM_OFF = Colors.RED;
    private static boolean open = false;
    private static ArrayList<Menu> menus = new ArrayList();

    public static void add(String item, String menu) {
        DrawMenu.add(item, menu, false);
    }

    public static void add(String item, String menu, boolean def) {
        Menu m = DrawMenu.getMenu(menu);
        if (m == null) {
            m = new Menu(menu);
            menus.add(m);
        }
        m.add(item, def);
    }

    public static boolean getValue(String item, String menu) {
        return DrawMenu.getValue(item, menu, false);
    }

    public static boolean getValue(String item, String menu, boolean def) {
        Menu m = DrawMenu.getMenu(menu);
        if (m != null) {
            return m.getValue(item, def);
        }
        DrawMenu.add(item, menu, def);
        return def;
    }

    public static void inMouseEvent(MouseEvent e) {
        if (e.getID() == 500) {
            if (open) {
                boolean found = false;
                int i = 0;
                while (i < menus.size() && !found) {
                    found = menus.get(i).inMouseEvent(e, START_X + 71.0, START_Y + ((double)i + 1.0) * 13.0);
                    ++i;
                }
                if (!found) {
                    double x = (double)e.getX() - START_X;
                    double y = (double)e.getY() - START_Y;
                    if (x <= 70.0 && x >= 0.0 && y >= 13.0) {
                        int i2 = 0;
                        while (i2 < menus.size() && !found) {
                            if (y <= ((double)i2 + 2.0) * 13.0) {
                                Menu menu = menus.get(i2);
                                if (menu.status()) {
                                    menu.close();
                                } else {
                                    for (Menu m : menus) {
                                        m.close();
                                    }
                                    menu.open();
                                }
                                found = true;
                            }
                            ++i2;
                        }
                    }
                    if (!found) {
                        open = false;
                        for (Menu m : menus) {
                            m.close();
                        }
                    }
                }
            } else {
                double x = (double)e.getX() - START_X;
                double y = (double)e.getY() - START_Y;
                if (x <= 70.0 && y <= 13.0 && y >= 0.0 && x >= 0.0) {
                    open = true;
                }
            }
        }
    }

    public static void draw(RGraphics grid) {
        grid.setColor(MENU_CLOSED);
        if (open) {
            int i = 0;
            while (i < menus.size()) {
                Menu menu = menus.get(i);
                grid.setColor(menu.status() ? MENU_OPEN : MENU_CLOSED);
                grid.drawRect(START_X, START_Y + ((double)i + 1.0) * 13.0, 70.0, 12.0);
                grid.drawString(menu.getName(), START_X + 2.0, START_Y + 2.0 + ((double)i + 1.0) * 13.0);
                menu.draw(grid, START_X + 71.0, START_Y + ((double)i + 1.0) * 13.0);
                ++i;
            }
            grid.setColor(MENU_OPEN);
        }
        grid.drawRect(START_X, START_Y, 70.0, 12.0);
        grid.drawString("Draw Menu", START_X + 2.0, START_Y + 2.0);
    }

    private static Menu getMenu(String n) {
        for (Menu m : menus) {
            if (!m.getName().equals(n)) continue;
            return m;
        }
        return null;
    }
}

