/*
 * Decompiled with CFR 0.152.
 */
package kid.movement.robot;

import java.awt.geom.Point2D;
import kid.info.RobotInfo;
import kid.robot.RobotData;
import kid.robot.RobotVector;
import kid.utils.Utils;
import robocode.AdvancedRobot;
import robocode.Robot;

public class RobotMovement {
    private Robot robot;
    private AdvancedRobot advancedRobot;
    private RobotInfo info;
    public static final int FORWARD = 1;
    public static final int BACKWARD = -1;
    private static final double MAX_DIST_RATIO = 1.75;
    private static final double MIN_DIST_RATIO = 0.25;

    public RobotMovement(Robot myRobot) {
        this.init(myRobot);
    }

    private void init(Robot myRobot) {
        this.robot = myRobot;
        if (this.robot instanceof AdvancedRobot) {
            this.advancedRobot = (AdvancedRobot)this.robot;
        }
        this.info = new RobotInfo(this.robot);
    }

    public void right(double a) {
        this.robot.turnRight(a);
    }

    public void setRight(double a) {
        if (this.advancedRobot != null) {
            this.advancedRobot.setTurnRight(a);
        }
    }

    public void ahead(double d) {
        this.robot.ahead(d);
    }

    public void setAhead(double d) {
        if (this.advancedRobot != null) {
            this.advancedRobot.setAhead(d);
        }
    }

    public void left(double a) {
        this.robot.turnLeft(a);
    }

    public void setLeft(double a) {
        if (this.advancedRobot != null) {
            this.advancedRobot.setTurnLeft(a);
        }
    }

    public void back(double d) {
        this.robot.back(d);
    }

    public void setBack(double d) {
        if (this.advancedRobot != null) {
            this.advancedRobot.setBack(d);
        }
    }

    public final void turnToAngle(double angle) {
        double theta = this.info.bearing(angle);
        this.right(theta);
    }

    public final void setTurnToAngle(double angle) {
        double theta = this.info.bearing(angle);
        this.setRight(theta);
    }

    public final void turnPerpenToAngle(double angle) {
        double theta = this.info.bearing(angle + 90.0);
        this.right(theta);
    }

    public final void setTurnPerpenToAngle(double angle) {
        double theta = this.info.bearing(angle + 90.0);
        this.setRight(theta);
    }

    public final void turnPerpenToAnglewDC(double angle, double curDist, double desiredDist) {
        double distRatio = RobotMovement.distRatio(curDist, desiredDist);
        double theta = this.info.bearing(angle + 90.0 * distRatio);
        this.right(theta);
    }

    public final void setTurnPerpenToAnglewDC(double angle, double curDist, double desiredDist) {
        double distRatio = RobotMovement.distRatio(curDist, desiredDist);
        double theta = this.info.bearing(angle + 90.0 * distRatio);
        this.setRight(theta);
    }

    public final int turnToAnglewBF(double angle) {
        double theta = this.info.bearing(angle);
        if (Math.abs(theta) < 90.0) {
            this.right(theta);
            return 1;
        }
        this.right(Utils.oppositeRelative(theta));
        return -1;
    }

    public final int setTurnToAnglewBF(double angle) {
        double theta = this.info.bearing(angle);
        if (Math.abs(theta) < 90.0) {
            this.setRight(theta);
            return 1;
        }
        this.setRight(Utils.oppositeRelative(theta));
        return -1;
    }

    public final int turnPerpenToAnglewBF(double angle) {
        double theta = Utils.relative(angle + 90.0);
        return this.turnToAnglewBF(theta);
    }

    public final int setTurnPerpenToAnglewBF(double angle) {
        double theta = Utils.relative(angle + 90.0);
        return this.setTurnToAnglewBF(theta);
    }

    public final int turnPerpenToAnglewBFwDC(double angle, double curDist, double desiredDist) {
        double distRatio = RobotMovement.distRatio(curDist, desiredDist);
        double right = this.info.bearing(angle + 90.0 * distRatio);
        double left = this.info.bearing(angle - 90.0 * distRatio);
        double ahead = Utils.absMin(right, left);
        double back = Utils.absMin(Utils.oppositeRelative(right), Utils.oppositeRelative(left));
        if (Math.abs(ahead) < Math.abs(back)) {
            this.right(ahead);
            return 1;
        }
        this.right(back);
        return -1;
    }

    public final int setTurnPerpenToAnglewBFwDC(double angle, double curDist, double desiredDist) {
        double distRatio = RobotMovement.distRatio(curDist, desiredDist);
        double right = this.info.bearing(angle + 90.0 * distRatio);
        double left = this.info.bearing(angle - 90.0 * distRatio);
        double ahead = Utils.absMin(right, left);
        double back = Utils.absMin(Utils.oppositeRelative(right), Utils.oppositeRelative(left));
        if (Math.abs(ahead) < Math.abs(back)) {
            this.setRight(ahead);
            return 1;
        }
        this.setRight(back);
        return -1;
    }

    public static final void vectorTurnPerpenToAnglewBFeDC(RobotVector vector, double angle, double curDist, double desiredDist) {
        double distRatio = RobotMovement.distRatio(curDist, desiredDist);
        double right = Utils.relative(angle + 90.0 * distRatio - vector.getHeading());
        double left = Utils.relative(angle - 90.0 * distRatio - vector.getHeading());
        double ahead = Utils.absMin(right, left);
        double back = Utils.absMin(Utils.oppositeRelative(right), Utils.oppositeRelative(left));
        if (Math.abs(ahead) < Math.abs(back)) {
            vector.rotate(ahead);
            vector.velocity(Math.abs(vector.getVelocity()));
        } else {
            vector.rotate(back);
            vector.velocity(-Math.abs(vector.getVelocity()));
        }
    }

    public final void setTurnPerpenToAnglewBFwDCwRM(double angle, double curDist, double desiredDist) {
        double distRatio = RobotMovement.distRatio(curDist, desiredDist);
        double right = this.info.bearing(angle + 90.0 * distRatio);
        double left = this.info.bearing(angle - 90.0 * distRatio);
        double ahead = Utils.absMin(right, left);
        double back = Utils.absMin(Utils.oppositeRelative(right), Utils.oppositeRelative(left));
        if (this.info.getMovingSign() == -1) {
            this.setRight(back);
        } else {
            this.setRight(ahead);
        }
    }

    public final void turnToXY(double x, double y) {
        double theta = this.info.bearing(x, y);
        this.right(theta);
    }

    public final void setTurnToXY(double x, double y) {
        double theta = this.info.bearing(x, y);
        this.setRight(theta);
    }

    public final void turnPerpenToXY(double x, double y) {
        double theta = Utils.relative(this.info.bearing(x, y) + 90.0);
        this.right(theta);
    }

    public final void setTurnPerpenToXY(double x, double y) {
        double theta = Utils.relative(this.info.bearing(x, y) + 90.0);
        this.setRight(theta);
    }

    public final int turnToXYwBF(double x, double y) {
        double theta = this.info.angle(x, y);
        return this.turnToAnglewBF(theta);
    }

    public final int setTurnToXYwBF(double x, double y) {
        double theta = this.info.angle(x, y);
        return this.setTurnToAnglewBF(theta);
    }

    public final int turnPerpenToXYwBF(double x, double y) {
        double theta = Utils.relative(this.info.angle(x, y) + 90.0);
        return this.turnToAnglewBF(theta);
    }

    public final int setTurnPerpenToXYwBF(double x, double y) {
        double theta = Utils.relative(this.info.angle(x, y) + 90.0);
        return this.setTurnToAnglewBF(theta);
    }

    public final int turnPerpenToXYwBFwDC(double x, double y, double desiredDist) {
        return this.setTurnPerpenToAnglewBFwDC(this.info.angle(x, y), this.info.dist(x, y), desiredDist);
    }

    public final int setTurnPerpenToXYwBFwDC(double x, double y, double disiredDist) {
        return this.setTurnPerpenToAnglewBFwDC(this.info.angle(x, y), this.info.dist(x, y), disiredDist);
    }

    public final void setTurnPerpenToXYwBFwDCwRM(double x, double y, double disiredDist) {
        this.setTurnPerpenToAnglewBFwDCwRM(this.info.angle(x, y), this.info.dist(x, y), disiredDist);
    }

    public final void moveToXY(double x, double y) {
        this.ahead(this.info.dist(x, y) * (double)this.turnToXYwBF(x, y));
    }

    public final void setMoveToXY(double x, double y) {
        this.setAhead(this.info.dist(x, y) * (double)this.setTurnToXYwBF(x, y));
    }

    public final void turnToRobot(RobotData robot) {
        double theta = this.info.bearing(robot);
        this.right(theta);
    }

    public final void setTurnToRobot(RobotData robot) {
        double theta = this.info.bearing(robot);
        this.setRight(theta);
    }

    public final void turnPerpenToRobot(RobotData robot) {
        double theta = Utils.relative(this.info.bearing(robot) + 90.0);
        this.right(theta);
    }

    public final void setTurnPerpenToRobot(RobotData robot) {
        double theta = Utils.relative(this.info.bearing(robot) + 90.0);
        this.setRight(theta);
    }

    public final int turnToRobotwBF(RobotData robot) {
        double theta = this.info.angle(robot);
        return this.turnToAnglewBF(theta);
    }

    public final int setTurnToRobotwBF(RobotData robot) {
        double theta = this.info.angle(robot);
        return this.setTurnToAnglewBF(theta);
    }

    public final int turnPerpenToRobotwBF(RobotData robot) {
        double theta = Utils.relative(this.info.angle(robot) + 90.0);
        return this.turnToAnglewBF(theta);
    }

    public final int setTurnPerpenToRobotwBF(RobotData robot) {
        double theta = Utils.relative(this.info.angle(robot) + 90.0);
        return this.setTurnToAnglewBF(theta);
    }

    public final int turnPerpenToRobotwBFwDC(RobotData robot, double desiredDist) {
        return this.turnPerpenToAnglewBFwDC(this.info.angle(robot), this.info.dist(robot), desiredDist);
    }

    public final int setTurnPerpenToRobotwBFwDC(RobotData robot, double desiredDist) {
        return this.setTurnPerpenToAnglewBFwDC(this.info.angle(robot), this.info.dist(robot), desiredDist);
    }

    public final void setTurnPerpenToRobotwBFwDCwRM(RobotData robot, double desiredDist) {
        this.setTurnPerpenToAnglewBFwDCwRM(this.info.angle(robot), this.info.dist(robot), desiredDist);
    }

    public final void turnToPoint(Point2D point) {
        double theta = this.info.bearing(point);
        this.right(theta);
    }

    public final void setTurnToPoint(Point2D point) {
        double theta = this.info.bearing(point);
        this.setRight(theta);
    }

    public final void turnPerpenToPoint(Point2D point) {
        double theta = Utils.relative(this.info.bearing(point) + 90.0);
        this.right(theta);
    }

    public final void setTurnPerpenToPoint(Point2D point) {
        double theta = Utils.relative(this.info.bearing(point) + 90.0);
        this.setRight(theta);
    }

    public final int turnToPointwBF(Point2D point) {
        double theta = this.info.angle(point);
        return this.turnToAnglewBF(theta);
    }

    public final int setTurnToPointwBF(Point2D point) {
        double theta = this.info.angle(point);
        return this.setTurnToAnglewBF(theta);
    }

    public final int turnPerpenToPointwBF(Point2D point) {
        double theta = Utils.relative(this.info.angle(point) + 90.0);
        return this.turnToAnglewBF(theta);
    }

    public final int setTurnPerpenToPointwBF(Point2D point) {
        double theta = Utils.relative(this.info.angle(point) + 90.0);
        return this.setTurnToAnglewBF(theta);
    }

    public final int turnPerpenToPointwBFwDC(Point2D point, double desiredDist) {
        return this.turnPerpenToAnglewBFwDC(this.info.angle(point), this.info.dist(point), desiredDist);
    }

    public final int setTurnPerpenToPointwBFwDC(Point2D point, double desiredDist) {
        return this.setTurnPerpenToAnglewBFwDC(this.info.angle(point), this.info.dist(point), desiredDist);
    }

    public final void setTurnPerpenToPointwBFwDCwRM(Point2D point, double desiredDist) {
        this.setTurnPerpenToAnglewBFwDCwRM(this.info.angle(point), this.info.dist(point), desiredDist);
    }

    public final void moveToPoint(Point2D point) {
        this.moveToXY(point.getX(), point.getY());
    }

    public final void setMoveToPoint(Point2D point) {
        this.setMoveToXY(point.getX(), point.getY());
    }

    public final void setSmoothWalls() {
        double myX = this.info.getX();
        double myY = this.info.getY();
        double wallGrace = 0.0;
        double turnRadius = RobotInfo.turnRadius(8.0) + 8.0;
        double rightAngle = 0.0;
        double leftAngle = 0.0;
        boolean TWO_WALLS = false;
        boolean WEST = false;
        boolean SOUTH = false;
        boolean EAST = false;
        boolean NORTH = false;
        double distNorth = Math.max(this.info.getBattleFieldHeight() - myY - RobotInfo.MIN_WALL_DIST - wallGrace, 0.0);
        double distEast = Math.max(this.info.getBattleFieldWidth() - myX - RobotInfo.MIN_WALL_DIST - wallGrace, 0.0);
        double distSouth = Math.max(myY - RobotInfo.MIN_WALL_DIST - wallGrace, 0.0);
        double distWest = Math.max(myX - RobotInfo.MIN_WALL_DIST - wallGrace, 0.0);
        NORTH = distNorth <= 2.0 * turnRadius;
        EAST = distEast <= 2.0 * turnRadius;
        SOUTH = distSouth <= 2.0 * turnRadius;
        WEST = distWest <= 2.0 * turnRadius;
        double northOffsetAngle = 0.0;
        double eastOffsetAngle = 0.0;
        double southOffsetAngle = 0.0;
        double westOffsetAngle = 0.0;
        if (distNorth <= turnRadius || NORTH && (EAST || WEST)) {
            northOffsetAngle = RobotMovement.wallOffsetAngle(distNorth, turnRadius);
        }
        if (distEast <= turnRadius || EAST && (NORTH || SOUTH)) {
            eastOffsetAngle = RobotMovement.wallOffsetAngle(distEast, turnRadius);
        }
        if (distSouth <= turnRadius || SOUTH && (EAST || WEST)) {
            southOffsetAngle = RobotMovement.wallOffsetAngle(distSouth, turnRadius);
        }
        if (distWest <= turnRadius || WEST && (NORTH || SOUTH)) {
            westOffsetAngle = RobotMovement.wallOffsetAngle(distWest, turnRadius);
        }
        if (NORTH) {
            if (EAST) {
                TWO_WALLS = true;
                leftAngle = Math.min(-northOffsetAngle, 90.0 - eastOffsetAngle);
                rightAngle = Math.max(90.0 + eastOffsetAngle, northOffsetAngle);
            } else if (WEST) {
                TWO_WALLS = true;
                leftAngle = Math.min(-90.0 - westOffsetAngle, -northOffsetAngle);
                rightAngle = Math.max(northOffsetAngle, -90.0 + westOffsetAngle);
            } else if (distNorth <= turnRadius) {
                leftAngle = -northOffsetAngle;
                rightAngle = northOffsetAngle;
            }
        } else if (SOUTH) {
            if (EAST) {
                TWO_WALLS = true;
                leftAngle = Math.min(90.0 - eastOffsetAngle, 180.0 - southOffsetAngle);
                rightAngle = Math.max(180.0 + southOffsetAngle, 90.0 + eastOffsetAngle);
            } else if (WEST) {
                TWO_WALLS = true;
                leftAngle = Math.min(-180.0 - southOffsetAngle, -90.0 - westOffsetAngle);
                rightAngle = Math.max(-90.0 + westOffsetAngle, -180.0 + southOffsetAngle);
            } else if (distSouth <= turnRadius) {
                leftAngle = 180.0 - southOffsetAngle;
                rightAngle = 180.0 + southOffsetAngle;
            }
        } else if (EAST && distEast <= turnRadius) {
            leftAngle = 90.0 - eastOffsetAngle;
            rightAngle = 90.0 + eastOffsetAngle;
        } else if (WEST && distWest <= turnRadius) {
            leftAngle = -90.0 - westOffsetAngle;
            rightAngle = -90.0 + westOffsetAngle;
        }
        double dangerAngle = Utils.absolute(rightAngle - leftAngle);
        if (TWO_WALLS && leftAngle > rightAngle && (distNorth > turnRadius && NORTH || distEast > turnRadius && EAST || distSouth > turnRadius && SOUTH || distWest > turnRadius && WEST)) {
            dangerAngle = Utils.absolute(leftAngle - rightAngle);
        }
        double movingHeading = (this.info.getMovingSign() < 0 ? Utils.oppositeRelative(this.info.getHeading()) : this.info.getHeading()) + this.info.getTurn();
        boolean testBetween = Utils.absolute(movingHeading - leftAngle) < dangerAngle;
        boolean bl = testBetween = testBetween && Utils.absolute(rightAngle - movingHeading) < dangerAngle;
        if (testBetween) {
            this.setRight(Utils.absMin(Utils.relative(leftAngle - movingHeading), Utils.relative(rightAngle - movingHeading)));
        }
    }

    public final double setSmoothWalls(double x, double y, double heading) {
        double wallGrace = 0.0;
        double turnRadius = RobotInfo.turnRadius(8.0) + 8.0;
        double rightAngle = 0.0;
        double leftAngle = 0.0;
        boolean TWO_WALLS = false;
        boolean WEST = false;
        boolean SOUTH = false;
        boolean EAST = false;
        boolean NORTH = false;
        double distNorth = Math.max(this.info.getBattleFieldHeight() - y - RobotInfo.MIN_WALL_DIST - wallGrace, 0.0);
        double distEast = Math.max(this.info.getBattleFieldWidth() - x - RobotInfo.MIN_WALL_DIST - wallGrace, 0.0);
        double distSouth = Math.max(y - RobotInfo.MIN_WALL_DIST - wallGrace, 0.0);
        double distWest = Math.max(x - RobotInfo.MIN_WALL_DIST - wallGrace, 0.0);
        NORTH = distNorth <= 2.0 * turnRadius;
        EAST = distEast <= 2.0 * turnRadius;
        SOUTH = distSouth <= 2.0 * turnRadius;
        WEST = distWest <= 2.0 * turnRadius;
        double northOffsetAngle = 0.0;
        double eastOffsetAngle = 0.0;
        double southOffsetAngle = 0.0;
        double westOffsetAngle = 0.0;
        if (distNorth <= turnRadius || NORTH && (EAST || WEST)) {
            northOffsetAngle = RobotMovement.wallOffsetAngle(distNorth, turnRadius);
        }
        if (distEast <= turnRadius || EAST && (NORTH || SOUTH)) {
            eastOffsetAngle = RobotMovement.wallOffsetAngle(distEast, turnRadius);
        }
        if (distSouth <= turnRadius || SOUTH && (EAST || WEST)) {
            southOffsetAngle = RobotMovement.wallOffsetAngle(distSouth, turnRadius);
        }
        if (distWest <= turnRadius || WEST && (NORTH || SOUTH)) {
            westOffsetAngle = RobotMovement.wallOffsetAngle(distWest, turnRadius);
        }
        if (NORTH) {
            if (EAST) {
                TWO_WALLS = true;
                leftAngle = Math.min(-northOffsetAngle, 90.0 - eastOffsetAngle);
                rightAngle = Math.max(90.0 + eastOffsetAngle, northOffsetAngle);
            } else if (WEST) {
                TWO_WALLS = true;
                leftAngle = Math.min(-90.0 - westOffsetAngle, -northOffsetAngle);
                rightAngle = Math.max(northOffsetAngle, -90.0 + westOffsetAngle);
            } else if (distNorth <= turnRadius) {
                leftAngle = -northOffsetAngle;
                rightAngle = northOffsetAngle;
            }
        } else if (SOUTH) {
            if (EAST) {
                TWO_WALLS = true;
                leftAngle = Math.min(90.0 - eastOffsetAngle, 180.0 - southOffsetAngle);
                rightAngle = Math.max(180.0 + southOffsetAngle, 90.0 + eastOffsetAngle);
            } else if (WEST) {
                TWO_WALLS = true;
                leftAngle = Math.min(-180.0 - southOffsetAngle, -90.0 - westOffsetAngle);
                rightAngle = Math.max(-90.0 + westOffsetAngle, -180.0 + southOffsetAngle);
            } else if (distSouth <= turnRadius) {
                leftAngle = 180.0 - southOffsetAngle;
                rightAngle = 180.0 + southOffsetAngle;
            }
        } else if (EAST && distEast <= turnRadius) {
            leftAngle = 90.0 - eastOffsetAngle;
            rightAngle = 90.0 + eastOffsetAngle;
        } else if (WEST && distWest <= turnRadius) {
            leftAngle = -90.0 - westOffsetAngle;
            rightAngle = -90.0 + westOffsetAngle;
        }
        double dangerAngle = Utils.absolute(rightAngle - leftAngle);
        if (TWO_WALLS && leftAngle > rightAngle && (distNorth > turnRadius && NORTH || distEast > turnRadius && EAST || distSouth > turnRadius && SOUTH || distWest > turnRadius && WEST)) {
            dangerAngle = Utils.absolute(leftAngle - rightAngle);
        }
        boolean testBetween = Utils.absolute(heading - leftAngle) < dangerAngle;
        boolean bl = testBetween = testBetween && Utils.absolute(rightAngle - heading) < dangerAngle;
        if (testBetween) {
            heading += Utils.absMin(Utils.relative(leftAngle - heading), Utils.relative(rightAngle - heading));
        }
        return heading;
    }

    private static final double distRatio(double curDist, double desiredDist) {
        return Utils.limit(0.25, desiredDist / curDist, 1.75);
    }

    private static final double wallOffsetAngle(double distFromWall, double turnRadius) {
        double offsetAngle;
        if (turnRadius > distFromWall) {
            offsetAngle = Utils.acos(distFromWall / turnRadius);
            offsetAngle = turnRadius == 0.0 ? 0.0 : offsetAngle;
        } else {
            offsetAngle = -Utils.acos((2.0 * turnRadius - distFromWall) / turnRadius);
            offsetAngle = distFromWall == 0.0 ? 0.0 : offsetAngle;
        }
        return offsetAngle;
    }
}

