/*
 * Decompiled with CFR 0.152.
 */
package techdude.forest;

import java.util.Enumeration;
import techdude.forest.DefaultPattern;
import techdude.forest.FlamingForest;
import techdude.forest.Pattern;
import techdude.forest.StrafingPattern;
import techdude.forest.TechDudeRecord;
import techdude.forest.TechDudeRecordCollection;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class PatternAnalyzer
implements Runnable {
    public static final Pattern DEFAULT = new DefaultPattern();
    private static final Pattern[] ALL_PATTERNS = new Pattern[]{new StrafingPattern()};
    private static final long SLEEP_INTERVAL = 500L;
    public FlamingForest m_owner;
    private Thread m_thread;
    private boolean shouldRun;

    public void startAnalyzer() {
        if (!this.shouldRun) {
            this.shouldRun = true;
            this.m_thread = new Thread(this);
            this.m_thread.start();
        }
    }

    public void stopAnalyzer() {
        if (this.shouldRun) {
            try {
                this.shouldRun = false;
                this.m_thread.interrupt();
            }
            catch (SecurityException error) {
                FlamingForest.debug("WARNING - Could Not Stop Pattern Analyzer, Security Exception");
            }
        }
    }

    public void run() {
        try {
            FlamingForest.debug("Init Enemy Pattern Analysis System...");
            Enumeration allElements = null;
            TechDudeRecordCollection current = null;
            TechDudeRecord[] strand = null;
            int numberOfPatterns = ALL_PATTERNS.length;
            int counter = 0;
            boolean result = false;
            while (this.shouldRun) {
                Thread.sleep(500L);
                allElements = FlamingForest.m_scannedInformation.elements();
                while (allElements.hasMoreElements()) {
                    current = (TechDudeRecordCollection)allElements.nextElement();
                    strand = current.getLatestStrand();
                    if (strand == null) continue;
                    counter = numberOfPatterns - 1;
                    while (counter >= 0) {
                        result = ALL_PATTERNS[counter].test(strand);
                        if (result && ALL_PATTERNS[counter].getClass() != current.getPattern().getClass()) {
                            current.setPattern(ALL_PATTERNS[counter]);
                        } else if (!result && ALL_PATTERNS[counter].getClass() == current.getPattern().getClass() && current.getPattern() != DEFAULT) {
                            current.setPattern(DEFAULT);
                        }
                        --counter;
                    }
                }
            }
        }
        catch (InterruptedException error) {
            FlamingForest.debug("Stopping Pattern Analyzer");
        }
    }

    private final /* synthetic */ void this() {
        this.m_owner = null;
        this.m_thread = null;
        this.shouldRun = false;
    }

    public PatternAnalyzer(FlamingForest in_owner) {
        this.this();
        this.m_owner = in_owner;
    }
}

