/*
 * Decompiled with CFR 0.152.
 */
package gun;

import java.awt.geom.Point2D;
import util.TimedPoint;

public class BulletVector
extends Point2D {
    Point2D startPos;
    private double angle;
    private double magnitude;
    private long time;
    private int gunID;

    public BulletVector(TimedPoint startPos, double a, double m, int gID) {
        this.startPos = new Point2D.Double(startPos.getX(), startPos.getY());
        this.angle = a;
        this.magnitude = m;
        this.time = startPos.getTime();
        this.gunID = gID;
    }

    public BulletVector(TimedPoint startPos, Point2D endPos, int gID) {
        this.startPos = startPos;
        this.angle = Math.atan2(endPos.getX() - startPos.getX(), endPos.getY() - startPos.getY());
        this.magnitude = startPos.distance(endPos);
        this.time = startPos.getTime();
        this.gunID = gID;
    }

    public Point2D getStartPos() {
        return new Point2D.Double(this.startPos.getX(), this.startPos.getY());
    }

    public double getAngle() {
        return this.angle;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public void setMagnitude(double m) {
        this.magnitude = m;
    }

    public void scaleMagnitude(double scaleFactor) {
        this.magnitude *= scaleFactor;
    }

    public Point2D.Double project() {
        return new Point2D.Double(Math.sin(this.angle) * this.magnitude, Math.cos(this.angle) * this.magnitude);
    }

    public Point2D.Double projectFromStartPos(double currentTime) {
        return new Point2D.Double(this.startPos.getX() + Math.sin(this.angle) * this.magnitude * (currentTime - (double)this.time), this.startPos.getY() + Math.cos(this.angle) * this.magnitude * (currentTime - (double)this.time));
    }

    public Point2D.Double projectByRad(double rad) {
        return new Point2D.Double(this.startPos.getX() + Math.sin(this.angle) * rad, this.startPos.getY() + Math.cos(this.angle) * rad);
    }

    public double getLengthAtTime(double currentTime) {
        return this.magnitude * (currentTime - (double)this.time);
    }

    public int getGunID() {
        return this.gunID;
    }

    @Override
    public double getX() {
        return this.startPos.getX();
    }

    @Override
    public double getY() {
        return this.startPos.getY();
    }

    @Override
    public void setLocation(double arg0, double arg1) {
        this.startPos = new Point2D.Double(arg0, arg1);
    }

    public long getTime() {
        return this.time;
    }

    public long getAge(long currentTime) {
        return currentTime - this.time;
    }
}

