/*
 * Decompiled with CFR 0.152.
 */
package origin;

import java.awt.geom.Point2D;
import java.util.LinkedList;
import origin.EDataDispVector;
import origin.Enemy;
import origin.EnemyStateML;
import util.Vector2D;

public class EnemyML {
    static LinkedList<EDataDispVector> dataSet;
    private static final int NUM_DATA_POINTS = 500;

    public EnemyML() {
        if (dataSet == null) {
            dataSet = new LinkedList();
        }
    }

    public EnemyML(EDataDispVector e) {
        if (dataSet == null) {
            dataSet = new LinkedList();
        }
        dataSet.add(e);
    }

    private Vector2D[] getNearestNeighbors(int k, EnemyStateML cState) {
        EDataDispVector[] kBest = new EDataDispVector[k];
        double[] kBestDistances = new double[k];
        int i = 0;
        while (i < k) {
            kBestDistances[i] = Double.POSITIVE_INFINITY;
            ++i;
        }
        for (EDataDispVector cData : dataSet) {
            double cDistance = cData.getEnemyState().getWeightedDataDistanceSq(cState);
            int i2 = 0;
            while (i2 < k) {
                if (cDistance >= kBestDistances[i2]) {
                    i2 = -1;
                    break;
                }
                ++i2;
            }
            if (i2 < 0) continue;
            kBest[i2 - 1] = cData;
            kBestDistances[i2 - 1] = cDistance;
        }
        Vector2D[] output = new Vector2D[k];
        int i3 = 0;
        while (i3 < k) {
            output[i3] = kBest[i3].getVector();
            ++i3;
        }
        return output;
    }

    public Point2D.Double getPredictedCoordinate(Point2D.Double firingPosition, Enemy enemy) {
        EnemyStateML cState = new EnemyStateML(enemy.getDistance(), enemy.getHeading(), enemy.getVelocity(), enemy.getLatestTurnRate(), enemy.getTimeSinceDecel());
        int NUM_NEIGHBORS = 1;
        Vector2D[] nearestNeighbors = this.getNearestNeighbors(NUM_NEIGHBORS, cState);
        Point2D.Double predictedRelPos = nearestNeighbors[0].project();
        Point2D.Double predictedAbsPos = new Point2D.Double(predictedRelPos.getX() + enemy.getX(), predictedRelPos.getY() + enemy.getY());
        return predictedAbsPos;
    }

    public void addData(EDataDispVector e) {
        if (dataSet.size() > 500) {
            dataSet.remove(0);
        }
        dataSet.add(e);
    }
}

