/*
 * Decompiled with CFR 0.152.
 */
package ry;

import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.Condition;
import ry.Enemy;
import ry.Gun;
import utils.Utils;

class SGFTGun
extends Gun {
    public static Point2D.Double enemyLoc;
    public static final double MAX_DISTANCE;
    public static final int DISTANCE_INDEXES;
    public static final int WALL_INDEXES = 4;
    public static final int VELOCITY_INDEXES = 5;
    public static final int PREVIOUS_VELOCITY_INDEXES = 5;
    public static final int MIDDLE_VELOCITY_INDEX = 2;
    public static final int BINS = 47;
    public static final int MIDDLE_BIN = 23;
    public static final double MAX_ESC_ANGLE = 0.8143399421265254;
    public static final double BIN_WIDTH = 0.03540608444028371;
    public static double[][][][] stats;
    public static AdvancedRobot robot;
    public static Enemy enemy;
    static double enemyBearingDirection;
    public static SGFTWave w;

    static {
        MAX_DISTANCE = Point2D.distance(18.0, 18.0, 782.0, 582.0);
        DISTANCE_INDEXES = (int)(MAX_DISTANCE / 100.0);
    }

    public SGFTGun() {
        stats = new double[DISTANCE_INDEXES][5][5][47];
    }

    @Override
    public String getName() {
        return "SGFT Gun";
    }

    @Override
    public Color getColor() {
        return Color.YELLOW;
    }

    @Override
    public double getFiringAngle(AdvancedRobot shooter, Enemy target, double bulletPower) {
        robot = shooter;
        enemy = target;
        double absBearing = robot.getHeadingRadians() + SGFTGun.enemy.bearing;
        double firePower = SGFTGun.enemy.distance < 200.0 ? 3.0 : 1.72;
        w = new SGFTWave();
        SGFTGun.w.firedLocation = new Point2D.Double(robot.getX(), robot.getY());
        enemyLoc = new Point2D.Double(SGFTGun.enemy.x, SGFTGun.enemy.y);
        SGFTGun.w.sign = Utils.sign(SGFTGun.enemy.velocity * Math.sin(SGFTGun.enemy.heading - absBearing));
        SGFTGun.w.bearing = absBearing;
        SGFTGun.w.velocity = Utils.bulletVelocity(firePower);
        if (SGFTGun.enemy.velocity != 0.0) {
            enemyBearingDirection = 0.7 * (double)Utils.sign(SGFTGun.enemy.velocity * Math.sin(SGFTGun.enemy.heading - absBearing));
        }
        SGFTGun.w.bearingDirection = enemyBearingDirection / 23.0;
        int distanceIndex = (int)(SGFTGun.enemy.distance / (MAX_DISTANCE / (double)DISTANCE_INDEXES));
        int velocityIndex = (int)Math.abs(SGFTGun.enemy.velocity / 2.0);
        int previousVelocityIndex = (int)Math.abs(SGFTGun.enemy.pVelocity / 2.0);
        SGFTGun.w.segment = stats[distanceIndex][velocityIndex][previousVelocityIndex];
        return Utils.normalizeBearing(absBearing + SGFTGun.w.sign * 0.03540608444028371 * (double)(this.getMostVisited(SGFTGun.w.segment) - 23));
    }

    public int getMostVisited(double[] segment) {
        int mostVisited = 23;
        int i = 0;
        while (i < 47) {
            if (segment[i] > segment[mostVisited]) {
                mostVisited = i;
            }
            ++i;
        }
        return mostVisited;
    }

    public class SGFTWave
    extends Condition {
        public double[] segment;
        public int halflife = 100000;
        public Point2D.Double firedLocation;
        public boolean firing;
        public double velocity;
        public double distanceTraveled;
        public double bearing;
        public double sign;
        public double bearingDirection;

        public boolean test() {
            this.distanceTraveled += this.velocity;
            double distance = this.firedLocation.distance(enemyLoc);
            if (this.distanceTraveled > distance - 18.0) {
                int bin = (int)Math.round((Utils.normalizeBearing(Utils.absoluteBearing(this.firedLocation, enemyLoc)) - this.bearing) / (this.sign * 0.03540608444028371)) + 23;
                if (this.firing) {
                    int i = 0;
                    while (i < 47) {
                        int n = i;
                        this.segment[n] = this.segment[n] + 1.0 / (Math.pow(bin - i, 2.0) + 1.0);
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < 47) {
                        int n = i;
                        this.segment[n] = this.segment[n] + 1.0 / (Math.pow(bin - i, 2.0) + 2.0);
                        ++i;
                    }
                }
                robot.removeCustomEvent((Condition)this);
            }
            return false;
        }
    }
}

