/*
 * Decompiled with CFR 0.152.
 */
package eem.dangermap;

import eem.bot.fighterBot;
import eem.dangermap.dangerPoint;
import eem.misc.physics;
import eem.wave.waveWithBullets;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.LinkedList;

public class dangerMap {
    public LinkedList<dangerPoint> dangerPoints = new LinkedList();
    public long ticTime = 0L;
    public fighterBot myBot;

    public dangerMap(fighterBot fighterBot2) {
        this.myBot = fighterBot2;
    }

    public void add(dangerPoint dangerPoint2) {
        this.dangerPoints.add(dangerPoint2);
    }

    public void add(Point2D.Double double_) {
        double d = 0.0;
        this.dangerPoints.add(new dangerPoint(double_, d));
    }

    public void reCalculateDangerMap(long l) {
        this.ticTime = l;
        for (dangerPoint dangerPoint2 : this.dangerPoints) {
            double d = this.calculateDangerForPoint(l, dangerPoint2);
            dangerPoint2.setDanger(d);
        }
    }

    public double calculateDangerForPoint(long l, dangerPoint dangerPoint2) {
        double d = 0.0;
        d += this.calculateDangerFromWall(l, dangerPoint2);
        d += this.calculateDangerFromEnemyBots(l, dangerPoint2);
        return d += this.calculateDangerFromEnemyWaves(l, dangerPoint2);
    }

    public double calculateDangerFromEnemyWaves(long l, dangerPoint dangerPoint2) {
        double d = 0.0;
        for (waveWithBullets waveWithBullets2 : this.myBot.getEnemyWaves()) {
            d += waveWithBullets2.getDanger(l, dangerPoint2.getPosition());
        }
        return d;
    }

    public double calculateDangerFromEnemyBots(long l, dangerPoint dangerPoint2) {
        double d = 0.0;
        for (fighterBot fighterBot2 : this.myBot.getEnemyBots()) {
            d += fighterBot2.getDanger(l, dangerPoint2.getPosition());
        }
        return d;
    }

    public double calculateDangerFromWall(long l, dangerPoint dangerPoint2) {
        double d = 1.0E8;
        double d2 = 100.0;
        double d3 = 0.0;
        double d4 = physics.shortestDist2wall(dangerPoint2.getPosition());
        if (d4 <= (double)physics.robotHalfSize) {
            d3 += d;
        }
        return d3 += 0.2 * Math.exp(-d4 / d2);
    }

    public void sortDangerPoints() {
        Collections.sort(this.dangerPoints);
    }

    public dangerPoint getSafestPoint() {
        this.sortDangerPoints();
        return this.dangerPoints.getFirst();
    }

    public void clearDangerPoints() {
        this.dangerPoints.clear();
    }

    public void onPaint(Graphics2D graphics2D) {
        for (dangerPoint dangerPoint2 : this.dangerPoints) {
            dangerPoint2.onPaint(graphics2D);
        }
    }
}

