/*
 * Decompiled with CFR 0.152.
 */
package pulsar;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import pulsar.EnemyFireListener;
import pulsar.GunManager;
import pulsar.MovementManager;
import pulsar.Settings;
import pulsar.gf.AccSegmentation;
import pulsar.gf.BulletPowerSegmentation;
import pulsar.gf.DistanceSegmentation;
import pulsar.gf.Segmentation;
import pulsar.gf.TimeSinceVelocityChangeSegmentation;
import pulsar.gf.VelocitySegmentation;
import pulsar.gf.Wall2Segmentation;
import pulsar.movement.AvoidRamMovement;
import pulsar.movement.MaxDistanceMovement;
import pulsar.movement.RamMovement;
import pulsar.movement.WaveSurfing;
import pulsar.targeting.CombinedTargeting;
import pulsar.targeting.GuessFactorTargeting;
import pulsar.targeting.Targeting;
import pulsar.util.RobotData;
import pulsar.util.Util;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class PulsarMax
extends AdvancedRobot {
    private static final boolean VERBOSE = true;
    public static final int MC_MODE = 2;
    public static final int TC_MODE = 1;
    public static final int NORMAL_MODE = 0;
    public static int mode = 0;
    public static int others = 0;
    private double currentX;
    private double currentY;
    private double fieldWidth;
    private double fieldHeight;
    public static long time;
    public static RectangularShape field;
    private static double margin;
    public static RectangularShape fieldWithMargin;
    public static RobotData robotStats;
    private static RobotData currentTarget;
    private static final Map radar;
    private static MovementManager movementManager;
    public static EnemyFireListener enemyFireListener;
    private static GunManager gunManager;
    private List waitingToLoadList = Collections.synchronizedList(new LinkedList());
    static int wins;
    static int totalWallHits;
    int roundWallHits = 0;
    static int roundBulletHits;
    static int roundBulletMisses;
    static int totalBulletHits;
    static int totalBulletMisses;
    static int skippedTurns;
    static boolean dataLoaded;
    public static boolean melee;
    private static boolean initTargeting;
    private static boolean initMovement;
    private static PulsarMax instance;
    private Set radarScan = new HashSet();
    private double radarDirection = 1.0;
    private boolean radarLock = false;
    private double sweepStart;

    private void initMovement() {
        movementManager.clearStrategies();
        movementManager.addStrategy(new WaveSurfing());
        movementManager.addStrategy(new RamMovement());
        movementManager.addStrategy(new AvoidRamMovement());
        movementManager.addStrategy(new MaxDistanceMovement());
        initMovement = true;
    }

    private void initTargeting() {
        gunManager.clearStrategies();
        Targeting[] targetings = this.createTargetings();
        int i = 0;
        while (i < targetings.length) {
            gunManager.addStrategy(targetings[i]);
            ++i;
        }
        initTargeting = true;
    }

    private Targeting[] createTargetings() {
        Targeting[] targetings = null;
        if (!melee) {
            if (PulsarMax.useRollingGun()) {
                Settings.TARGETING_GUESSFACTOR_REAL_FACTOR = 3;
                Settings.TARGETING_HIT_SAMPLES = (int)Math.round((double)4 * Settings.TARGETING_GUESSFACTOR_REAL_FACTOR);
                targetings = new Targeting[]{new GuessFactorTargeting(new Segmentation[]{new DistanceSegmentation(2), new BulletPowerSegmentation(1), new VelocitySegmentation(2), new AccSegmentation(), new Wall2Segmentation(2), new Wall2Segmentation(0, -1)})};
            } else {
                Settings.TARGETING_GUESSFACTOR_REAL_FACTOR = 5;
                Settings.TARGETING_HIT_SAMPLES = 0;
                targetings = new Targeting[5];
                targetings[1] = new GuessFactorTargeting(new Segmentation[]{new DistanceSegmentation(2), new BulletPowerSegmentation(1), new VelocitySegmentation(2), new AccSegmentation(), new TimeSinceVelocityChangeSegmentation(5), new Wall2Segmentation(2), new Wall2Segmentation(0, -1)});
                targetings[2] = new GuessFactorTargeting(new Segmentation[]{new DistanceSegmentation(0), new BulletPowerSegmentation(1), new VelocitySegmentation(1), new AccSegmentation(), new TimeSinceVelocityChangeSegmentation(3), new Wall2Segmentation(1)});
                targetings[3] = new GuessFactorTargeting(new Segmentation[]{new DistanceSegmentation(0), new VelocitySegmentation(0), new AccSegmentation()});
                targetings[4] = new GuessFactorTargeting(new Segmentation[]{new DistanceSegmentation(0)});
                targetings[0] = new CombinedTargeting(new Targeting[]{targetings[1], targetings[2], targetings[3], targetings[4]}, new double[]{1.0, 1.0, 0.001, 1.0E-6});
                targetings[1].setIsRealStrategy(false);
                targetings[2].setIsRealStrategy(false);
                targetings[3].setIsRealStrategy(false);
                targetings[4].setIsRealStrategy(false);
            }
        } else {
            targetings = new Targeting[3];
            targetings[1] = new GuessFactorTargeting(new Segmentation[]{new DistanceSegmentation(2), new BulletPowerSegmentation(1), new VelocitySegmentation(1), new AccSegmentation(), new TimeSinceVelocityChangeSegmentation(3), new Wall2Segmentation(1), new Wall2Segmentation(0, -1)});
            targetings[2] = new GuessFactorTargeting(new Segmentation[]{new DistanceSegmentation(0), new VelocitySegmentation(0), new AccSegmentation()});
            targetings[0] = new CombinedTargeting(new Targeting[]{targetings[1], targetings[2]}, new double[]{1.0, 0.001});
            targetings[1].setIsRealStrategy(false);
            targetings[2].setIsRealStrategy(false);
        }
        PulsarMax.println("Rolling gun: " + PulsarMax.useRollingGun());
        int i = 0;
        while (i < targetings.length) {
            int mul = 1;
            int[] seg = targetings[i].getSegmentationSizes();
            int j = 0;
            while (seg != null && j < seg.length) {
                mul *= seg[j];
                ++j;
            }
            PulsarMax.println(i + ": " + mul);
            ++i;
        }
        return targetings;
    }

    public PulsarMax() {
        instance = this;
    }

    public void run() {
        PulsarMax.println("Starting round: " + this.getRoundNum());
        this.fieldWidth = this.getBattleFieldWidth();
        this.fieldHeight = this.getBattleFieldHeight();
        others = this.getOthers();
        if (others > 1) {
            if (!melee) {
                System.out.println("Others: " + others);
            }
            melee = true;
        }
        this.setColors(Color.lightGray, Color.darkGray, Color.blue.darker().darker());
        if (!initMovement) {
            this.initMovement();
        }
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setTurnRadarRightRadians(Math.PI * 3);
        this.setMaxVelocity(8);
        Iterator iter = radar.values().iterator();
        robotStats.reset();
        while (iter.hasNext()) {
            RobotData target = (RobotData)iter.next();
            target.reset();
        }
        if (!dataLoaded) {
            dataLoaded = true;
            this.loadSettings();
        }
        if (mode != 1) {
            AvoidRamMovement mov = new AvoidRamMovement();
            while (radar.size() < 1 || PulsarMax.currentTarget.dataFromRound != this.getRoundNum()) {
                time = super.getTime();
                others = this.getOthers();
                this.currentX = super.getX();
                this.currentY = super.getY();
                if (field == null || field.getHeight() < (double)10) {
                    field = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
                    fieldWithMargin = new Rectangle2D.Double(margin, margin, this.getBattleFieldWidth() - margin * (double)2, this.getBattleFieldHeight() - margin * (double)2);
                }
                robotStats.update(this);
                this.doScanner();
                this.doPickTarget();
                mov.doMovement(this, currentTarget, radar, new HashMap());
                this.execute();
            }
        }
        while (true) {
            time = super.getTime();
            others = this.getOthers();
            this.currentX = super.getX();
            this.currentY = super.getY();
            if (field == null || field.getHeight() < (double)10) {
                field = new Rectangle2D.Double(0.0, 0.0, this.getBattleFieldWidth(), this.getBattleFieldHeight());
                fieldWithMargin = new Rectangle2D.Double(margin, margin, this.getBattleFieldWidth() - margin * (double)2, this.getBattleFieldHeight() - margin * (double)2);
            }
            robotStats.update(this);
            this.doScanner();
            this.doMovement();
            this.doPickTarget();
            this.doGun();
            this.execute();
        }
    }

    public static int getMode() {
        return mode;
    }

    private void doGun() {
        if (mode != 2) {
            gunManager.update(this, currentTarget, radar);
        }
    }

    private void doMovement() {
        if (mode != 1) {
            movementManager.update(this, currentTarget, radar);
        }
    }

    private void doScanner() {
        double radarOffset;
        if (this.radarScan.size() == this.getOthers()) {
            this.radarScan.clear();
            this.radarDirection = this.radarDirection > 0.0 ? (Util.normalizeAngle(this.sweepStart - this.getRadarHeadingRadians()) <= Math.PI ? (this.radarDirection *= (double)-1) : this.findClosestRadarTurnDirection()) : (Util.normalizeAngle(this.sweepStart - this.getRadarHeadingRadians()) >= Math.PI ? (this.radarDirection *= (double)-1) : this.findClosestRadarTurnDirection());
            this.sweepStart = this.getRadarHeadingRadians();
        }
        this.radarLock = PulsarMax.currentTarget.isAlive && time - PulsarMax.currentTarget.updateTime < (long)3 && (others <= 1 || this.getGunHeat() / this.getGunCoolingRate() < (double)6);
        if (this.radarLock) {
            radarOffset = this.getRadarHeadingRadians() - Util.absbearing(new Point2D.Double(this.getX(), this.getY()), currentTarget.getLoc());
            radarOffset = (radarOffset = Util.normalizeRelativeAngle(radarOffset)) < 0.0 ? (radarOffset -= 0.3490658503988659) : (radarOffset += 0.3490658503988659);
            radarOffset = Util.normalizeRelativeAngle(radarOffset);
        } else {
            radarOffset = 6.675884388878311 * this.radarDirection;
        }
        this.setTurnRadarLeftRadians(radarOffset);
    }

    private double findClosestRadarTurnDirection() {
        double closestPos = Double.MAX_VALUE;
        double closestNeg = Double.MIN_VALUE;
        Iterator iter = radar.values().iterator();
        while (iter.hasNext()) {
            RobotData target = (RobotData)iter.next();
            if (!target.isAlive) continue;
            double tmp = this.getRadarHeadingRadians() - Util.absbearing(new Point2D.Double(this.getX(), this.getY()), currentTarget.getLoc());
            if ((tmp = Util.normalizeRelativeAngle(tmp)) > 0.0) {
                closestPos = Math.min(closestPos, tmp);
                continue;
            }
            closestNeg = Math.max(closestNeg, tmp);
        }
        return closestPos > Math.abs(closestNeg) ? 1 : -1;
    }

    private void doPickTarget() {
        if (!(this.getGunHeat() / this.getGunCoolingRate() <= (double)3) || currentTarget == null || !PulsarMax.currentTarget.isAlive) {
            RobotData candidateTarget = currentTarget;
            double shortestDist = candidateTarget.getDistanceTo(robotStats, 0);
            Iterator it = radar.values().iterator();
            while (it.hasNext()) {
                double dist;
                RobotData aTarget = (RobotData)it.next();
                if (!aTarget.isAlive || (dist = aTarget.getDistanceTo(robotStats, 0)) >= shortestDist && candidateTarget.isAlive) continue;
                candidateTarget = aTarget;
                shortestDist = dist;
            }
            if (!PulsarMax.currentTarget.isAlive || shortestDist < 0.85 * currentTarget.getDistanceTo(robotStats, 0)) {
                currentTarget = candidateTarget;
            }
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        RobotData scannedEnemy = (RobotData)radar.get(e.getName());
        this.radarScan.add(e.getName());
        if (scannedEnemy == null) {
            if (Settings.SAVED_DATA) {
                this.waitingToLoadList.add(e.getName());
            }
            scannedEnemy = new RobotData();
            radar.put(e.getName(), scannedEnemy);
        }
        if (scannedEnemy.updateTime < time) {
            scannedEnemy.updateFromScan(this, e);
        }
        if (!initTargeting) {
            this.initTargeting();
        }
    }

    private static boolean useRollingGun() {
        Collection targets;
        RobotData target = currentTarget;
        if (!(target != null && target.name != null || (targets = radar.values()).isEmpty())) {
            target = (RobotData)targets.iterator().next();
        }
        if (target != null && target.name != null) {
            return target.name.toLowerCase().matches("abc\\.tron\\d?\\.shadow.*" + "|wiki\\.ashadow.*" + "|wiki\\.janus\\.flyhighlittlebutterfly.*" + "|mue\\.ascendant.*" + "|axebots\\.silversurfer.*" + "|tide\\.pear\\.pear.*" + "|jam\\.raikomx.*" + "|dft\\.cyanide.*" + "|davidalves\\.phoenix.*" + "|cf\\.proto\\.shiva.*" + "|pez\\.rumble\\..*" + "|jekl\\.darkhallow.*" + "|pez\\.mini.pugilist.*" + "|pe\\.sandboxdt.*" + "|dft\\.immortal.*" + "|rz\\.aleph.*");
        }
        return false;
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.radarScan.remove(e.getName());
        RobotData enemy = (RobotData)radar.get(e.getName());
        if (enemy != null) {
            enemy.isAlive = false;
        }
        if (e.getName().equals(PulsarMax.currentTarget.name)) {
            PulsarMax.currentTarget.isAlive = false;
        }
    }

    public long getTime() {
        return time;
    }

    public double getX() {
        return this.currentX;
    }

    public double getY() {
        return this.currentY;
    }

    public void onHitWall(HitWallEvent e) {
        ++this.roundWallHits;
        movementManager.onHitWall(e);
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
        ++skippedTurns;
    }

    public static void println(String s) {
        ((Robot)PulsarMax.instance).out.println(s);
    }

    public void printRoundStats() {
        totalWallHits += this.roundWallHits;
        totalBulletHits += roundBulletHits;
        totalBulletMisses += roundBulletMisses;
        if (skippedTurns > 0) {
            PulsarMax.println("Total skipped Turns: " + skippedTurns);
        }
        PulsarMax.println("Round Hit Rate: " + Util.percentFormat.format((double)roundBulletHits / (double)(roundBulletHits + roundBulletMisses)));
        PulsarMax.println("Total Hit Rate: " + Util.percentFormat.format(PulsarMax.getTotalHitRate()));
        PulsarMax.println("Round Wall Hits: " + this.roundWallHits);
        PulsarMax.println("Total Wall Hits: " + totalWallHits);
        PulsarMax.println("Energy left: " + this.getEnergy());
        PulsarMax.println("Rolling gun: " + PulsarMax.useRollingGun());
        PulsarMax.println("Flattener status: " + WaveSurfing.useFlattener(currentTarget));
        PulsarMax.println("Wins ratio: " + wins + "/" + (this.getRoundNum() + 1) + "(" + Util.percentFormat.format((double)wins / (double)(this.getRoundNum() + 1)) + ")");
        roundBulletHits = 0;
        roundBulletMisses = 0;
    }

    public static double getTotalHitRate() {
        return (double)totalBulletHits / (double)(totalBulletHits + totalBulletMisses);
    }

    public static double getCurrentRoundHitRate() {
        double total = roundBulletHits + roundBulletMisses;
        if (total == 0.0) {
            return 0.0;
        }
        return (double)roundBulletHits / total;
    }

    public static double getCurrentTotalHitRate() {
        double total = totalBulletHits + totalBulletMisses + roundBulletHits + roundBulletMisses;
        if (total == 0.0) {
            return 0.0;
        }
        return (double)(totalBulletHits + roundBulletHits) / total;
    }

    private void afterFight() {
        if (this.getRoundNum() >= this.getNumRounds() - 1) {
            this.saveData();
        }
        this.printRoundStats();
    }

    protected void saveData() {
        if (Settings.SAVED_DATA) {
            PulsarMax.println("Saving data.");
        }
    }

    protected void loadSettings() {
        Properties props = new Properties();
        try {
            props.load(new BufferedInputStream(new FileInputStream(this.getDataFile("pulsarmax.properties"))));
            String behavior = (String)props.get("behavior");
            if (behavior.equalsIgnoreCase("tc")) {
                mode = 1;
            } else if (behavior.equalsIgnoreCase("mc")) {
                mode = 2;
            }
            String savedData = (String)props.get("savedata");
            if (savedData != null) {
                Settings.SAVED_DATA = Boolean.valueOf(savedData);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to load properties! " + e.getMessage());
        }
    }

    public void onWin(WinEvent event) {
        ++wins;
        this.afterFight();
    }

    public void onDeath(DeathEvent e) {
        this.afterFight();
    }

    public void onHitRobot(HitRobotEvent e) {
        RobotData target = (RobotData)radar.get(e.getName());
        if (target != null) {
            if (!e.isMyFault()) {
                ++target.roundRamHits;
            }
            target.lastEnergy = e.getEnergy();
        }
        movementManager.onHitRobot(e);
    }

    public void onBulletHit(BulletHitEvent event) {
        ++roundBulletHits;
        RobotData target = (RobotData)radar.get(event.getName());
        if (target != null) {
            target.lastEnergy -= Util.calculateDamage(event.getBullet().getPower());
            target.addBulletHit(gunManager.getTargeting(event.getBullet()));
            target.timeLastHit = this.getTime();
        }
        movementManager.onBulletHit(event);
    }

    public void onBulletMissed(BulletMissedEvent event) {
        if (PulsarMax.currentTarget.isAlive) {
            ++roundBulletMisses;
            currentTarget.addBulletMiss(gunManager.getTargeting(event.getBullet()));
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent event) {
        movementManager.onBulletHitBullet(event);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        movementManager.onHitByBullet(e);
        PulsarMax.robotStats.timeLastHit = this.getTime();
        RobotData target = (RobotData)radar.get(e.getName());
        if (target != null) {
            target.timeLastHitUs = time;
            ++target.bulletHits;
            target.lastEnergy += (double)3 * e.getBullet().getPower();
        }
    }

    static {
        field = null;
        margin = 18;
        fieldWithMargin = null;
        robotStats = new RobotData();
        currentTarget = new RobotData();
        radar = new HashMap();
        movementManager = new MovementManager();
        enemyFireListener = movementManager;
        gunManager = new GunManager();
        wins = 0;
        totalWallHits = 0;
        roundBulletHits = 0;
        roundBulletMisses = 0;
        totalBulletHits = 0;
        totalBulletMisses = 0;
        skippedTurns = 0;
        dataLoaded = false;
        melee = false;
        initTargeting = false;
        initMovement = false;
        instance = null;
    }
}

