/*
 * Decompiled with CFR 0.152.
 */
package pulsar.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class DynMultiDimArray
implements Serializable {
    private Object rawData;

    DynMultiDimArray() {
    }

    public DynMultiDimArray(int[] dimensions) {
        this.rawData = Array.newInstance(Double.TYPE, dimensions);
    }

    public void setValue(int[] indexes, double value) {
        int n = indexes.length - 1;
        Object array = this.rawData;
        if (n > 0) {
            int i = 0;
            while (i < n) {
                array = Array.get(array, indexes[i]);
                ++i;
            }
        }
        Array.setDouble(array, indexes[n], value);
    }

    public void incValue(int[] indexes, double inc) {
        int n = indexes.length - 1;
        Object array = this.rawData;
        if (n > 0) {
            int i = 0;
            while (i < n) {
                array = Array.get(array, indexes[i]);
                ++i;
            }
        }
        Array.setDouble(array, indexes[n], Array.getDouble(array, indexes[n]) + inc);
    }

    public double getSum(int[] indexes) {
        int n = indexes.length - 1;
        Object array = this.rawData;
        if (n > 0) {
            int i = 0;
            while (i < n) {
                array = Array.get(array, indexes[i]);
                ++i;
            }
        }
        double sum = 0.0;
        int i = 0;
        while (i < Array.getLength(array)) {
            sum += Array.getDouble(array, i);
            ++i;
        }
        return sum;
    }

    public double getValue(int[] indexes) {
        int n = indexes.length - 1;
        Object array = this.rawData;
        if (n > 0) {
            int i = 0;
            while (i < n) {
                array = Array.get(array, indexes[i]);
                ++i;
            }
        }
        return Array.getDouble(array, indexes[n]);
    }

    public String toString() {
        return DynMultiDimArray.arrayToString(this.rawData);
    }

    public static String arrayToString(Object array) {
        if (array == null) {
            return "[NULL]";
        }
        Object obj = null;
        if (array instanceof Map) {
            array = ((Map)array).entrySet().toArray();
        } else if (array instanceof Collection) {
            array = ((Collection)array).toArray();
        }
        int length = Array.getLength(array);
        int lastItem = length - 1;
        StringBuffer sb = new StringBuffer(91);
        int i = 0;
        while (i < length) {
            obj = Array.get(array, i);
            if (obj != null) {
                if (obj.getClass().isArray()) {
                    sb.append(DynMultiDimArray.arrayToString(obj));
                } else {
                    sb.append(obj);
                }
            } else {
                sb.append("[NULL]");
            }
            if (i < lastItem) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(']');
        return sb.toString();
    }
}

