/*
 * Decompiled with CFR 0.152.
 */
package florent.test;

import apv.MovSim;
import florent.test.FUtils;
import florent.test.JumperWave;
import florent.test.Mirror;
import florent.test.WaveManager;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.Condition;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class Jumper
extends Condition {
    private static final boolean debug = true;
    private static final boolean monoWave = false;
    public static final boolean profiling = false;
    private static final MovSim sim = new MovSim();
    private static final double STD_DISTANCE = 550.0;
    private static final double CLOSE_DISTANCE = 350.0;
    private static final double CLOSE_COMBAT_DISTANCE = 150.0;
    private static final double GO_AWAY_DISTANCE = 50.0;
    private static final double RAMMER_SPEED = 5.0;
    private double bfHeight;
    private double bfWidth;
    private Rectangle2D.Double BF;
    private Rectangle2D.Double innerBF;
    private double distance;
    private double approachVelocity;
    private static double avgApproachVelocity;
    private static int scans;
    private WaveManager manager;
    private double energy;
    private double enemyHeading;
    private double enemyVelocity;
    private Point2D.Double enemyLocation = new Point2D.Double();
    private AdvancedRobot me;
    private Point2D.Double myLocation = new Point2D.Double();
    private int myBearingDirection;
    private double myEnergy = 100.0;
    private Point2D.Double nextPosition;
    private double dangerForward;
    private double dangerBack;
    private long time;
    private double heading;
    private double velocity;
    private static int collisions;
    private boolean rammer = false;
    private boolean holdingFire = false;
    private boolean resumeFire = false;
    private int roundNum;
    private volatile double holdFireDistance = 140.0;
    private boolean skyClear;
    private Mirror mirror;

    public Jumper(AdvancedRobot me) {
        this.me = me;
        this.bfWidth = me.getBattleFieldWidth();
        this.bfHeight = me.getBattleFieldHeight();
        this.BF = new Rectangle2D.Double(18.0, 18.0, me.getBattleFieldWidth() - 36.0, me.getBattleFieldHeight() - 36.0);
        this.innerBF = new Rectangle2D.Double(80.0, 80.0, me.getBattleFieldWidth() - 160.0, me.getBattleFieldHeight() - 160.0);
        this.manager = new WaveManager();
        this.mirror = new Mirror(me);
    }

    public void init(AdvancedRobot me) {
        this.manager.init(me);
        this.myBearingDirection = 1;
        this.roundNum = me.getRoundNum();
    }

    public void move() {
        JumperWave wave = this.manager.getNearestWave(this.myLocation, this.time);
        wave = wave == null && this.distance > 150.0 ? this.manager.lastWave : wave;
        wave = wave == null && this.me.getOthers() == 0 || this.rammer ? this.manager.lastWave : wave;
        Point2D.Double nextDestination = null;
        if (this.goHunting()) {
            nextDestination = this.huntLocation();
        } else {
            if (wave == null) {
                this.mirror.setAwayFactor(this.rammer ? 1.1 : (this.distance < 50.0 ? 1.005 : 1.003));
                this.mirror.doMove();
                return;
            }
            this.updateDanger(wave);
            if (this.dangerForward > this.dangerBack) {
                nextDestination = this.getNextPoint(-this.myBearingDirection, this.myLocation, wave.getGunLocation());
                this.nextPosition = this.nextPosition(this.myLocation, this.myBearingDirection, wave, this.heading, this.velocity, this.time, 8.0);
                this.me.setMaxVelocity(8.0);
            } else {
                nextDestination = this.getNextPoint(this.myBearingDirection, this.myLocation, wave.getGunLocation());
                this.nextPosition = this.nextPosition(this.myLocation, -this.myBearingDirection, wave, this.heading, this.velocity, this.time, 8.0);
                this.me.setMaxVelocity(8.0);
            }
            this.dangerBack = 0.0;
            this.dangerForward = 0.0;
        }
        double theta = FUtils.absoluteBearing(this.myLocation, nextDestination) - this.me.getHeadingRadians();
        this.me.setAhead(Math.cos(theta) * 100.0);
        this.me.setTurnRightRadians(Math.tan(theta));
    }

    private Point2D.Double huntLocation() {
        return FUtils.projectMotion(this.enemyLocation, this.enemyHeading, this.enemyVelocity);
    }

    public boolean goHunting() {
        return this.energy == 0.0 && this.manager.isSkyClear() && this.me.getEnergy() > 3.0;
    }

    private Point2D.Double getNextPoint(int circleDir, Point2D.Double start, Point2D.Double center) {
        Point2D.Double nextPoint;
        double blindManStick;
        int maxTry = 175;
        double desiredDistance = this.holdingFire && this.myEnergy > 3.0 && this.skyClear ? this.holdFireDistance : 525.0;
        double getCloser = this.holdingFire && this.myEnergy > 3.0 && this.skyClear && start.distance(center) > desiredDistance + 60.0 ? -1.5707963267948966 : -0.1;
        double d = blindManStick = this.rammer ? FUtils.bindToRange(this.distance / 2.0, 60.0, 170.0) : 170.0;
        double desiredAngle = 1.6707963267948966 + (this.rammer ? 1.5707963267948966 : (start.distance(center) > desiredDistance ? getCloser : 0.5));
        if (this.rammer) {
            while (!this.innerBF.contains(nextPoint = FUtils.projectMotion(start, FUtils.absoluteBearing(start, center) - (double)circleDir * (desiredAngle -= 0.1), blindManStick)) && --maxTry > 0) {
            }
        } else {
            while (!this.BF.contains(nextPoint = FUtils.projectMotion(start, FUtils.absoluteBearing(start, center) - (double)circleDir * (desiredAngle -= 0.1), blindManStick))) {
            }
        }
        return nextPoint;
    }

    public boolean isRammer() {
        return avgApproachVelocity > 5.0;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        ++scans;
        this.energy = e.getEnergy();
        this.enemyHeading = e.getHeadingRadians();
        this.enemyVelocity = e.getVelocity();
        this.distance = e.getDistance();
        this.enemyLocation = FUtils.projectMotion(this.myLocation, this.me.getHeadingRadians() + e.getBearingRadians(), e.getDistance());
        this.approachVelocity = -this.enemyVelocity * Math.cos(e.getHeadingRadians() - (this.me.getHeadingRadians() + e.getBearingRadians()));
        avgApproachVelocity = FUtils.rollingAverage(Math.min(scans, 500), avgApproachVelocity, this.approachVelocity);
        this.rammer = this.isRammer();
        this.manager.onScannedRobot(e);
        this.holdingFire = this.manager.isHoldingFire();
        this.holdFireDistance = this.manager.holdingFireDistance() + 30.0;
        this.skyClear = this.manager.isSkyClear();
        this.resumeFire = this.manager.isResumeFire();
        if (this.me.getVelocity() != 0.0) {
            this.myBearingDirection = this.me.getVelocity() * Math.sin(this.me.getHeadingRadians() - FUtils.absoluteBearing(this.enemyLocation, this.myLocation)) > 0.0 ? 1 : -1;
        }
        this.mirror.onScannedRobot(e);
        this.move();
    }

    public void newTick() {
        this.myLocation.setLocation(this.me.getX(), this.me.getY());
        this.manager.newTick();
        this.heading = this.me.getHeadingRadians();
        this.velocity = this.me.getVelocity();
        this.time = this.me.getTime();
        this.myEnergy = this.me.getEnergy();
    }

    private void updateDanger(JumperWave wave) {
        this.dangerForward = this.updateDanger(this.myLocation, this.myBearingDirection, wave, this.heading, this.velocity, this.time, 8.0);
        this.dangerBack = this.updateDanger(this.myLocation, -this.myBearingDirection, wave, this.heading, this.velocity, this.time, 8.0);
    }

    private double updateDanger(Point2D.Double start, int direction, JumperWave wave, double heading, double velocity, double time, double maxVel) {
        double d;
        Point2D.Double gunLocation = wave.getGunLocation();
        Point2D.Double nextPoint = new Point2D.Double(start.x, start.y);
        do {
            double wantedheading;
            boolean reverse = Math.abs(Utils.normalRelativeAngle((double)((wantedheading = FUtils.absoluteBearing(nextPoint, this.getNextPoint(direction, nextPoint, gunLocation))) - heading))) > 1.5707963267948966;
            heading = reverse ? Utils.normalRelativeAngle((double)(heading + Math.PI)) : heading;
            double maxT = FUtils.maxTurn(velocity);
            double t = FUtils.bindToRange(Math.tan(Utils.normalRelativeAngle((double)(wantedheading - heading))), -maxT, maxT);
            heading = Utils.normalRelativeAngle((double)(heading + t));
            velocity = velocity < 0.0 ? Math.min(velocity + 2.0, 0.0) : Math.min(Math.max(maxVel, (velocity *= (double)(reverse ? -1 : 1)) - 2.0), velocity + 1.0);
            nextPoint = FUtils.projectMotion(nextPoint, heading, velocity);
            d = time;
            time = d + 1.0;
        } while (wave.distanceToImpact(nextPoint, d) > 18.0);
        double val = wave.danger(nextPoint);
        wave = this.manager.getNearestWave(nextPoint, time);
        if (wave == null) {
            return val;
        }
        return val + Math.min(this.updateDanger(nextPoint, direction, wave, heading, velocity, time, maxVel), this.updateDanger(nextPoint, -direction, wave, heading, velocity, time, maxVel));
    }

    private Point2D.Double nextPosition(Point2D.Double start, int direction, JumperWave wave, double heading, double velocity, double time, double maxVel) {
        Point2D.Double gunLocation = wave.getGunLocation();
        Point2D.Double nextPoint = new Point2D.Double(start.x, start.y);
        double wantedHeading = this.goHunting() ? FUtils.absoluteBearing(nextPoint, this.huntLocation()) : FUtils.absoluteBearing(nextPoint, this.getNextPoint(direction, nextPoint, gunLocation));
        boolean reverse = Math.abs(Utils.normalRelativeAngle((double)(wantedHeading - heading))) > 1.5707963267948966;
        heading = reverse ? Utils.normalRelativeAngle((double)(heading + Math.PI)) : heading;
        double maxT = FUtils.maxTurn(velocity);
        double t = FUtils.bindToRange(Math.tan(Utils.normalRelativeAngle((double)(wantedHeading - heading))), -maxT, maxT);
        heading = Utils.normalRelativeAngle((double)(heading + t));
        velocity = velocity < 0.0 ? Math.min(velocity + 2.0, 0.0) : Math.min(Math.max(maxVel, (velocity *= (double)(reverse ? -1 : 1)) - 2.0), velocity + 1.0);
        nextPoint = FUtils.projectMotion(nextPoint, heading, velocity);
        return nextPoint;
    }

    public Point2D.Double nextPosition() {
        if (this.nextPosition == null) {
            return this.myLocation;
        }
        return this.nextPosition;
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.manager.onBulletHitBullet(e);
    }

    public void onBulletHit(BulletHitEvent e) {
        this.manager.onBulletHit(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        this.manager.onHiBytBullet(e);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.manager.onHitRobot(e);
        ++collisions;
        this.rammer = this.isRammer();
    }

    public void dump() {
        System.out.println(((Object)((Object)this)).getClass().getName());
        System.out.println("rammer :" + this.rammer + ":" + avgApproachVelocity);
        this.manager.dump();
    }

    public void endRound() {
        this.manager.endRound();
    }

    public boolean test() {
        JumperWave wave = this.manager.getNearestWave(this.myLocation, this.time);
        if (wave != null) {
            this.updateDanger(wave);
        }
        return false;
    }
}

