/*
 * Decompiled with CFR 0.152.
 */
package tex;

import tex.Driver;
import tex.Longbot;
import tex.Program;
import tex.StayInCenter;

public class PatrolProgram
extends Program {
    private State myState = State.Ahead;
    private int myCount;
    private int myAngle = 45;
    private int myDistance = 20;
    private Driver myDriver = new StayInCenter();

    @Override
    public void nextProgram(Longbot bot) {
        if (bot.getLastSeenEnemy() != null) {
            this.myState = State.TrackEnemy;
        }
        if (this.myCount > 360 / this.myAngle) {
            this.myCount = 0;
            this.myDistance *= 2;
            this.myState = State.Ahead;
        } else if (this.myState == State.Ahead) {
            this.myState = State.Turn;
        } else if (this.myState == State.Turn) {
            this.myState = State.Scan;
        } else if (this.myState == State.Scan) {
            this.myState = State.Ahead;
            ++this.myCount;
        } else {
            System.out.println("PatrolProgram::nextProgram invalid state");
        }
    }

    @Override
    public void execute(Longbot bot) {
        if (this.myState == State.TrackEnemy) {
            this.myDriver.drive(bot);
        } else if (this.myState == State.Ahead) {
            bot.ahead(this.myDistance);
        } else if (this.myState == State.Turn) {
            bot.turnLeft(this.myAngle);
        } else if (this.myState == State.Scan) {
            bot.turnRadarLeft(360.0);
        } else {
            System.out.println("PatrolProgram::execute invalid state");
        }
        this.nextProgram(bot);
    }

    static enum State {
        Ahead,
        Turn,
        Scan,
        TrackEnemy;

    }
}

