/*
 * Decompiled with CFR 0.152.
 */
package jbot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Random;
import jbot.Inherit;
import jbot.Strategy;
import jbot.tracer.Radar;
import jbot.tracer.Target;
import jbot.tracer.Tracer;
import jbot.util.MathUtil;
import jbot.util.Vector2;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class Rabbit2
extends AdvancedRobot {
    Strategy mStrategy;
    Radar mRadar;
    Target mTarget;
    Target mSelf;
    Tracer mTracer;
    Inherit mInherit;
    Random mRandom = new Random();
    private boolean mLocked = false;
    private boolean mRecentTurnSkipped = false;
    private boolean mTargetScanned = false;
    private long mTotalTime = 0L;
    private Vector2 mPosition;
    private Vector2 mDirection;
    double mLastScanTime = 0.0;

    public Rabbit2() {
        this.mTarget = new Target();
        this.mSelf = new Target();
        this.mInherit = new Inherit(this);
        this.mTracer = new Tracer(this, this.mSelf, this.mTarget, this.mInherit);
        this.mRadar = new Radar(this.mTracer);
        this.mStrategy = new Strategy(this);
        this.mPosition = new Vector2();
        this.mDirection = new Vector2();
    }

    public Vector2 getPosition() {
        return this.mPosition.clone();
    }

    public Vector2 getDirection() {
        return this.mDirection.clone();
    }

    public boolean isTargetScanned() {
        return this.mTargetScanned;
    }

    public Tracer getTracer() {
        return this.mTracer;
    }

    public Inherit getInherit() {
        return this.mInherit;
    }

    public Random getRandom() {
        return this.mRandom;
    }

    public long getTotalTime() {
        return this.mTotalTime;
    }

    public long getInheritTime() {
        return this.mInherit.isSetup() ? this.mInherit.getTime() : 0L;
    }

    public void run() {
        double lastTime;
        this.out.print("\nRabbit2 Final by Jaroslaw Wisniewski\n");
        Color gunColor = Color.WHITE;
        Color bodyColor = Color.LIGHT_GRAY;
        Color radarColor = Color.BLACK;
        Color scanColor = Color.WHITE;
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        double deltaTime = 0.0;
        double currTime = lastTime = (double)this.getTime();
        while (true) {
            if (this.mLocked) {
                gunColor = Color.WHITE;
                bodyColor = Color.WHITE;
                radarColor = Color.WHITE;
                scanColor = Color.WHITE;
                this.setBodyColor(bodyColor);
                this.setGunColor(gunColor);
                this.setRadarColor(radarColor);
                this.setScanColor(scanColor);
                this.execute();
                continue;
            }
            if (this.mRecentTurnSkipped) {
                this.setBodyColor(Color.WHITE);
                this.setGunColor(Color.WHITE);
                this.setRadarColor(Color.WHITE);
                this.setScanColor(Color.WHITE);
            } else {
                float green = (float)((this.getEnergy() - 100.0) / 100.0);
                green = (float)MathUtil.trunc(green, -0.49, 0.49);
                bodyColor = new Color(0.5f - green / 2.0f, 0.5f + green / 2.0f, 0.0f);
                this.setBodyColor(bodyColor);
                float time = this.getTime();
                float alpha = ((float)Math.sin((double)(time / 60.0f) * (Math.PI * 2)) + 1.0f) / 2.0f;
                float channel = (int)((time + 10.0f) / 60.0f) % 2;
                alpha = (float)MathUtil.trunc(alpha, 0.01, 0.99);
                channel = (float)MathUtil.trunc(channel, 0.01, 0.99);
                scanColor = channel > 0.5f ? new Color(1.0f, 1.0f, channel, alpha) : new Color(0.5f - green, 0.5f + green, 0.2f, alpha);
                this.setScanColor(scanColor);
                green = (float)(this.mSelf.getRelativeEnergy() / 200.0);
                green = (float)MathUtil.trunc(green, -0.49, 0.49);
                gunColor = new Color(0.5f - green, 0.5f + green, 0.0f);
                this.setGunColor(gunColor);
                this.setRadarColor(gunColor);
            }
            lastTime = currTime;
            currTime = this.getTime();
            deltaTime = currTime - lastTime;
            this.mTotalTime += Math.round(deltaTime);
            this.mPosition = new Vector2(this.getX(), this.getY());
            this.mDirection = new Vector2(this.getHeadingRadians());
            this.mRadar.frame(deltaTime);
            if (this.mTargetScanned) {
                this.mTracer.frame(deltaTime);
                this.mStrategy.frame(deltaTime);
            }
            this.mRecentTurnSkipped = false;
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent evt) {
        if (this.mLocked) {
            return;
        }
        if (!this.isTargetScanned()) {
            this.mInherit.setupProfile(evt.getName());
            this.mTotalTime += this.mInherit.getTime();
            this.mTracer.setup();
            this.mStrategy.setup();
            this.mTargetScanned = true;
        }
        if (evt.getName().compareTo(this.mInherit.getEnemyName()) != 0) {
            this.mInherit.setDoNotSave(true);
            this.mLocked = true;
        }
        if (this.mLastScanTime < 1.0) {
            this.mLastScanTime = this.getTime();
        }
        double currScanTime = this.getTime();
        double deltaTime = currScanTime - this.mLastScanTime;
        this.mPosition = new Vector2(this.getX(), this.getY());
        this.mDirection = new Vector2(this.getHeadingRadians());
        this.mRadar.adjustToTarget(this.getHeadingRadians() + evt.getBearingRadians());
        this.mTracer.onScannedTarget(deltaTime, evt);
        this.mStrategy.onScannedTarget(deltaTime, evt);
        this.mLastScanTime = currScanTime;
    }

    public void onHitByBullet(HitByBulletEvent evt) {
        if (this.mLocked) {
            return;
        }
        this.mTracer.onHitByBullet(evt);
        this.mStrategy.onHitByBullet(evt);
    }

    public void onBulletHit(BulletHitEvent evt) {
        if (this.mLocked) {
            return;
        }
        this.mTracer.onBulletHit(evt);
    }

    public void onHitRobot(HitRobotEvent evt) {
        if (this.mLocked) {
            return;
        }
        this.mTracer.onHitRobot(evt);
    }

    public void onDeath(DeathEvent evt) {
        if (this.mLocked) {
            return;
        }
        this.mTracer.collectData();
        this.mInherit.saveProfile();
        this.mLocked = true;
        this.mTargetScanned = false;
    }

    public void onWin(WinEvent evt) {
        if (this.mLocked) {
            return;
        }
        this.mTracer.collectData();
        this.mInherit.saveProfile();
        this.mLocked = true;
        this.mTargetScanned = false;
    }

    public void onSkippedTurn(SkippedTurnEvent evt) {
        this.out.print("opuscila mnie kolejka!!!");
        this.mRecentTurnSkipped = true;
    }

    public void onPaint(Graphics2D g) {
        if (this.mLocked) {
            return;
        }
    }
}

