/*
 * Decompiled with CFR 0.152.
 */
package bh.units;

import bh.units.Duration;
import bh.units.interfaces.AbsoluteToRelative;
import bh.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Time
implements Continuum<Time>,
AbsoluteToRelative<Time, Duration> {
    public static final Time ZERO = new Time(0.0);
    private final double turns;

    public Time(double turns) {
        assert (!Double.isNaN(turns));
        this.turns = (double)Math.round(turns * 1000000.0) / 1000000.0;
    }

    @Override
    public Time negate() {
        return new Time(-this.turns);
    }

    @Override
    public Time abs() {
        return new Time(Math.abs(this.turns));
    }

    @Override
    public Time plus(Duration d) {
        return new Time(this.turns + d.toDouble());
    }

    @Override
    public Duration minus(Time t) {
        return new Duration(this.turns - t.turns);
    }

    @Override
    public Time minus(Duration d) {
        return new Time(this.turns - d.toDouble());
    }

    @Override
    public Time times(double d) {
        return new Time(this.turns * d);
    }

    @Override
    public Time divide(double d) {
        return new Time(this.turns / d);
    }

    @Override
    public double divide(Time t) {
        return this.turns / t.turns;
    }

    @Override
    public double toDouble() {
        return this.turns;
    }

    public int toInt() {
        return (int)this.turns;
    }

    public String toString() {
        return String.valueOf(String.format("%1$6.4f", this.turns)) + "t";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Time)) {
            return false;
        }
        Time t = (Time)o;
        return t.turns == this.turns;
    }

    public int hashCode() {
        return new Double(this.turns).hashCode();
    }
}

