/*
 * Decompiled with CFR 0.152.
 */
package jcs;

import jcs.Enemy;
import jcs.EnemyList;
import jcs.Seth;
import robocode.ScannedRobotEvent;

public class Scanner {
    private Seth seth;

    public void doScan() {
        EnemyList enemies = this.seth.getEnemyList();
        if (enemies.getCount() == this.seth.getOthers() && enemies.getCount() != 0) {
            Enemy oldest = enemies.getOldest();
            if (!oldest.isSeeking()) {
                double heading = this.seth.getCurrentPos().calcHeading(oldest.getCoord());
                if (heading > this.seth.getRadarHeadingRadians()) {
                    if (heading - this.seth.getRadarHeadingRadians() > Math.PI) {
                        this.seth.setTurnRadarLeftRadians(Math.PI * 2);
                    } else {
                        this.seth.setTurnRadarRightRadians(Math.PI * 2);
                    }
                } else if (heading - this.seth.getRadarHeadingRadians() > Math.PI) {
                    this.seth.setTurnRadarRightRadians(Math.PI * 2);
                } else {
                    this.seth.setTurnRadarLeftRadians(Math.PI * 2);
                }
                oldest.setSeeking(true);
            }
        } else {
            this.seth.setTurnRadarLeftRadians(Math.PI * 2);
        }
    }

    public void scannedRobotEvent(ScannedRobotEvent e) {
        EnemyList enemies = this.seth.getEnemyList();
        Enemy enemy = enemies.get(e.getName());
        double bearingFromZero = this.seth.getHeadingRadians() + e.getBearingRadians();
        if (bearingFromZero > Math.PI * 2) {
            bearingFromZero -= Math.PI * 2;
        }
        enemy.setCoord(this.seth.getCurrentPos().getCoordFromScan(bearingFromZero, e.getDistance()));
        enemy.setVelocity(e.getVelocity());
        enemy.setBearing(e.getHeadingRadians());
        enemy.setRelativeBearing(e.getBearingRadians() + this.seth.getHeadingRadians());
        enemy.setEnergy(e.getEnergy());
        enemy.setTicks(this.seth.getTicks());
        enemy.setSeeking(false);
    }

    public Scanner(Seth _seth) {
        this.seth = _seth;
    }
}

