/*
 * Decompiled with CFR 0.152.
 */
package davidalves;

import davidalves.A.D.A;
import davidalves.A.E.A.F;
import davidalves.A.E.A.G;
import davidalves.A.E.A.H;
import davidalves.A.E.A.J;
import davidalves.A.E.A.K;
import davidalves.A.F.B;
import davidalves.A.F.C;
import davidalves.A.F.D;
import davidalves.A.F.E;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public final class Phoenix
extends davidalves.A.B {
    public static final String version = "Phoenix .54";
    public static final String[] quotes = new String[]{"\"Fired up!\"", "\"If you keep playing with fire, you're gonna get burned.\"", "\"Back from the ashes...\"", "\"Wanna turn up the heat?\"", "\"Do not meddle in the affairs of the Phoenix, for you are crunchy and good with ketchup."};
    public static boolean targetingChallengeMode = false;
    public static boolean movementChallengeMode = false;
    public static boolean useHeadOnTargeting = false;
    public static int mode;
    public static int modeAtRoundStart;
    static C me;
    static C target;
    public static D robotManager;
    static davidalves.A.C.C ramEscape;
    static HashMap duelBullets;
    static HashMap meleeBullets;
    static A radar;
    static double damageInflicted;
    static double damageTaken;
    static long skippedTurns;
    static int wins;
    static boolean aiming;
    public static long timesStuckInCorner;
    static int[] botsRemainingAtDeath;
    public static E strategy;
    public static long timeLastFired;
    static davidalves.A.C.E meleeMovement;

    static {
        robotManager = new D();
        ramEscape = new davidalves.A.C.C();
        duelBullets = new HashMap();
        meleeBullets = new HashMap();
        radar = new A();
        aiming = false;
        timesStuckInCorner = 0L;
        timeLastFired = 0L;
    }

    public void run() {
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setColors(Color.darkGray, Color.darkGray, Color.cyan);
        mode = this.getOthers() > 1 ? 1 : 0;
        modeAtRoundStart = mode;
        if (this.getRoundNum() == 0) {
            super.init();
            Phoenix.info("Phoenix .54 by David Alves");
            Phoenix.info("   " + quotes[(int)(System.currentTimeMillis() % (long)quotes.length)]);
            me = robotManager.C(this.getName());
            strategy = new E(robotManager);
            if (mode == 1) {
                meleeMovement = new davidalves.A.C.E();
                botsRemainingAtDeath = new int[this.getOthers() + 1];
            }
        }
        aiming = false;
        robotManager.D();
        strategy.E();
        if (mode == 1) {
            meleeMovement.A();
            this.setTurnRightRadians(davidalves.A.A.Q * 5.0);
            this.setTurnGunRightRadians(davidalves.A.A.F * 5.0);
            this.turnRadarRightRadians(davidalves.A.A.E * 5.0);
        }
        while (true) {
            this.C();
            strategy.A(me, this.getTime());
            target = strategy.F();
            this.setTurnRadarRightRadians(radar.A(mode, robotManager, aiming, me, target));
            Phoenix.drawLine(me.C(), me.C().A(this.getRadarHeadingRadians(), 1200.0), Color.BLUE);
            Phoenix.drawLine(me.C(), me.C().A(this.getRadarHeadingRadians() + davidalves.A.A.F.C(-davidalves.A.A.E, this.getRadarTurnRemainingRadians(), davidalves.A.A.E), 1200.0), Color.BLUE);
            if (target != null) {
                Phoenix.drawCircle(target.C(), 25.0, Color.RED);
                robotManager.A(this.getTime());
                if (!targetingChallengeMode) {
                    this.B();
                }
                if (mode == 1 && meleeMovement.B() != null) {
                    Phoenix.drawLine(me.C(), meleeMovement.B(), Color.MAGENTA);
                }
                if (!movementChallengeMode && this.getOthers() > 0) {
                    this.A();
                }
            }
            this.execute();
            super.newTurn();
        }
    }

    private void C() {
        B b = me.C();
        B b2 = new B();
        b2.O = this.getVelocity();
        b2.P = this.getHeadingRadians();
        b2.a = this.getEnergy();
        b2.U = this.getTime();
        b2.R = this.getName();
        b2.K = this.getX();
        b2.I = this.getY();
        b2.A(b);
        robotManager.A(b2);
        Phoenix.me.J = true;
        Phoenix.me.I = true;
    }

    private void A() {
        davidalves.A.E.C c;
        B b = null;
        if (target == null) {
            return;
        }
        b = target.C();
        B b2 = me.C();
        davidalves.A.E.F f = mode == 0 ? robotManager.C(b.R).D() : robotManager.C(b.R).A();
        if (b.a == 0.0) {
            this.setTurnGunRightRadians(davidalves.A.A.F.C(this.getGunHeadingRadians(), b2.B(b)));
            this.setFire(0.1);
            return;
        }
        if (b2.a == 0.0) {
            this.setTurnGunRightRadians(davidalves.A.A.F.C(this.getGunHeadingRadians(), b2.B(b)));
            return;
        }
        double d = strategy.B();
        boolean bl = this.getGunHeat() == 0.0 && this.getGunTurnRemaining() == 0.0 && b.d;
        boolean bl2 = b2.A((davidalves.A.A.B)b) > 75.0 && b.d;
        boolean bl3 = strategy.C();
        long l = Math.round(Math.ceil(this.getGunHeat() / this.getGunCoolingRate()));
        if (!bl3 || l > 5L) {
            this.setTurnGunRightRadians(davidalves.A.A.F.C(this.getGunHeadingRadians(), b2.B(b)));
        } else {
            aiming = true;
            if (useHeadOnTargeting) {
                this.setTurnGunRightRadians(davidalves.A.A.F.C(this.getGunHeadingRadians(), b2.B(b)));
            } else {
                c = f.A(b2, b, d);
                double d2 = c.A(b2, b, d);
                this.setTurnGunRightRadians(davidalves.A.A.F.C(this.getGunHeadingRadians(), d2));
            }
        }
        c = null;
        if (bl3 && bl) {
            c = this.setFireBullet(d);
            timeLastFired = this.getTime();
            if (c != null) {
                f.A(f.E(), (Bullet)c);
                if (mode == 1) {
                    meleeBullets.put(c, target);
                }
                if (mode == 0) {
                    duelBullets.put(c, target);
                }
                aiming = false;
                if (bl2) {
                    f.A(new davidalves.A.A.A(b2, b, this.getTime(), d, 1));
                }
            }
        } else if (bl2) {
            f.A(new davidalves.A.A.A(b2, b, this.getTime(), d, 2));
        }
    }

    private void B() {
        B b = null;
        if (target != null) {
            b = target.C();
        }
        B b2 = me.C();
        davidalves.A.A.B b3 = null;
        if (b != null && Phoenix.target.F && b2.A((davidalves.A.A.B)b) < 200.0) {
            b3 = ramEscape.A(b2, b);
        } else if (mode == 0) {
            davidalves.A.C.B b4 = target.E();
            b4.B(b, b2, this.getTime());
            b4.A(b2, b, this.getTime());
            b3 = b4.A();
        } else {
            meleeMovement.A(me, target, robotManager);
            b3 = meleeMovement.B();
        }
        if (b3 != null) {
            this.driveTo(b3);
        }
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        C c = robotManager.C(scannedRobotEvent.getName());
        c.J = true;
        c.I = true;
        B b = c.C();
        B b2 = new B();
        double d = scannedRobotEvent.getDistance();
        double d2 = davidalves.A.A.F.L(scannedRobotEvent.getBearingRadians() + this.getHeadingRadians());
        double d3 = this.getX() + d * Math.sin(d2);
        double d4 = this.getY() + d * Math.cos(d2);
        if (scannedRobotEvent.getVelocity() != 0.0) {
            movementChallengeMode = false;
        }
        b2.P = scannedRobotEvent.getHeadingRadians();
        b2.O = scannedRobotEvent.getVelocity();
        b2.K = d3;
        b2.I = d4;
        b2.a = scannedRobotEvent.getEnergy();
        b2.U = scannedRobotEvent.getTime();
        b2.R = scannedRobotEvent.getName();
        b2.A(b);
        robotManager.A(b2);
        if (mode == 0 && b != null) {
            boolean bl;
            double d5;
            if (target == null) {
                target = c;
            }
            B b3 = target.C();
            B b4 = me.C();
            double d6 = 0.0;
            if (b.a - b2.a > 0.0 && Math.abs(b2.O) == 0.0 && Math.abs(b.O) > 2.0) {
                d6 = Math.abs(b.O) / 2.0 - 1.0;
            }
            if (d6 < 0.0) {
                d6 = 0.0;
            }
            boolean bl2 = (d5 = b.a - d6 - b2.a) <= 3.000001 && d5 >= 0.099999;
            boolean bl3 = bl = b2.S == b.U;
            if (bl2 != bl) {
                Phoenix.error("old test != new test, old = " + bl2);
                Phoenix.error(b3.toString());
                Phoenix.error(b.toString());
            }
            double d7 = d5;
            double d8 = b2.Y;
            if ((bl2 || bl) && d8 != d7) {
                Phoenix.error("old power != new power, old = " + d7 + "  new = " + d8);
                Phoenix.error(b3.toString());
                Phoenix.error(b.toString());
            }
            if (d5 <= 3.0000001 && d5 >= 0.099999) {
                B b5 = Phoenix.me.G.A(scannedRobotEvent.getTime() - 2L);
                B b6 = robotManager.C(scannedRobotEvent.getName()).A(scannedRobotEvent.getTime() - 1L);
                if (b5 == null || b6 == null) {
                    Phoenix.error("no state");
                } else {
                    davidalves.A.A.A a = new davidalves.A.A.A(b6, b5, scannedRobotEvent.getTime() - 1L, b2.Y, 1);
                    target.E().A(a);
                }
            } else if (scannedRobotEvent.getEnergy() != 0.0 && this.getEnergy() != 0.0 && b3.d && b4.d && (double)(scannedRobotEvent.getTime() - b2.S) <= 5.0 + davidalves.A.A.F.A(b2.Y, this.getGunCoolingRate())) {
                B b7 = me.A(scannedRobotEvent.getTime() - 2L);
                B b8 = robotManager.A(scannedRobotEvent.getName(), scannedRobotEvent.getTime() - 1L);
                if (b7 == null || b8 == null) {
                    Phoenix.error("no state");
                } else {
                    davidalves.A.A.A a = new davidalves.A.A.A(b3, b4, scannedRobotEvent.getTime() - 1L, b2.Y, 2);
                    target.E().A(a);
                }
            }
        }
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        C c;
        damageInflicted += Math.min(Phoenix.robotManager.A((String)bulletHitEvent.getName()).a, davidalves.A.A.F.M(bulletHitEvent.getBullet().getPower()));
        B b = robotManager.A(bulletHitEvent.getName());
        if (b == null) {
            Phoenix.warning("State was null on onBulletHit()");
        } else {
            b.a -= davidalves.A.A.F.M(bulletHitEvent.getBullet().getPower());
        }
        Bullet bullet = bulletHitEvent.getBullet();
        if (duelBullets.containsKey(bullet)) {
            c = (C)duelBullets.get(bullet);
            if (c.J) {
                c.D().B(bullet);
            }
            duelBullets.remove(bullet);
        }
        if (meleeBullets.containsKey(bullet)) {
            c = (C)meleeBullets.get(bullet);
            if (c.J && bulletHitEvent.getName().equals(c.G())) {
                c.A().B(bullet);
            }
            meleeBullets.remove(bullet);
        }
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        Bullet bullet = hitByBulletEvent.getBullet();
        damageTaken += Math.min(Phoenix.me.C().a, davidalves.A.A.F.M(bullet.getPower()));
        targetingChallengeMode = false;
        if (mode == 0 && target != null && target.G().equals(hitByBulletEvent.getName())) {
            target.E().A(bullet, me.C(), hitByBulletEvent.getTime(), true, !Phoenix.robotManager.C((String)this.getName()).J);
        }
        Phoenix.robotManager.A((String)hitByBulletEvent.getName()).a += 3.0 * bullet.getPower();
    }

    public void onHitRobot(HitRobotEvent hitRobotEvent) {
        strategy.A(hitRobotEvent);
        B b = robotManager.A(hitRobotEvent.getName());
        if (b != null) {
            b.a = hitRobotEvent.getEnergy();
        }
    }

    public void onBulletHitBullet(BulletHitBulletEvent bulletHitBulletEvent) {
        Bullet bullet = bulletHitBulletEvent.getHitBullet();
        if (mode == 0) {
            target.E().A(bullet, me.C(), bulletHitBulletEvent.getTime(), false, false);
        }
    }

    public void onBulletMissed(BulletMissedEvent bulletMissedEvent) {
        C c;
        Bullet bullet = bulletMissedEvent.getBullet();
        this.getOthers();
        if (duelBullets.containsKey(bullet)) {
            c = (C)duelBullets.get(bullet);
            if (c.J) {
                c.D().C(bullet);
            }
            duelBullets.remove(bullet);
        }
        if (meleeBullets.containsKey(bullet)) {
            c = (C)meleeBullets.get(bullet);
            if (c.J) {
                c.A().C(bullet);
            }
            meleeBullets.remove(bullet);
        }
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        robotManager.B(robotDeathEvent.getName());
        if (this.getOthers() == 1) {
            mode = 0;
        }
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        Phoenix.warning("Hit wall.  Position: " + me.C());
    }

    public void onSkippedTurn(SkippedTurnEvent skippedTurnEvent) {
        Phoenix.warning("Skipped turn " + skippedTurnEvent.getTime());
        ++skippedTurns;
    }

    public void onDeath(DeathEvent deathEvent) {
        Vector vector = this.getAllEvents();
        Iterator iterator = vector.iterator();
        robotManager.B(this.getName());
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof HitByBulletEvent) {
                this.onHitByBullet((HitByBulletEvent)e);
            }
            if (e instanceof BulletHitBulletEvent) {
                this.onBulletHitBullet((BulletHitBulletEvent)e);
            }
            if (e instanceof BulletMissedEvent) {
                this.onBulletMissed((BulletMissedEvent)e);
            }
            if (!(e instanceof BulletHitEvent)) continue;
            this.onBulletHit((BulletHitEvent)e);
        }
        this.endRound();
    }

    public void onWin(WinEvent winEvent) {
        ++wins;
        this.endRound();
    }

    public void endRound() {
        if (botsRemainingAtDeath != null) {
            int n = this.getOthers();
            botsRemainingAtDeath[n] = botsRemainingAtDeath[n] + 1;
        }
        duelBullets.clear();
        meleeBullets.clear();
        int n = 1 + this.getRoundNum();
        if (modeAtRoundStart == 0) {
            Phoenix.info("--- Round ended ---");
        } else {
            Phoenix.info("--- Round ended (" + this.getOthers() + " bots remain) ---");
        }
        Phoenix.info("Damage inflicted: " + davidalves.A.A.F.D(damageInflicted) + "  average per round: " + davidalves.A.A.F.D(damageInflicted / (double)n));
        Phoenix.info("Damage taken: " + davidalves.A.A.F.D(damageTaken) + "  average per round: " + davidalves.A.A.F.D(damageTaken / (double)n));
        Phoenix.info("Turns skipped: " + skippedTurns + "  average per round: " + davidalves.A.A.F.D((double)skippedTurns / (double)n));
        Phoenix.info("Turns stuck in corner: " + timesStuckInCorner + "  average per round: " + davidalves.A.A.F.D((double)timesStuckInCorner / (double)n));
        Phoenix.info("Wins: " + wins + " / " + n + " (" + davidalves.A.A.F.D(100.0 * (double)wins / (double)n) + "%)");
        if (botsRemainingAtDeath != null) {
            StringBuffer stringBuffer = new StringBuffer(100);
            StringBuffer stringBuffer2 = new StringBuffer(100);
            int n2 = 0;
            while (n2 < botsRemainingAtDeath.length) {
                stringBuffer.append("\t");
                stringBuffer.append(n2 + 1);
                stringBuffer2.append("\t");
                stringBuffer2.append(botsRemainingAtDeath[n2]);
                ++n2;
            }
            Phoenix.info("Survival:");
            Phoenix.info(stringBuffer.toString());
            Phoenix.info(stringBuffer2.toString());
        }
    }

    public static davidalves.A.E.F createDuelGun() {
        davidalves.A.E.C[] cArray = new davidalves.A.E.C[2];
        cArray[0] = new davidalves.A.E.E(new davidalves.A.E.A[]{new H(3), new F(3), new davidalves.A.E.A.D(3)}, 15, 0.95f, 5.0f, true);
        davidalves.A.E.E e = new davidalves.A.E.E(new davidalves.A.E.A[]{new davidalves.A.E.A.E(new double[]{280.0, 400.0, 700.0}, 3), new davidalves.A.E.A.E(new double[]{2.0, 4.0, 6.0}, 0), new H(3), new F(3), new davidalves.A.E.A.C(2), new J(0.9, -0.5, 3), new J(0.9, 0.75, 4), new davidalves.A.E.A.B(2), new K()}, 15, 0.95f, 5.0f, false);
        davidalves.A.E.E e2 = new davidalves.A.E.E(new davidalves.A.E.A[]{new davidalves.A.E.A.E(new double[]{150.0, 320.0, 500.0, 950.0}, 3), new davidalves.A.E.A.E(new double[]{1.0, 3.0, 5.0, 7.0}, 0), new H(3), new F(5), new davidalves.A.E.A.C(3), new J(0.9, -0.6, 4), new J(0.9, 0.8, 5), new davidalves.A.E.A.B(3), new K()}, 15, 0.95f, 5.0f, false);
        cArray[1] = new davidalves.A.E.D(e, e2, 0.5f);
        return new davidalves.A.E.F(cArray, 1);
    }

    public static davidalves.A.E.F createMeleeGun() {
        davidalves.A.E.C[] cArray = new davidalves.A.E.C[2];
        davidalves.A.E.E e = new davidalves.A.E.E(new davidalves.A.E.A[]{new davidalves.A.E.A.E(new double[]{280.0, 400.0, 700.0}, 3), new F(3), new davidalves.A.E.A.D(5)}, 15, 0.95f, 5.0f, true);
        davidalves.A.E.E e2 = new davidalves.A.E.E(new davidalves.A.E.A[]{new davidalves.A.E.A.E(new double[]{150.0, 320.0, 500.0, 950.0}, 3), new F(5), new davidalves.A.E.A.D(3)}, 15, 0.95f, 5.0f, true);
        cArray[0] = new davidalves.A.E.D(e, e2, 0.5f);
        davidalves.A.E.E e3 = new davidalves.A.E.E(new davidalves.A.E.A[]{new davidalves.A.E.A.E(new double[]{280.0, 400.0, 700.0}, 3), new davidalves.A.E.A.E(new double[]{2.0, 4.0, 6.0}, 0), new G(), new H(3), new F(3), new davidalves.A.E.A.C(2), new K(), new J(0.9, -0.45, 2), new J(0.9, 0.45, 2)}, 15, 0.95f, 5.0f, false);
        davidalves.A.E.E e4 = new davidalves.A.E.E(new davidalves.A.E.A[]{new davidalves.A.E.A.E(new double[]{150.0, 320.0, 500.0, 950.0}, 3), new davidalves.A.E.A.E(new double[]{1.0, 3.0, 5.0, 7.0}, 0), new H(3), new F(5), new davidalves.A.E.A.C(3), new K(), new J(0.9, -0.3, 3), new J(0.9, 0.3, 3)}, 15, 0.95f, 5.0f, false);
        cArray[1] = new davidalves.A.E.D(e3, e4, 0.5f);
        return new davidalves.A.E.F(cArray, 10);
    }

    public static davidalves.A.C.B createDuelMovement() {
        davidalves.A.C.A a = new davidalves.A.C.A();
        a.E();
        return a;
    }
}

