/*
 * Decompiled with CFR 0.152.
 */
package benhorner.utility.units;

import benhorner.utility.units.Duration;
import benhorner.utility.units.Speed;
import benhorner.utility.units.interfaces.AbsoluteToRelative;
import benhorner.utility.units.interfaces.Continuum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Distance
implements Continuum<Distance>,
AbsoluteToRelative<Distance, Distance> {
    private double pixels;

    public Distance(double pixels) {
        assert (!Double.isNaN(pixels));
        this.pixels = pixels;
    }

    @Override
    public Distance negate() {
        return new Distance(-this.pixels);
    }

    @Override
    public Distance add(Distance distance) {
        return new Distance(this.pixels + distance.pixels);
    }

    @Override
    public Distance subtract(Distance distance) {
        return new Distance(this.pixels - distance.pixels);
    }

    @Override
    public Distance multiply(double scalar) {
        return new Distance(this.pixels * scalar);
    }

    @Override
    public Distance divide(double scalar) {
        return new Distance(this.pixels / scalar);
    }

    @Override
    public double divide(Distance distance) {
        return this.pixels / distance.pixels;
    }

    public Speed divide(Duration duration) {
        return new Speed(this.pixels / duration.toDouble());
    }

    public Duration divide(Speed speed) {
        return new Duration(this.pixels / speed.toDouble());
    }

    @Override
    public double toDouble() {
        return this.pixels;
    }

    public String toString() {
        return String.valueOf(Long.toString(Math.round(this.toDouble()))) + "p";
    }

    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o.getClass() == this.getClass();
        if (result) {
            Distance distance = (Distance)o;
            result = distance.pixels == this.pixels;
        }
        return result;
    }

    public int hashCode() {
        return new Double(this.pixels).hashCode();
    }
}

