/*
 * Decompiled with CFR 0.152.
 */
package dsekercioglu.mega.rGun.gun;

import dsekercioglu.mega.core.DistancedGuessFactor;
import dsekercioglu.mega.core.GuessFactor;
import dsekercioglu.mega.core.KNNView;
import dsekercioglu.mega.core.wiki.FastMath;
import dsekercioglu.mega.rGun.BattleInfo;
import dsekercioglu.mega.rGun.gun.Predictor;
import java.util.ArrayList;

public class ASGun
extends Predictor {
    final double[] WEIGHTS = new double[]{1.0, 1.0, 1.0, 1.0, 1.0};
    final int K = 25;
    final int DIVISOR = 1;
    final double DECAY_FACTOR = 2.5;
    final double VIRTUAL_WAVE_WEIGHT = 0.5;
    KNNView knnView = new KNNView(25, 1, this.WEIGHTS);

    public ASGun() {
        this.knnView.addDataPoint(new double[]{0.5, 0.5, 0.5, 0.5, 0.5}, new GuessFactor(0.0, 1.0E-4, 0));
    }

    @Override
    public ArrayList<GuessFactor> getGuessFactors(BattleInfo battleInfo) {
        ArrayList<DistancedGuessFactor> distancedGuessFactors = this.knnView.nearestNeighbours(this.getDataPoint(battleInfo));
        ArrayList<GuessFactor> guessFactors = new ArrayList<GuessFactor>();
        int maxScan = 0;
        for (DistancedGuessFactor distancedGuessFactor : distancedGuessFactors) {
            GuessFactor guessFactor = distancedGuessFactor.getGuessFactor();
            GuessFactor weightedGuessFactor = new GuessFactor(guessFactor.GUESS_FACTOR, guessFactor.getWeight() / (1.0 + distancedGuessFactor.getDistance()), guessFactor.SCAN);
            guessFactors.add(weightedGuessFactor);
            maxScan = Math.max(guessFactor.SCAN, maxScan);
        }
        ArrayList<GuessFactor> weightedGuessFactors = new ArrayList<GuessFactor>();
        for (GuessFactor guessFactor : guessFactors) {
            weightedGuessFactors.add(new GuessFactor(guessFactor.GUESS_FACTOR, guessFactor.getWeight() * Math.pow(2.5, (double)(guessFactor.SCAN - maxScan) / guessFactor.getWeight()), guessFactor.SCAN));
        }
        return weightedGuessFactors;
    }

    @Override
    public void addData(BattleInfo battleInfo, GuessFactor guessFactor, boolean real) {
        if (real) {
            GuessFactor realWave = new GuessFactor(guessFactor.GUESS_FACTOR, guessFactor.getWeight(), guessFactor.SCAN);
            this.knnView.addDataPoint(this.getDataPoint(battleInfo), realWave);
        } else {
            GuessFactor virtual = new GuessFactor(guessFactor.GUESS_FACTOR, guessFactor.getWeight() * 0.5, guessFactor.SCAN);
            this.knnView.addDataPoint(this.getDataPoint(battleInfo), virtual);
        }
    }

    public double[] getDataPoint(BattleInfo battleInfo) {
        double bulletVelocity = 20.0 - 3.0 * battleInfo.getLastFirePower();
        double mea = FastMath.asin(8.0 / bulletVelocity);
        return new double[]{Math.abs(battleInfo.getEnemyLateralVelocity()) / 8.0, battleInfo.getBotDistance() / bulletVelocity / 91.0, Math.min(battleInfo.getMEA(1) / mea, 1.0), (battleInfo.getEnemyLateralAcceleration() + 2.0) / 3.0, (battleInfo.getLastFirePower() - 0.1) / 2.9};
    }
}

