/*
 * Decompiled with CFR 0.152.
 */
package ultra.core;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.List;
import ultra.Defender;
import ultra.core.BotDump;
import ultra.core.RemoteBot;

public class Utils {
    public static final double HALF_BOT_DIAG = 18.0;
    public static final double FULLFIRE_MAX_DIST = 150.0;
    public static final double LOWFIRE_MAX_DIST = 800.0;

    public static double angle3Pts(Point2D.Double center, Point2D.Double point1, Point2D.Double point2) {
        return Utils.angle3Pts(center.x, center.y, point1.x, point1.y, point2.x, point2.y);
    }

    public static double vectorProduct(Vector v1, Vector v2) {
        return v1.getX() * v2.getY() - v1.getY() * v2.getX();
    }

    public static double scalarProduct(Vector v1, Vector v2) {
        return v1.getX() * v2.getX() + v1.getY() * v2.getY();
    }

    public static double dist2Pts(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static double dist2Pts(Point2D p1, Point2D p2) {
        return Utils.dist2Pts(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public static Point2D projectPoint(Point2D p, Vector v) {
        return new Point2D.Double(p.getX() + v.getX(), p.getY() + v.getY());
    }

    public static Point2D projectPoint(Point2D start, double distance, double bearing) {
        double radBearing = Math.toRadians(-bearing) + 1.5707963267948966;
        double x = distance * Math.cos(radBearing);
        double y = distance * Math.sin(radBearing);
        return new Point2D.Double(start.getX() + x, start.getY() + y);
    }

    public static double angle3Pts(double centerX, double centerY, double p1X, double p1Y, double p2X, double p2Y) {
        Vector v1 = new Vector(centerX, centerY, p1X, p1Y);
        Vector v2 = new Vector(centerX, centerY, p2X, p2Y);
        double productOfNorms = v1.getNorm() * v2.getNorm();
        double vectProduct = Utils.vectorProduct(v1, v2);
        double scalProduct = Utils.scalarProduct(v1, v2);
        double cos = scalProduct / productOfNorms;
        double sin = vectProduct / productOfNorms;
        double radAngle = Math.acos(cos);
        if (sin < 0.0) {
            radAngle = Math.PI * 2 - radAngle;
        }
        return radAngle;
    }

    public static float getAzimuth(Point2D src, Point2D dst) {
        double val = Math.atan2(dst.getX() - src.getX(), dst.getY() - src.getY());
        double degrees = Math.toDegrees(val);
        if (degrees < 0.0) {
            degrees += 360.0;
        }
        return (float)degrees;
    }

    public static double fixVelocity(double velocity) {
        return Math.max(-8.0, Math.min(8.0, velocity));
    }

    public static double round(double val, int nb) {
        double pow = Math.pow(10.0, nb);
        return (double)Math.round(val * pow) / pow;
    }

    public static boolean ahead(RemoteBot r, double distance) {
        r.setAhead(distance);
        return false;
    }

    public static void to(BotDump r, Point2D.Double p) {
        Utils.to(r, p.x, p.y);
    }

    public static void to(BotDump r, double toX, double toY) {
        double heading = Utils.getHeadingTo(r, toX, toY);
        Utils.rotate(r, heading);
        Utils.ahead(r, Utils.getDistanceTo(r, toX, toY));
    }

    public static void rotate(BotDump r, double heading) {
        if (Math.abs(r.getHeading() - heading) < 0.01) {
            return;
        }
        double a = Utils.fixAngle(heading - r.getHeading());
        if (a <= 180.0) {
            r.setTurnRight(a);
        } else {
            r.setTurnLeft(360.0 - a);
        }
    }

    public static double rotateGun(BotDump r, double heading) {
        if (Math.abs(r.getGunHeading() - heading) < 0.01) {
            return Double.NaN;
        }
        double a = Utils.fixAngle(heading - r.getGunHeading());
        if (a <= 180.0) {
            r.setTurnGunRight(a);
        } else {
            r.setTurnGunLeft(360.0 - a);
        }
        return a;
    }

    public static boolean rotateRadar(BotDump r, double heading) {
        double bearing = Utils.fixAngle(heading - r.getRadarHeading());
        if (bearing <= 180.0) {
            r.setTurnRadarRight(bearing);
        } else {
            r.setTurnRadarLeft(360.0 - bearing);
        }
        return true;
    }

    public static double fixAngle(double angle) {
        while (angle < 0.0) {
            angle += 360.0;
        }
        while (angle > 360.0) {
            angle -= 360.0;
        }
        return angle;
    }

    public static Point2D.Double getPosition(BotDump r, double bearing, double distance) {
        double radBearing = Math.toRadians(-bearing) + 1.5707963267948966;
        double tx = distance * Math.cos(radBearing);
        double ty = distance * Math.sin(radBearing);
        return new Point2D.Double(r.x + tx, r.y + ty);
    }

    public static Point2D.Double getPosition(Point2D.Double r, double bearing, double distance) {
        double radBearing = Math.toRadians(-bearing) + 1.5707963267948966;
        double tx = distance * Math.cos(radBearing);
        double ty = distance * Math.sin(radBearing);
        return new Point2D.Double(r.x + tx, r.y + ty);
    }

    public static double getDistanceTo(BotDump r, Point2D.Double p) {
        return Utils.getDistanceTo(r.x, r.y, p.x, p.y);
    }

    public static double getDistanceTo(BotDump r, double x2, double y2) {
        return Utils.getDistanceTo(r.x, r.y, x2, y2);
    }

    public static double getDistanceTo(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static double getHeadingTo(BotDump r, Point2D.Double target) {
        return Utils.getHeadingTo(r, target.x, target.y);
    }

    public static double getHeadingTo(BotDump r, double tx, double ty) {
        return Utils.angle(r, new Point2D.Double(tx, ty));
    }

    public static double angle(Point2D.Double a, Point2D.Double b) {
        double dx = b.x - a.x;
        double dy = b.y - a.y;
        double angle = 0.0;
        angle = dx == 0.0 ? (dy == 0.0 ? 0.0 : (dy > 0.0 ? 1.5707963267948966 : 4.71238898038469)) : (dy == 0.0 ? (dx > 0.0 ? 0.0 : Math.PI) : (dx < 0.0 ? Math.atan(dy / dx) + Math.PI : (dy < 0.0 ? Math.atan(dy / dx) + Math.PI * 2 : Math.atan(dy / dx))));
        return Math.toDegrees(-angle + 1.5707963267948966);
    }

    public static double computeFirePower(BotDump r, MovingStrat strat, double targetDistance, double accuracy, double targetEnergy) {
        double pow = 0.0;
        if (strat == MovingStrat.STATIC) {
            pow = 3.0;
        } else if (accuracy > 0.2) {
            pow = 3.0;
        } else if (targetDistance < 150.0) {
            pow = 3.0;
        } else if (r.getEnergy() < 20.0) {
            pow = 0.1;
        } else if (targetDistance > 800.0) {
            pow = 0.0;
        } else {
            double distPercent = (targetDistance - 150.0) / 650.0;
            pow = Math.max(0.1, 3.0 - distPercent * 3.0);
        }
        if (Utils.damageForPower(pow) > targetEnergy) {
            while (Utils.damageForPower(pow) > targetEnergy) {
                pow -= 0.1;
            }
            if (Utils.damageForPower(pow) < targetEnergy) {
                pow += 0.1;
            }
        }
        return pow;
    }

    public static double damageForPower(double pow) {
        return 4.0 * pow + Math.max(0.0, 2.0 * (pow - 1.0));
    }

    public static void drawMark(Graphics2D g, Point2D p, double size) {
        g.drawLine((int)(p.getX() - size), (int)p.getY(), (int)(p.getX() + size), (int)p.getY());
        g.drawLine((int)p.getX(), (int)(p.getY() + size), (int)p.getX(), (int)(p.getY() - size));
    }

    public static Defender.UltraAimPoint getNearest(List<Defender.UltraAimPoint> dangerousAimPoints, double x, double y) {
        double dist = Double.MAX_VALUE;
        Defender.UltraAimPoint nearest = null;
        for (Defender.UltraAimPoint ump : dangerousAimPoints) {
            double tdist = Utils.getDistanceTo(x, y, ump.x, ump.y);
            if (!(tdist < dist)) continue;
            dist = tdist;
            nearest = ump;
        }
        return nearest;
    }

    public static enum MovingStrat {
        UNKONWN,
        STATIC,
        LINEAR,
        CIRCLE,
        RANDOM;

    }

    public static class Vector {
        public double x;
        public double y;

        public Vector(Point2D.Double p1, Point2D.Double p2) {
            this.x = p2.x - p1.x;
            this.y = p2.y - p1.y;
        }

        public Vector(double vX, double vY) {
            this.x = vX;
            this.y = vY;
        }

        public Vector(double p1X, double p1Y, double p2X, double p2Y) {
            this(p2X - p1X, p2Y - p1Y);
        }

        public Vector clone() {
            return new Vector(this.x, this.y);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public Vector scale(double factor) {
            this.x *= factor;
            this.y *= factor;
            return this;
        }

        public String toString() {
            return String.valueOf(this.x) + ", " + this.y;
        }

        public void addVect(Vector v) {
            this.x += v.x;
            this.y += v.y;
        }

        public Vector normalize() {
            double norm = this.getNorm();
            if (norm != 0.0) {
                this.x /= norm;
                this.y /= norm;
            } else {
                this.y = 0.0;
                this.x = 0.0;
            }
            return this;
        }

        public double getNorm() {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        }

        public Vector invert() {
            this.x = -this.x;
            this.y = -this.y;
            return this;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Vector) {
                Vector vObj = (Vector)obj;
                return vObj.x == this.x && vObj.y == this.y;
            }
            return false;
        }
    }
}

