/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.group.mirror;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import xander.cat.group.mirror.AntiMirrorDrive;
import xander.cat.group.mirror.MirrorDetector;
import xander.cat.group.mirror.MirrorPlan;
import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.drive.Direction;
import xander.core.drive.DistancingEquation;
import xander.core.drive.DriveState;
import xander.core.drive.OrbitalDrivePredictor;
import xander.core.gun.targeter.Targeter;
import xander.core.math.RCMath;
import xander.core.track.Snapshot;
import xander.core.track.SnapshotHistory;
import xander.core.track.Wave;

public class AntiMirrorTargeter
implements Targeter {
    private MirrorPlan mirrorPlan;
    private MirrorDetector mirrorDetector;
    private RobotProxy robotProxy;
    private SnapshotHistory snapshotHistory;
    private OrbitalDrivePredictor orbitalDriver;

    public AntiMirrorTargeter(MirrorPlan mirrorPlan, MirrorDetector mirrorDetector, OrbitalDrivePredictor orbitalDriver) {
        this.orbitalDriver = orbitalDriver;
        this.mirrorPlan = mirrorPlan;
        this.mirrorDetector = mirrorDetector;
        this.robotProxy = Resources.getRobotProxy();
        this.snapshotHistory = Resources.getSnapshotHistory();
    }

    @Override
    public String getTargetingType() {
        return "Mirror";
    }

    @Override
    public boolean canAimAt(Snapshot target) {
        long currentTime = this.robotProxy.getTime();
        long time = currentTime - (long)this.mirrorDetector.getMirrorDetectedTicksAgo();
        return this.snapshotHistory.getMySnapshot(time, false) != null;
    }

    @Override
    public double getAim(Snapshot target, Snapshot myself, Wave wave) {
        long currentTime = this.robotProxy.getTime();
        long time = currentTime - (long)this.mirrorDetector.getMirrorDetectedTicksAgo();
        double bulletVelocity = wave.getBulletVelocity();
        double distanceToOpponent = Double.MAX_VALUE;
        double bulletTravelDistance = 0.0;
        Snapshot mySnapshot = this.snapshotHistory.getMySnapshot(time, false);
        DriveState myDriveState = new DriveState(mySnapshot);
        Rectangle2D.Double battlefieldBounds = this.robotProxy.getBattleFieldSize();
        while (bulletTravelDistance < distanceToOpponent - bulletVelocity * Math.abs(myDriveState.getVelocity() / 8.0)) {
            bulletTravelDistance += bulletVelocity;
            Point2D.Double center = AntiMirrorDrive.getOrbitCenter(this.robotProxy.getX(), this.robotProxy.getY(), battlefieldBounds);
            if (time < currentTime) {
                mySnapshot = this.snapshotHistory.getMySnapshot(time, true);
                myDriveState.setState(mySnapshot);
            } else {
                Direction direction = this.mirrorPlan.getDirection(time);
                this.orbitalDriver.advanceOrbitalDriveState(myDriveState, center, 100.0, direction, 1, 8.0, DistancingEquation.NO_ADJUST);
            }
            ++time;
            distanceToOpponent = 2.0 * RCMath.getDistanceBetweenPoints(myDriveState.getPosition().x, myDriveState.getPosition().y, battlefieldBounds.getCenterX(), battlefieldBounds.getCenterY());
        }
        double futureOppX = battlefieldBounds.getMaxX() - myDriveState.getPosition().x;
        double futureOppY = battlefieldBounds.getMaxY() - myDriveState.getPosition().y;
        double targetAngle = RCMath.getRobocodeAngle(myself.getX(), myself.getY(), futureOppX, futureOppY);
        return targetAngle;
    }
}

