/*
 * Decompiled with CFR 0.152.
 */
package xander.cat.processor;

import xander.core.Resources;
import xander.core.gun.detect.TargetingDetector;
import xander.core.track.Wave;
import xander.gfws.BasicFactorArrays;
import xander.gfws.FactorIndexer;
import xander.gfws.distributer.WaveDistributer;
import xander.gfws.distributer.WeightDistributer;
import xander.gfws.processor.FactorArrayProcessor;
import xander.paint.Paintables;

public class TargetingDetectorFactorArrayProcessor
implements FactorArrayProcessor {
    private String painterName;
    private int factors;
    private TargetingDetector[] targetingDetectors;
    private WeightDistributer distributer = new WaveDistributer();
    private int testShotsThreshold = 2;
    private FactorIndexer factorIndexer;

    public TargetingDetectorFactorArrayProcessor(String painterName, int factors, TargetingDetector ... targetingDetectors) {
        this.painterName = painterName;
        this.factors = factors;
        this.targetingDetectors = targetingDetectors;
        this.factorIndexer = Resources.getOpponentFactorIndexer();
        Paintables.addPaintable(this);
    }

    @Override
    public String getPainterName() {
        return this.painterName;
    }

    @Override
    public int getFactors() {
        return this.factors;
    }

    @Override
    public double[] getFactorArray(Wave surfWave, double currentMinFactorAngle, double currentMaxFactorAngle) {
        double[] factorArray = new double[this.factors];
        int i = 0;
        while (i < this.targetingDetectors.length) {
            double weight;
            double d = weight = this.targetingDetectors[i].getShotsTested() > this.testShotsThreshold ? Math.pow(this.targetingDetectors[i].getDetectionPercentage(), 2.0) : 0.05;
            if (weight > 0.0) {
                double angle = this.targetingDetectors[i].getDetectionAngle(surfWave);
                double factorAngle = BasicFactorArrays.getFactorAngle(surfWave, angle);
                double preciseIndex = this.factorIndexer.getPreciseFactorIndex(factorAngle, this.factors, surfWave.getSurfDirection(), surfWave.getInitialMEA());
                this.distributer.addWeight(factorArray, preciseIndex, weight, surfWave.getOriginDistance(), surfWave.getBulletVelocity(), surfWave.getSurfDirection());
            }
            ++i;
        }
        return factorArray;
    }
}

