/*
 * Decompiled with CFR 0.152.
 */
package pedersen.divination.segmentation;

import java.util.EnumSet;
import java.util.Iterator;
import pedersen.debug.DebuggableBase;
import pedersen.divination.CombatWave;
import pedersen.divination.FiringSolution;
import pedersen.divination.TargetAnalysis;
import pedersen.divination.analysis.AnalysisConfiguration;
import pedersen.divination.analysis.WaveAnalysis;
import pedersen.divination.segmentation.Segmentation;

public class Segmenter
extends DebuggableBase
implements WaveAnalysis {
    private EnumSet<Segmentation> segmentations;
    private AnalysisConfiguration analysisConfiguration;
    private WaveAnalysis common;
    private final Segmentation segmentation;
    private final WaveAnalysis[] waveAnalyses;

    public Segmenter(AnalysisConfiguration analysisConfiguration, EnumSet<Segmentation> segmentations) {
        this.analysisConfiguration = analysisConfiguration;
        this.common = this.analysisConfiguration.getWidget();
        this.segmentations = segmentations;
        Iterator iterator = this.segmentations.iterator();
        if (!iterator.hasNext()) {
            this.segmentation = null;
            this.waveAnalyses = null;
            throw new RuntimeException("Segmenter initialized with an empty Set<Segmentation>.");
        }
        this.segmentation = (Segmentation)iterator.next();
        iterator.remove();
        this.waveAnalyses = new WaveAnalysis[this.segmentation.getArraySize()];
    }

    @Override
    public FiringSolution getFiringSolution(CombatWave wave, TargetAnalysis targetAnalysis) {
        return this.getWaveAnalysisForRead(wave, targetAnalysis).getFiringSolution(wave, targetAnalysis);
    }

    @Override
    public void recordWave(CombatWave wave, TargetAnalysis targetAnalysis) {
        WaveAnalysis waveAnalysis = this.getWaveAnalysisForWrite(wave, targetAnalysis);
        if (waveAnalysis == null) {
            waveAnalysis = this.initializeWaveAnalysis(wave, targetAnalysis);
        }
        waveAnalysis.recordWave(wave, targetAnalysis);
        if (this.common != null) {
            this.common.recordWave(wave, targetAnalysis);
        }
    }

    private WaveAnalysis getWaveAnalysisForWrite(CombatWave wave, TargetAnalysis targetAnalysis) {
        return this.waveAnalyses[this.segmentation.getIndex(wave, targetAnalysis, this.waveAnalyses.length)];
    }

    private WaveAnalysis getWaveAnalysisForRead(CombatWave wave, TargetAnalysis targetAnalysis) {
        WaveAnalysis waveAnalysis = this.getWaveAnalysisForWrite(wave, targetAnalysis);
        if (waveAnalysis == null) {
            waveAnalysis = this.common;
        }
        return waveAnalysis;
    }

    private WaveAnalysis initializeWaveAnalysis(CombatWave wave, TargetAnalysis targetAnalysis) {
        int index = this.segmentation.getIndex(wave, targetAnalysis, this.waveAnalyses.length);
        this.waveAnalyses[index] = this.segmentations.isEmpty() ? this.analysisConfiguration.getWidget() : new Segmenter(this.analysisConfiguration, (EnumSet<Segmentation>)this.segmentations.clone());
        this.cleanupSegmentations();
        return this.waveAnalyses[index];
    }

    private void cleanupSegmentations() {
        WaveAnalysis[] waveAnalysisArray = this.waveAnalyses;
        int n = this.waveAnalyses.length;
        int n2 = 0;
        while (n2 < n) {
            WaveAnalysis waveAnalysis = waveAnalysisArray[n2];
            if (waveAnalysis == null) {
                return;
            }
            ++n2;
        }
        this.segmentations = null;
        this.common = null;
    }

    @Override
    public void paint() {
        this.analysisConfiguration.paint();
    }

    @Override
    public String debugPath(CombatWave wave, TargetAnalysis targetAnalysis) {
        int index = this.segmentation.getIndex(wave, targetAnalysis, this.waveAnalyses.length);
        if (this.waveAnalyses[index] == null) {
            return "C(" + index + "), " + this.common.debugPath(wave, targetAnalysis);
        }
        return String.valueOf(index) + ", " + this.waveAnalyses[index].debugPath(wave, targetAnalysis);
    }
}

