/*
 * Decompiled with CFR 0.152.
 */
package demetrix.misc;

public class Physics {
    public static double getBulletVelocity(double bulletPower) {
        return 20.0 - (double)3 * bulletPower;
    }

    public static double getBulletPower(double bulletVelocity) {
        double bp = (20.0 - bulletVelocity) / (double)3;
        if (bp > (double)3) {
            return 3;
        }
        if (bp < 0.1) {
            return 0.1;
        }
        return bp;
    }

    public static double getGunHeat(double bulletPower) {
        return 1.0 + bulletPower / (double)5;
    }

    public static double getDamageOnBulletHit(double bulletPower) {
        return (double)4 * bulletPower + Math.max(0.0, (double)2 * (bulletPower - 1.0));
    }

    public static double getEnergyBackOnBulletHit(double bulletPower) {
        return (double)3 * bulletPower;
    }

    public static double getDamageOnRobotHit() {
        return 0.6;
    }

    public static double getDamageOnWallHit(double velocityChange) {
        return Math.max(0.0, Math.abs(velocityChange) / (double)2 - 1.0);
    }
}

