/*
 * Decompiled with CFR 0.152.
 */
package xander.core.gun;

import xander.core.Resources;
import xander.core.RobotProxy;
import xander.core.gun.Aim;
import xander.core.gun.Gun;
import xander.core.gun.GunController;
import xander.core.gun.power.PowerSelector;
import xander.core.gun.targeter.Targeter;
import xander.core.log.Log;
import xander.core.log.Logger;
import xander.core.math.RCMath;
import xander.core.math.RCPhysics;
import xander.core.track.Snapshot;

public class XanderGun
implements Gun {
    private static final Log log = Logger.getLog(XanderGun.class);
    private Targeter targeter;
    private PowerSelector powerSelector;
    private RobotProxy robotProxy;
    private long nextFireTick;
    private double nextFirePower;
    private String gunName;
    private double minEnergyToFire = 0.5;
    private double lowEnergyConservationRate = 1.0;

    public XanderGun(String gunName, Targeter targeter, PowerSelector powerSelector) {
        this.gunName = gunName;
        this.targeter = targeter;
        this.powerSelector = powerSelector;
        this.robotProxy = Resources.getRobotProxy();
    }

    public XanderGun(Targeter targeter, PowerSelector powerSelector) {
        this(null, targeter, powerSelector);
    }

    public double getMinEnergyToFire() {
        return this.minEnergyToFire;
    }

    public void setMinEnergyToFire(double minEnergyToFire) {
        this.minEnergyToFire = minEnergyToFire;
    }

    public double getLowEnergyConservationRate() {
        return this.lowEnergyConservationRate;
    }

    public void setLowEnergyConservationRate(double lowEnergyConservationRate) {
        this.lowEnergyConservationRate = lowEnergyConservationRate;
    }

    @Override
    public String getName() {
        return this.gunName == null ? String.valueOf(this.targeter.getTargetingType()) + " Xander Gun" : this.gunName;
    }

    @Override
    public void onRoundBegin() {
        this.nextFireTick = 0L;
    }

    @Override
    public boolean canFireAt(Snapshot target) {
        return this.targeter.canAimAt(target);
    }

    @Override
    public Aim getAim(Snapshot target, Snapshot myself) {
        Aim aim = null;
        if (this.targeter.canAimAt(target)) {
            double bulletVelocity;
            double aimHeading;
            if (this.robotProxy.getTime() != target.getTime()) {
                log.warn(String.valueOf(this.getName()) + " aiming with old target data (from " + (this.robotProxy.getTime() - target.getTime()) + " ticks ago)");
            }
            double[] myNextXY = myself.getNextXY();
            myself = myself.advance(myNextXY[0], myNextXY[1]);
            target = target.advance(myself.getX(), myself.getY());
            double firePower = this.powerSelector.getFirePower(target);
            if (this.powerSelector.isAutoAdjustAllowed()) {
                double availableFiringEnergy = this.robotProxy.getEnergy() - this.minEnergyToFire;
                firePower = Math.min(firePower, availableFiringEnergy * this.lowEnergyConservationRate);
                firePower = Math.min(firePower, RCPhysics.getFirePowerToKill(target.getEnergy()));
            }
            if (firePower > 0.09 && firePower < this.robotProxy.getEnergy() && (aimHeading = this.targeter.getAim(target, myself, bulletVelocity = RCPhysics.getBulletVelocity(firePower))) >= 0.0) {
                aim = new Aim(aimHeading, firePower);
            }
        }
        return aim;
    }

    @Override
    public boolean fireAt(Snapshot target, Snapshot myself, GunController gunController) {
        boolean bulletFired = false;
        if (gunController.isGunReadyToFire() && this.robotProxy.getTime() == this.nextFireTick) {
            gunController.setFireBullet(this, myself, target, this.nextFirePower);
            bulletFired = true;
        }
        if (gunController.getPreciseTimeUntilReadyToFire() < 2.0) {
            Aim aim = this.getAim(target, myself);
            if (aim != null) {
                this.nextFireTick = this.robotProxy.getTime() + 1L;
                this.nextFirePower = aim.getFirePower();
                double turn = RCMath.getTurnAngle(this.robotProxy.getGunHeadingDegrees(), aim.getHeading());
                if (turn != 0.0) {
                    gunController.setTurnGunRightDegrees(turn);
                }
            }
        } else {
            double oppHeading = RCMath.getRobocodeAngle(myself.getLocation(), target.getLocation());
            double turn = RCMath.getTurnAngle(this.robotProxy.getGunHeadingDegrees(), oppHeading);
            gunController.setTurnGunRightDegrees(turn);
        }
        return bulletFired;
    }
}

