/*
 * Decompiled with CFR 0.152.
 */
package DM.mega;

import DM.mega.StickyGoo;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class MagicStick {
    static final int BINS = 73;
    static final int ACCEL_SEGS = 3;
    static final int DIST_SEGS = 3;
    static final int VEL_SEGS = 3;
    static final int WALL_DIST_SEGS = 3;
    static final int HEAD_SEGS = 3;
    static final int B_POWER_SEGS = 3;
    static final int ACCEL_BIN = 0;
    static final int DIST_BIN = 1;
    static final int VEL_BIN = 2;
    static final int WALL_BIN = 3;
    static final int REV_WALL_BIN = 4;
    static final int HEAD_BIN = 5;
    static final int BULLET_BIN = 6;
    private final HashMap<float[], Double> neighborMap;
    private final List<StickyGoo> launches;
    final double[] dangerZones;
    final AdvancedRobot self;
    final Point2D.Double enemyPos;
    final Point2D.Double myCenter;
    final double distSegSize = 333.3333333333333;
    final double wallDistSegSize = 333.3333333333333;
    final int MAX_MAP_SIZE = 255;
    final int SHRINK_TARGET = 84;
    final int NUM_NEIGHBORS = 7;
    double bPower;
    double oldVelocity;
    double healthDisadvantage;
    double knnAcc = 0.9;
    double shotPower;
    double knnConfidence;
    double eDistance;
    long timeToShoot;
    long passCount;
    int eDir;
    int eLatDir;
    int shots;
    int hits;
    float currDistSeg;
    float currWallSeg;
    float revWallSeg;
    float currVelSeg;
    float accelSeg;
    float headSeg;
    float bPowerSeg;
    float lastWDSeg;
    float lastRevWDSeg;
    float lastDSeg;
    float lastVSeg;
    float lastASeg;
    float lastHSeg;
    float lastBPSeg;
    boolean isMC;

    public MagicStick(AdvancedRobot advancedRobot, boolean bl) {
        this.self = advancedRobot;
        this.isMC = bl;
        this.launches = new ArrayList<StickyGoo>();
        this.neighborMap = new HashMap();
        this.enemyPos = new Point2D.Double(0.0, 0.0);
        this.myCenter = new Point2D.Double(0.0, 0.0);
        this.dangerZones = new double[73];
        this.bPower = 1.7;
    }

    public Bullet update(ScannedRobotEvent scannedRobotEvent, double d) {
        this.healthDisadvantage = Math.min(3.0, Math.max(-3.0, (scannedRobotEvent.getEnergy() - this.self.getEnergy()) / 25.0));
        Bullet bullet = null;
        double d2 = 2.0 * Math.atan(18.0 / scannedRobotEvent.getDistance());
        if (this.timeToShoot == this.self.getTime() && this.self.getGunTurnRemainingRadians() == 0.0 && (this.bPower < this.self.getEnergy() && this.bPower > 0.0 || this.isMC) && this.self.getGunHeat() == 0.0) {
            bullet = this.self.setFireBullet(this.bPower);
            this.shotPower = this.bPower;
            if (bullet != null) {
                this.launches.add(new StickyGoo(this.self.getX(), this.self.getY(), d, Rules.getBulletSpeed((double)this.shotPower), this.self.getTime(), this.eLatDir, this.currDistSeg, this.currVelSeg, this.accelSeg, this.currWallSeg, this.revWallSeg, this.headSeg, this.bPowerSeg, true));
            }
        }
        this.myCenter.x = this.self.getX();
        this.myCenter.y = this.self.getY();
        this.enemyPos.x = this.myCenter.x + Math.sin(d) * scannedRobotEvent.getDistance();
        this.enemyPos.y = this.myCenter.y + Math.cos(d) * scannedRobotEvent.getDistance();
        int n = scannedRobotEvent.getVelocity() == 0.0 ? this.eDir : (this.eDir = scannedRobotEvent.getVelocity() > 0.0 ? 1 : -1);
        this.eLatDir = Math.sin(scannedRobotEvent.getHeadingRadians() - d) * scannedRobotEvent.getVelocity() == 0.0 ? this.eLatDir : (Math.sin(scannedRobotEvent.getHeadingRadians() - d) * scannedRobotEvent.getVelocity() > 0.0 ? 1 : -1);
        this.eDistance = scannedRobotEvent.getDistance();
        this.bPower = 1.9 - 0.1 * (this.healthDisadvantage + 2.0);
        if (this.self.getEnergy() < 3.0) {
            this.bPower = 0.1;
        } else if (this.self.getEnergy() < 7.0) {
            this.bPower = 0.2;
        } else if (this.self.getEnergy() < 12.0) {
            this.bPower = 0.4;
        } else if (this.self.getEnergy() < 16.0) {
            this.bPower -= 1.0;
        }
        if (scannedRobotEvent.getDistance() < 175.0) {
            this.bPower = (1.0 - (scannedRobotEvent.getDistance() - 36.0) / 139.0) * (3.0 - this.bPower) + this.bPower;
        }
        if (scannedRobotEvent.getEnergy() < (16.0 + Rules.getBulletDamage((double)this.bPower)) / 2.0) {
            this.bPower = (scannedRobotEvent.getEnergy() + 2.0) / 6.0;
            if (scannedRobotEvent.getEnergy() <= 4.0) {
                this.bPower = Math.max(0.1, scannedRobotEvent.getEnergy() / 4.0);
            }
        }
        Iterator<StickyGoo> iterator = this.launches.iterator();
        while (iterator.hasNext()) {
            StickyGoo stickyGoo = iterator.next();
            if (!stickyGoo.checkHit(this.enemyPos, this.self.getTime())) continue;
            iterator.remove();
            this.storeWave(stickyGoo, this.enemyPos);
            ++this.passCount;
        }
        this.decideSegmentation(scannedRobotEvent, d, d2);
        this.self.setTurnGunLeftRadians(Utils.normalRelativeAngle((double)(this.self.getGunHeadingRadians() - d - this.aim(d2))));
        this.timeToShoot = this.self.getTime() + 1L;
        return bullet;
    }

    private void storeWave(StickyGoo stickyGoo, Point2D.Double double_) {
        double d = Math.atan2(this.enemyPos.x - stickyGoo.sourceX(), this.enemyPos.y - stickyGoo.sourceY());
        double d2 = Utils.normalRelativeAngle((double)(d - stickyGoo.groundHeading));
        double d3 = Math.max(-1.0, Math.min(1.0, d2 / stickyGoo.mEA)) * (double)stickyGoo.dir;
        int n = (int)Math.round(36.0 * (d3 + 1.0));
        double d4 = 2.0 * Math.atan(18.0 / this.enemyPos.distance(new Point2D.Double(stickyGoo.sourceX(), stickyGoo.sourceY())));
        double d5 = 2.0 * stickyGoo.mEA / 73.0;
        double d6 = d4 / d5;
        double d7 = d6 / 2.0;
        int n2 = (int)Math.ceil(d6);
        ++this.shots;
        this.neighborMap.put(new float[]{this.self.getRoundNum(), this.self.getTime(), stickyGoo.accelSeg, stickyGoo.distSeg, stickyGoo.velSeg, stickyGoo.wallSpaceSeg, stickyGoo.revWallSeg, stickyGoo.headSeg, stickyGoo.bPowerSeg}, d3);
    }

    private void decideSegmentation(ScannedRobotEvent scannedRobotEvent, double d, double d2) {
        double d3 = this.eDir < 0 ? Math.PI + scannedRobotEvent.getHeadingRadians() : scannedRobotEvent.getHeadingRadians();
        this.currDistSeg = (float)Math.min(2.0, scannedRobotEvent.getDistance() / 333.3333333333333);
        this.currVelSeg = (float)(Math.abs(scannedRobotEvent.getVelocity()) / 2.6999999999999997);
        this.accelSeg = Math.min(Double.compare(Math.abs(scannedRobotEvent.getVelocity()), Math.abs(this.oldVelocity)) + 1, 2);
        this.headSeg = (float)Math.min(2.0, Math.abs(Math.sin(scannedRobotEvent.getHeadingRadians() - d)) * 3.0);
        double d4 = Utils.normalAbsoluteAngle((double)d3) < Math.PI ? (this.self.getBattleFieldWidth() - this.enemyPos.x) / Math.cos(1.5707963267948966 - d3) : this.enemyPos.x / Math.cos(4.71238898038469 - d3);
        double d5 = Math.abs(Utils.normalRelativeAngle((double)d3)) < 1.5707963267948966 ? (this.self.getBattleFieldHeight() - this.enemyPos.y) / Math.cos(d3) : this.enemyPos.y / Math.cos(Math.PI - d3);
        this.currWallSeg = Math.max(0.0f, Math.min(2.0f, (float)(Math.min(d4, d5) / 333.3333333333333)));
        d3 += Math.PI;
        d3 = Utils.normalRelativeAngle((double)d3);
        double d6 = Utils.normalAbsoluteAngle((double)d3) < Math.PI ? (this.self.getBattleFieldWidth() - this.enemyPos.x) / Math.cos(1.5707963267948966 - d3) : this.enemyPos.x / Math.cos(4.71238898038469 - d3);
        double d7 = Math.abs(Utils.normalRelativeAngle((double)d3)) < 1.5707963267948966 ? (this.self.getBattleFieldHeight() - this.enemyPos.y) / Math.cos(d3) : this.enemyPos.y / Math.cos(Math.PI - Utils.normalAbsoluteAngle((double)d3));
        this.revWallSeg = Math.max(0.0f, Math.min(2.0f, (float)(Math.min(d6, d7) / 333.3333333333333)));
        this.bPowerSeg = (float)(this.bPower / 3.01 * 3.0);
        this.oldVelocity = scannedRobotEvent.getVelocity();
    }

    private double aim(double d) {
        float[] fArray4 = new float[]{this.accelSeg, this.currDistSeg, this.currVelSeg, this.currWallSeg, this.revWallSeg, this.headSeg, this.bPowerSeg};
        double d2 = 0.8 * d;
        double d3 = Math.asin(8.0 / Rules.getBulletSpeed((double)this.bPower));
        int n = (int)Math.ceil(d / d3 * 36.0);
        if ((n & 1) == 0) {
            ++n;
        }
        int n2 = n;
        Arrays.fill(this.dangerZones, 0.0);
        this.neighborMap.keySet().stream().sorted((fArray2, fArray3) -> Double.compare(this.manDistBetween((float[])fArray2, fArray4), this.manDistBetween((float[])fArray3, fArray4))).limit(7L).forEach(fArray -> {
            double d2 = this.neighborMap.get(fArray);
            for (int i = 0; i < 73; ++i) {
                int n2 = i - (n2 - 1) / 2;
                int n3 = this.limit(0, n2, i);
                while (n2 < i + (n2 - 1) / 2) {
                    double d3 = ((double)n3 - 36.0) / 36.0;
                    int n4 = i;
                    this.dangerZones[n4] = this.dangerZones[n4] + Math.exp(-0.5 * ((d3 - d2) * (d3 - d2) / (d2 * d2)));
                    n3 = this.limit(0, ++n2, 72);
                }
            }
        });
        int n3 = 64;
        for (int i = 36; i < 109; ++i) {
            if (!(this.dangerZones[i % 73] > this.dangerZones[n3])) continue;
            n3 = i % 73;
        }
        double d4 = ((double)n3 - 36.0) / 36.0;
        return d4 * d3 * (double)this.eLatDir;
    }

    private float manDistBetween(float[] fArray, float[] fArray2) {
        return Math.abs(fArray[2] - fArray2[0]) + Math.abs(fArray[3] - fArray2[1]) + Math.abs(fArray[4] - fArray2[2]) + Math.abs(fArray[5] - fArray2[3]) + Math.abs(fArray[6] - fArray2[4]) + Math.abs(fArray[7] - fArray2[5]) / 2.0f + Math.abs(fArray[8] - fArray2[6]);
    }

    int limit(int n, int n2, int n3) {
        return Math.max(n, Math.min(n2, n3));
    }

    public void onPaint(Graphics2D graphics2D) {
        double d = 0.1;
        for (int i = 0; i < 73; ++i) {
            if (!(this.dangerZones[i] > d)) continue;
            d = this.dangerZones[i];
        }
        graphics2D.setColor(Color.BLUE.brighter().brighter());
        for (int i = 0; i < 73; ++i) {
            graphics2D.fill(new Rectangle2D.Double(0.0 + (double)i * 2.3013698630136985, 0.0, 2.3013698630136985, 100.0 * (this.dangerZones[i] / d)));
        }
        graphics2D.setColor(Color.YELLOW);
        graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, 168.0, 100.0));
        graphics2D.draw(new Line2D.Double(84.0, 0.0, 84.0, 100.0));
    }

    public void reset() {
        if (this.neighborMap.size() > 255) {
            List list = this.neighborMap.keySet().stream().sorted((fArray, fArray2) -> {
                int n = Double.compare(fArray[0], fArray2[0]);
                if (n == 0) {
                    return Double.compare(fArray[1], fArray2[1]);
                }
                return n;
            }).limit(this.neighborMap.size() - 84).collect(Collectors.toList());
            System.out.println("Clearing " + list.size() + " gun datums");
            for (float[] fArray3 : list) {
                this.neighborMap.remove(fArray3);
            }
        }
    }
}

