/*
 * Decompiled with CFR 0.152.
 */
package de.simpleworks.robocode.bots;

import de.simpleworks.robocode.botUtil.AngleCalc;
import de.simpleworks.robocode.botUtil.Coordinate;
import de.simpleworks.robocode.botUtil.CsCalc;
import de.simpleworks.robocode.debug.Debug;
import de.simpleworks.robocode.strategy.FireStrategy;
import de.simpleworks.robocode.strategy.FireStrategyManager;
import java.awt.Color;
import robocode.HitByBulletEvent;
import robocode.Robot;
import robocode.RobotStatus;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;

public class swiBot
extends Robot {
    private boolean FDebugActive = false;
    private FireStrategyManager FFSMan = new FireStrategyManager();
    private RobotStatus FCurrentStatus = null;

    protected RobotStatus getCurrentStatus() {
        return this.FCurrentStatus;
    }

    protected boolean getDebugIsActive() {
        return this.FDebugActive;
    }

    protected void setDebugActive(boolean _active) {
        this.FDebugActive = _active;
    }

    protected boolean getTurnDirLeft(double _angleDiff) {
        return _angleDiff > 0.0 && _angleDiff < 180.0 || _angleDiff < -180.0;
    }

    protected boolean getTurnDirRight(double _angleDiff) {
        return !this.getTurnDirLeft(_angleDiff) && this.getMustTurn(_angleDiff);
    }

    protected boolean getMustTurn(double _angleDiff) {
        return _angleDiff != 0.0;
    }

    protected double getAngleToTurn(double _itemHead, double _targetAngle) {
        double aDiff = AngleCalc.getBearing(_itemHead, _targetAngle);
        return aDiff;
    }

    protected void turnGunTo(double _angle) {
        double bearing = this.getAngleToTurn(this.getGunHeading(), _angle);
        this.turnGunRight(bearing);
    }

    protected void turnRadarTo(double _angle) {
        double bearing = this.getAngleToTurn(this.getRadarHeading(), _angle);
        this.turnRadarRight(bearing);
    }

    protected void turnTo(double _angle) {
        double bearing = this.getAngleToTurn(this.getHeading(), _angle);
        this.turnRight(bearing);
    }

    protected void turnNorth() {
        this.turnTo(0.0);
    }

    protected void turnEast() {
        this.turnTo(90.0);
    }

    protected void turnSouth() {
        this.turnTo(180.0);
    }

    protected void turnWest() {
        this.turnTo(270.0);
    }

    protected void syncGunToRadar() {
        this.turnGunTo(this.getRadarHeading());
    }

    protected void syncGunToHead() {
        this.turnGunLeft(this.getHeading());
    }

    protected void syncAllToHead() {
        this.turnRadarTo(this.getHeading());
        this.syncGunToRadar();
    }

    protected void moveTo(double _x, double _y) {
        if (_x > this.getX()) {
            this.turnEast();
            this.ahead(_x - this.getX());
        } else {
            this.turnWest();
            this.ahead(this.getX() - _x);
        }
        if (_y > this.getY()) {
            this.turnNorth();
            this.ahead(_y - this.getY());
        } else {
            this.turnSouth();
            this.ahead(this.getY() - _y);
        }
    }

    protected void moveToDirect(double _x, double _y) {
        this.moveToDirect(new Coordinate(_x, _y));
    }

    protected void moveToDirect(double _x, double _y, double _scanAny) {
        this.moveToDirect(new Coordinate(_x, _y), _scanAny);
    }

    protected void moveToDirect(Coordinate _targetPos) {
        Coordinate sp = new Coordinate(this.getX(), this.getY());
        double targetAngle = CsCalc.calcTargetAngle(sp, _targetPos);
        double targetDistance = CsCalc.calcDistance(sp, _targetPos);
        this.turnTo(targetAngle);
        this.ahead(targetDistance);
    }

    protected void moveToDirect(Coordinate _targetPos, double _scanAny) {
        Coordinate sp = new Coordinate(this.getX(), this.getY());
        double targetAngle = CsCalc.calcTargetAngle(sp, _targetPos);
        double targetDistance = CsCalc.calcDistance(sp, _targetPos);
        this.turnTo(targetAngle);
        this.ahead(targetDistance, _scanAny);
    }

    protected void ahead(double _dist, double _scanAny) {
        double restDist = _dist;
        while (restDist > 0.0) {
            if (_scanAny > restDist) {
                this.ahead(restDist);
                this.scanComplete();
                restDist = 0.0;
                continue;
            }
            this.ahead(_scanAny);
            this.scanComplete();
            restDist -= _scanAny;
        }
    }

    protected void scanComplete() {
        if (this.canFire()) {
            this.turnRadarLeft(360.0);
        }
    }

    protected void moveToSqares(double _x, double _y, double _scanRate) {
        if (_x > this.getX()) {
            this.turnEast();
            this.ahead(_x - this.getX(), _scanRate);
        } else {
            this.turnWest();
            this.ahead(this.getX() - _x, _scanRate);
        }
        if (_y > this.getY()) {
            this.turnNorth();
            this.ahead(_y - this.getY(), _scanRate);
        } else {
            this.turnSouth();
            this.ahead(this.getY() - _y, _scanRate);
        }
    }

    protected void moveToCenter() {
        this.moveTo(this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0);
    }

    protected boolean canFire() {
        return this.getGunHeat() == 0.0;
    }

    protected void fire(double _power, double _targetAngle) {
        this.turnGunTo(_targetAngle);
        Debug.print(this.getDebugIsActive(), "Aim Bot: head=" + Double.toString(this.getHeading()) + ", targetAngle=" + Double.toString(_targetAngle) + ", gunHead=" + Double.toString(this.getGunHeading()));
        this.fire(_power);
    }

    protected void setup() {
        this.setDebugActive(true);
        this.setBodyColor(Color.orange);
        this.setGunColor(Color.BLACK);
        this.setRadarColor(Color.white);
        this.setAdjustGunForRobotTurn(true);
    }

    public void run() {
        this.setup();
        while (true) {
            this.moveToDirect(this.getBattleFieldWidth() / 4.0, this.getBattleFieldHeight() / 4.0, 100.0);
            this.moveToSqares(this.getBattleFieldWidth() - this.getBattleFieldWidth() / 4.0, this.getBattleFieldHeight() - this.getBattleFieldHeight() / 4.0, 100.0);
            this.moveToDirect(10.0, 10.0, 100.0);
            this.moveToSqares(this.getBattleFieldWidth() - 10.0, this.getBattleFieldHeight() - 10.0, 100.0);
            this.moveToSqares(this.getBattleFieldWidth() / 4.0, this.getBattleFieldHeight() / 4.0, 100.0);
            this.moveToDirect(this.getBattleFieldWidth() - this.getBattleFieldWidth() / 4.0, this.getBattleFieldHeight() - this.getBattleFieldHeight() / 4.0, 100.0);
            this.moveToSqares(10.0, 10.0, 100.0);
            this.moveToDirect(this.getBattleFieldWidth() - 10.0, this.getBattleFieldHeight() - 10.0, 100.0);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        FireStrategy thisStrat = this.FFSMan.getStrategy();
        thisStrat.update(e, this.FCurrentStatus, 0.0, this.getBattleFieldHeight(), this.getBattleFieldWidth());
        double power = thisStrat.getPower();
        if (thisStrat.willFire()) {
            this.fire(power, thisStrat.getGunAngle());
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onStatus(StatusEvent e) {
        this.FCurrentStatus = e.getStatus();
    }
}

