/*
 * Decompiled with CFR 0.152.
 */
package rdt.AgentSmith.Targeting;

import rdt.AgentSmith.Guns.EnemyGunManager;
import rdt.AgentSmith.Guns.FriendlyGunManager;
import rdt.AgentSmith.Guns.IGunManager;
import rdt.AgentSmith.IRobot;
import rdt.AgentSmith.RobotHistory.RobotHistory;
import rdt.AgentSmith.Stats.IStats;
import rdt.AgentSmith.Waves.IWaveManager;

public class Target {
    public boolean Valid;
    public boolean Alive;
    public long LastUpdatedTick;
    public long LastTickFired = Long.MIN_VALUE;
    public double LastFiredBulletFirepower = 0.0;
    public long NextTickCanFireAgain = 0L;
    public long LastTickTargetHitUs = Long.MIN_VALUE;
    public double LastEnergyGainedFromHittingUs = 0.0;
    public long LastTickWeHitTarget = Long.MIN_VALUE;
    public double LastEnergyLostFromUsHittingTarget = 0.0;
    public RobotHistory RobotHistory = new RobotHistory(200);
    public IGunManager GunsFiredFromTarget;
    public IGunManager GunsFiredAtTarget;

    public Target(String targetName, IRobot robot, IWaveManager friendlyWaveManager, IWaveManager enemyWaveManager, IStats stats) {
        this.GunsFiredFromTarget = new EnemyGunManager(targetName, robot, robot.GetRobotHistory(), enemyWaveManager, stats);
        this.GunsFiredAtTarget = new FriendlyGunManager(targetName, robot, this.RobotHistory, friendlyWaveManager, stats);
    }

    public void Invalidate() {
        this.Valid = false;
    }

    public void OnRoundStart() {
        System.out.println("Target:OnRoundStart");
        this.RobotHistory.Clear();
        this.LastUpdatedTick = -1L;
        this.LastTickFired = Long.MIN_VALUE;
        this.NextTickCanFireAgain = 0L;
        this.LastTickTargetHitUs = Long.MIN_VALUE;
        this.LastTickWeHitTarget = Long.MIN_VALUE;
    }
}

