/*
 * Decompiled with CFR 0.152.
 */
package mue;

import java.awt.geom.Rectangle2D;
import mue.BulletData;
import mue.NoDataException;
import mue.Position;
import mue.RobotBase;
import mue.Util;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;

class RobotData {
    private static final double VELOCITY_FACTOR = 0.3;
    private static final double HEADING_FACTOR = 0.4;
    private static final double SHOTS_FACTOR = 0.2;
    private RobotBase owner;
    private String name;
    private double energy;
    private double x;
    private double y;
    private Rectangle2D.Double rectangle;
    private double distance;
    private double heading;
    private double direction;
    private double velocity;
    private double lastVelocity;
    private double angularVelocity;
    private double lastAngularVelocity;
    private int orbitDirection;
    private int timeSinceLastAcceleration;
    private int timeSinceLastDeceleration;
    private long time;
    private double headingChange;
    private double maxVelocity;
    private double averageVelocity;
    private double averageHeading;
    private double minVelocity;
    private double averageAngularVelocity;
    private double averageFirePower;
    private int shots;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private int guessedPositions;
    private boolean alive;
    private boolean empty;

    public RobotData(RobotBase robotBase, String string) {
        this.owner = robotBase;
        this.name = string;
        this.minX = 18.0;
        this.minY = 18.0;
        this.maxX = this.owner.getBattleFieldWidth() - 18.0;
        this.maxY = this.owner.getBattleFieldHeight() - 18.0;
        this.guessedPositions = 0;
        this.averageVelocity = 0.0;
        this.averageHeading = 0.0;
        this.averageAngularVelocity = 0.0;
        this.timeSinceLastAcceleration = 0;
        this.timeSinceLastDeceleration = 0;
        this.velocity = 0.0;
        this.angularVelocity = 0.0;
        this.orbitDirection = 0;
        this.averageFirePower = 2.0;
        this.shots = 0;
        this.alive = true;
        this.empty = true;
        this.rectangle = null;
    }

    protected BulletData adaptEnergy(double d, long l) {
        BulletData bulletData = null;
        double d2 = this.energy - d;
        if (Math.abs(d2) > 1.0E-4 && (!this.owner.getKnowledge().inactivityTimerExpired() || Math.abs(d2 - 0.1) > 1.0E-4)) {
            this.owner.getKnowledge().updateEnergyChange(l);
        }
        if (!this.empty && this.owner.getOthers() <= 1 && (!this.owner.getKnowledge().inactivityTimerExpired() || Math.abs(d2 - 0.1) > 1.0E-4) && d2 < 3.0001 && (d2 > 0.0999 || d2 > 1.0E-4 && d < 1.0E-4)) {
            double d3 = d2 <= 0.0999 && d < 1.0E-4 ? d2 : Util.confine(d2, 0.1, 3.0);
            bulletData = new BulletData(this.name, this.x, this.y, d3, this.owner.getOldX(), this.owner.getOldY(), this.owner.getOldHeading(), this.owner.getOldVelocity(), this.owner.getOldAcceleration(), l - 1L);
            this.averageFirePower = this.averageFirePower * 0.8 + d3 * 0.2;
            ++this.shots;
        }
        this.energy = d;
        return bulletData;
    }

    public BulletData update(ScannedRobotEvent scannedRobotEvent) throws IllegalArgumentException {
        if (!scannedRobotEvent.getName().equals(this.name)) {
            Util.addWarning("RobotFile.update: event (" + scannedRobotEvent.getName() + ") is not about this robot (" + this.name + ").");
            return null;
        }
        if (!this.empty && this.time >= scannedRobotEvent.getTime()) {
            return null;
        }
        BulletData bulletData = this.adaptEnergy(scannedRobotEvent.getEnergy(), scannedRobotEvent.getTime());
        double d = Math.toRadians(this.owner.getHeading() + scannedRobotEvent.getBearing());
        this.distance = scannedRobotEvent.getDistance();
        this.x = this.owner.getX() + Math.sin(d) * scannedRobotEvent.getDistance();
        this.y = this.owner.getY() + Math.cos(d) * scannedRobotEvent.getDistance();
        if (this.rectangle == null) {
            this.rectangle = new Rectangle2D.Double();
        }
        this.rectangle.setRect(this.x - 19.0, this.y - 19.0, 38.0, 38.0);
        this.lastVelocity = this.velocity;
        this.velocity = scannedRobotEvent.getVelocity();
        this.lastAngularVelocity = this.angularVelocity;
        if (Math.abs(this.velocity) > 1.0E-4) {
            double d2 = Util.relativeAngle(Math.toDegrees(d) + 90.0, scannedRobotEvent.getHeading());
            if (Math.abs(d2) < 90.0) {
                this.orbitDirection = 1;
            }
            if (Math.abs(d2) > 90.0) {
                this.orbitDirection = -1;
            }
            if (this.velocity < 0.0) {
                this.orbitDirection *= -1;
            }
        }
        ++this.timeSinceLastAcceleration;
        ++this.timeSinceLastDeceleration;
        if (Math.abs(this.velocity) - Math.abs(this.lastVelocity) > 0.5) {
            this.timeSinceLastAcceleration = 0;
        } else if (Math.abs(this.velocity) - Math.abs(this.lastVelocity) < -0.5) {
            this.timeSinceLastDeceleration = 0;
        }
        if (this.empty) {
            this.maxVelocity = this.velocity;
            this.minVelocity = this.velocity;
            this.averageVelocity = this.velocity;
            this.headingChange = 0.0;
            this.averageHeading = scannedRobotEvent.getHeading();
        } else {
            if (this.velocity > this.maxVelocity) {
                this.maxVelocity = this.velocity;
            }
            if (this.velocity < this.minVelocity) {
                this.minVelocity = this.velocity;
            }
            this.averageVelocity = this.averageVelocity * 0.7 + this.velocity * 0.3;
            this.headingChange = Util.relativeAngle(this.heading, scannedRobotEvent.getHeading()) / (double)(scannedRobotEvent.getTime() - this.time);
            this.averageHeading = this.averageHeading * 0.6 + (this.averageHeading + Util.relativeAngle(this.averageHeading, scannedRobotEvent.getHeading())) * 0.4;
            this.angularVelocity = Math.toRadians(Util.relativeAngle(this.direction, this.owner.getHeading() + scannedRobotEvent.getBearing()) / (double)(scannedRobotEvent.getTime() - this.time)) * scannedRobotEvent.getDistance();
            this.averageAngularVelocity = this.averageAngularVelocity * 0.7 + this.angularVelocity * 0.3;
        }
        this.heading = scannedRobotEvent.getHeading();
        this.direction = this.owner.getHeading() + scannedRobotEvent.getBearing();
        this.time = scannedRobotEvent.getTime();
        this.guessedPositions = 0;
        this.empty = false;
        return bulletData;
    }

    public BulletData update(BulletHitEvent bulletHitEvent) throws IllegalArgumentException {
        if (!bulletHitEvent.getName().equals(this.name)) {
            Util.addWarning("RobotFile.update: event (" + bulletHitEvent.getName() + ") is not about this robot (" + this.name + ").");
            return null;
        }
        if (this.empty || this.time >= bulletHitEvent.getTime()) {
            return null;
        }
        this.energy -= 4.0 * bulletHitEvent.getBullet().getPower();
        if (bulletHitEvent.getBullet().getPower() > 1.0) {
            this.energy -= 2.0 * (bulletHitEvent.getBullet().getPower() - 1.0);
        }
        return this.adaptEnergy(bulletHitEvent.getEnergy(), bulletHitEvent.getTime());
    }

    public BulletData update(HitByBulletEvent hitByBulletEvent) throws IllegalArgumentException {
        if (!hitByBulletEvent.getName().equals(this.name)) {
            Util.addWarning("RobotFile.update: event (" + hitByBulletEvent.getName() + ") is not about this robot (" + this.name + ").");
            return null;
        }
        if (this.empty || this.time >= hitByBulletEvent.getTime()) {
            return null;
        }
        this.energy += hitByBulletEvent.getPower() * 3.0;
        return null;
    }

    public BulletData update(HitRobotEvent hitRobotEvent) throws IllegalArgumentException {
        if (!hitRobotEvent.getName().equals(this.name)) {
            Util.addWarning("RobotFile.update: event (" + hitRobotEvent.getName() + ") is not about this robot (" + this.name + ").");
            return null;
        }
        if (this.empty || this.time >= hitRobotEvent.getTime()) {
            return null;
        }
        this.energy -= 0.6;
        return this.adaptEnergy(hitRobotEvent.getEnergy(), hitRobotEvent.getTime());
    }

    public BulletData update(RobotDeathEvent robotDeathEvent) {
        if (!robotDeathEvent.getName().equals(this.name)) {
            Util.addWarning("RobotFile.update: event (" + robotDeathEvent.getName() + ") is not about this robot (" + this.name + ").");
            return null;
        }
        this.alive = false;
        this.energy = 0.0;
        this.velocity = 0.0;
        this.headingChange = 0.0;
        return null;
    }

    public Position guessPosition() throws NoDataException {
        return this.guessPosition(this.owner.getTime());
    }

    public Position guessPosition(long l) throws NoDataException, IllegalArgumentException {
        if (this.empty) {
            Util.addWarning("RobotFile.guessPosition: No data for movement prediction available (" + this.name + ").");
            return new Position(0.0, 0.0);
        }
        double d = this.x;
        double d2 = this.y;
        if (Math.abs(this.velocity) >= 1.0E-4 && l > this.time) {
            d += Util.confine(Math.sin(Math.toRadians(this.heading)) * this.velocity * (double)(l - this.time), this.minX, this.maxX);
            d2 += Util.confine(Math.cos(Math.toRadians(this.heading)) * this.velocity * (double)(l - this.time), this.minY, this.maxY);
        }
        return new Position(d, d2);
    }

    public final String getName() {
        return this.name;
    }

    public final double getEnergy() {
        if (this.empty) {
            return 0.0;
        }
        return this.energy;
    }

    public final double getX() {
        if (this.empty) {
            return 0.0;
        }
        return this.x;
    }

    public final double getY() {
        if (this.empty) {
            return 0.0;
        }
        return this.y;
    }

    public final boolean intersects(double d, double d2, double d3, double d4) {
        if (this.rectangle == null) {
            return false;
        }
        return this.rectangle.intersectsLine(d, d2, d3, d4);
    }

    public final double getDistance() {
        if (this.empty) {
            return 0.0;
        }
        return this.distance;
    }

    public final double getHeading() {
        if (this.empty) {
            return 0.0;
        }
        return this.heading;
    }

    public final double getVelocity() {
        if (this.empty) {
            return 0.0;
        }
        return this.velocity;
    }

    public final int getTimeSinceLastAcceleration() {
        return this.timeSinceLastAcceleration;
    }

    public final int getTimeSinceLastDeceleration() {
        return this.timeSinceLastDeceleration;
    }

    public final int getAcceleration() {
        if (this.empty) {
            return 0;
        }
        if (this.velocity > this.lastVelocity + 0.5) {
            return 1;
        }
        if (this.velocity < this.lastVelocity - 0.5) {
            return -1;
        }
        return 0;
    }

    public final double getLastVelocity() {
        return this.lastVelocity;
    }

    public final int getOrbitDirection() {
        return this.orbitDirection;
    }

    public final double getAngularVelocity() {
        return this.angularVelocity;
    }

    public final int getAngularAcceleration() {
        if (this.empty) {
            return 0;
        }
        if (this.angularVelocity > this.lastAngularVelocity + 0.5) {
            return 1;
        }
        if (this.angularVelocity < this.lastAngularVelocity - 0.5) {
            return -1;
        }
        return 0;
    }

    public final long getTime() {
        if (this.empty) {
            return 0L;
        }
        return this.time;
    }

    public final boolean isEmpty() {
        return this.empty;
    }

    public final double getAverageVelocity() {
        return this.averageVelocity;
    }

    public final double getAverageHeading() {
        return this.averageHeading;
    }

    public final double getAverageAngularVelocity() {
        return this.averageAngularVelocity;
    }

    public final double getAverageFirePower() {
        return this.averageFirePower;
    }

    public final boolean isAlive() {
        return this.alive;
    }
}

