/*
 * Decompiled with CFR 0.152.
 */
package emp;

import emp.BulletItem;
import emp.BulletTracker;
import emp.Consts;
import emp.My;
import emp.Strategy;
import emp.Yngwie;
import java.util.Vector;

public class Enemy
implements Consts {
    public String Name;
    public double HitX;
    public double HitY;
    public double HitPower;
    public int HitStrategy;
    public double[][] Records;
    public int RC;
    public boolean Death;
    public Vector Strategies;
    public double BulletDamage;
    public boolean Scanned;
    public long LastTimeHitMe;
    public long LastTimeFired;
    public double EnergyAdjust;
    public double TargetScore;
    public Vector BulletList;

    public Enemy(String N) {
        this.Name = N;
        this.Records = new double[4096][10];
        this.BulletList = new Vector(500, 100);
        this.Strategies = new Vector(10, 5);
        this.Strategies.add(0, new Strategy(305));
        this.Strategies.add(1, new Strategy(303));
        this.Strategies.add(2, new Strategy(304));
        this.Strategies.add(3, new Strategy(306));
        this.Strategies.add(4, new Strategy(309));
        this.Strategies.add(5, new Strategy(310));
        if (Yngwie.Melee) {
            this.Strategies.add(6, new Strategy(307));
        }
        this.Clear();
    }

    public boolean AddBulletItem(BulletTracker bt, long curtime) {
        double hittime = curtime + bt.Counter;
        if ((double)this.Time() < hittime) {
            return false;
        }
        int j = this.RC - 1;
        double minerror = Math.abs(hittime - this.Records[j][0]);
        while (Math.abs(hittime - this.Records[j - 1][0]) < minerror) {
            minerror = Math.abs(hittime - this.Records[j - 1][0]);
            --j;
        }
        if (minerror == 0.0) {
            BulletItem bi = new BulletItem(bt.Power, bt.Distance, bt.EnemyVelocity, bt.EnemyBearing, bt.OneOnOne);
            bi.Deviation = My.Distance(bt.EnemyX, bt.EnemyY, this.Records[j][1], this.Records[j][2]);
            bi.DeviationAngle = My.ADiffDeg(bt.EnemyHeading, My.AngleFromTo(bt.EnemyX, bt.EnemyY, this.Records[j][1], this.Records[j][2]));
            this.BulletList.addElement(bi);
        }
        return true;
    }

    public double EasyLevel() {
        Strategy maxStrat = (Strategy)this.Strategies.elementAt(0);
        for (int j = 1; j < this.Strategies.size(); ++j) {
            Strategy strat = (Strategy)this.Strategies.elementAt(j);
            if (!(strat.Faith() > maxStrat.Faith())) continue;
            maxStrat = strat;
        }
        return maxStrat.Faith();
    }

    public void Clear() {
        this.RC = 0;
        this.Death = false;
        this.HitStrategy = 0;
        this.HitPower = 0.0;
        this.BulletDamage = 0.0;
        this.Scanned = true;
        this.LastTimeHitMe = -1000L;
        this.LastTimeFired = -1L;
        this.EnergyAdjust = 0.0;
        this.TargetScore = 0.0;
    }

    public void IncreaseRecord() {
        double[][] Temp = new double[this.Records.length * 2][10];
        System.arraycopy(this.Records, 0, Temp, 0, this.Records.length);
        this.Records = Temp;
    }

    public long Time() {
        if (this.RC == 0) {
            return -1L;
        }
        return (long)this.Records[this.RC - 1][0];
    }

    public double X() {
        if (this.RC == 0) {
            return -1.0;
        }
        return this.Records[this.RC - 1][1];
    }

    public double Y() {
        if (this.RC == 0) {
            return -1.0;
        }
        return this.Records[this.RC - 1][2];
    }

    public double Velocity() {
        if (this.RC == 0) {
            return -1.0;
        }
        return this.Records[this.RC - 1][3];
    }

    public double Heading() {
        if (this.RC == 0) {
            return -1.0;
        }
        return this.Records[this.RC - 1][4];
    }

    public double Energy() {
        if (this.RC == 0) {
            return 100.0;
        }
        return this.Records[this.RC - 1][7];
    }

    public double Turned() {
        if (this.RC == 0) {
            return -1.0;
        }
        return this.Records[this.RC - 1][5];
    }

    public double Fired() {
        if (this.RC == 0) {
            return -1.0;
        }
        return this.Records[this.RC - 1][8];
    }

    public long Others() {
        if (this.RC == 0) {
            return -1L;
        }
        return (long)this.Records[this.RC - 1][9];
    }
}

