/*
 * Decompiled with CFR 0.152.
 */
package gf.Centaur.radar;

import gf.Centaur.Data;
import gf.Centaur.radar.RadarControll;
import robocode.AdvancedRobot;
import robocode.CustomEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class NarrowLock
extends RadarControll {
    public NarrowLock(Data data, AdvancedRobot robot) {
        super(data, robot);
        System.out.println("Neues Radar: NarrowLock");
    }

    public NarrowLock(Data data, AdvancedRobot robot, boolean start) {
        super(data, robot, start);
        System.out.println("Neues Radar: NarrowLock");
    }

    @Override
    public void start() {
        this.robot.setTurnRadarRight(Double.POSITIVE_INFINITY);
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        if (this.data.getVictimName() == e.getName()) {
            double radarTurn = this.robot.getHeadingRadians() + e.getBearingRadians() - this.robot.getRadarHeadingRadians();
            this.robot.setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((double)radarTurn));
        }
    }

    @Override
    public void onRobotDeath(RobotDeathEvent e) {
        if (this.data.getVictimName() == e.getName() || this.data.getVictim() == null) {
            this.robot.setTurnRadarRight(Double.POSITIVE_INFINITY);
        }
    }

    @Override
    public void onCustomEvent(CustomEvent e) {
        if (e.getCondition() == this.data.NobodyScannedCondition) {
            this.robot.setTurnRadarRight(Double.POSITIVE_INFINITY);
        }
    }
}

