/*
 * Decompiled with CFR 0.152.
 */
package jekl.util;

import jekl.Jekyl;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.WinEvent;

public class ScoreKeeper {
    Jekyl robot;
    private static int ME = 0;
    private static int ENEMY = 1;
    private double myEnergy = 100.0;
    private double enemyEnergy = 100.0;
    public static double[] bullet = new double[2];
    public static double[] curbullet = new double[2];
    public static double[] survival = new double[2];

    public ScoreKeeper(Jekyl robot) {
        this.robot = robot;
    }

    public int getScore(int id) {
        return (int)Math.round(bullet[id] + curbullet[id] + survival[id]);
    }

    public void onBulletHit(BulletHitEvent e) {
        if (e.getEnergy() > 0.001) {
            curbullet[0] = curbullet[0] + (4.0 * e.getBullet().getPower() + 2.0 * Math.max(e.getBullet().getPower() - 1.0, 0.0));
        }
    }

    public void onHitByBullet(HitByBulletEvent e) {
        if (e.getPower() * 4.0 + Math.max(0.0, e.getPower() - 1.0) * 2.0 > this.myEnergy) {
            return;
        }
        curbullet[1] = curbullet[1] + (4.0 * e.getBullet().getPower() + 2.0 * Math.max(e.getBullet().getPower() - 1.0, 0.0));
    }

    public void onWin(WinEvent e) {
        survival[0] = survival[0] + 60.0;
        curbullet[0] = curbullet[0] + this.enemyEnergy;
        bullet[0] = bullet[0] + curbullet[0] * 1.2;
        bullet[1] = bullet[1] + curbullet[1];
        ScoreKeeper.curbullet[0] = 0.0;
        ScoreKeeper.curbullet[1] = 0.0;
    }

    public void onDeath(DeathEvent e) {
        survival[1] = survival[1] + 60.0;
        curbullet[1] = curbullet[1] + this.myEnergy;
        bullet[0] = bullet[0] + curbullet[0];
        bullet[1] = bullet[1] + curbullet[1] * 1.2;
        ScoreKeeper.curbullet[0] = 0.0;
        ScoreKeeper.curbullet[1] = 0.0;
    }

    public void printScore() {
        System.out.println("  ***********SCORECARD***********");
        System.out.print("  ");
        int i = 0;
        while (i < Math.max(this.robot.getName().length(), this.robot.getTarget().getName().length())) {
            System.out.print(" ");
            ++i;
        }
        System.out.println(" Total Survival Bullet");
        String p0 = "  " + this.robot.getName();
        String p1 = "  " + this.robot.getTarget().getName();
        String pTemp = " " + Math.round(bullet[0] + survival[0] + curbullet[0]);
        int i2 = this.robot.getName().length();
        while (i2 < Math.max(this.robot.getName().length(), this.robot.getTarget().getName().length()) + 7 - pTemp.length()) {
            p0 = String.valueOf(p0) + " ";
            ++i2;
        }
        pTemp = " " + Math.round(bullet[1] + survival[1] + curbullet[1]);
        i2 = this.robot.getTarget().getName().length();
        while (i2 < Math.max(this.robot.getName().length(), this.robot.getTarget().getName().length()) + 7 - pTemp.length()) {
            p1 = String.valueOf(p1) + " ";
            ++i2;
        }
        p0 = String.valueOf(p0) + Math.round(bullet[0] + survival[0] + curbullet[0]) + "  ";
        p1 = String.valueOf(p1) + Math.round(bullet[1] + survival[1] + curbullet[1]) + "  ";
        pTemp = " " + Math.round(survival[0]);
        i2 = 0;
        while (i2 < 8 - pTemp.length()) {
            p0 = String.valueOf(p0) + " ";
            ++i2;
        }
        pTemp = " " + Math.round(survival[1]);
        i2 = 0;
        while (i2 < 8 - pTemp.length()) {
            p1 = String.valueOf(p1) + " ";
            ++i2;
        }
        p0 = String.valueOf(p0) + Math.round(survival[0]) + "  ";
        p1 = String.valueOf(p1) + Math.round(survival[1]) + "  ";
        pTemp = " " + Math.round(bullet[0] + curbullet[0]);
        i2 = 0;
        while (i2 < 6 - pTemp.length()) {
            p0 = String.valueOf(p0) + " ";
            ++i2;
        }
        pTemp = " " + Math.round(bullet[1] + curbullet[1]);
        i2 = 0;
        while (i2 < 6 - pTemp.length()) {
            p1 = String.valueOf(p1) + " ";
            ++i2;
        }
        p0 = String.valueOf(p0) + Math.round(bullet[0] + curbullet[0]);
        p1 = String.valueOf(p1) + Math.round(bullet[1] + curbullet[1]);
        if (bullet[0] + survival[0] + curbullet[0] >= bullet[1] + survival[1] + curbullet[1]) {
            System.out.println(p0);
            System.out.println(p1);
        } else {
            System.out.println(p1);
            System.out.println(p0);
        }
    }

    public double getMyScore() {
        return Math.round(bullet[0] + survival[0] + curbullet[0]);
    }

    public double getEnemyScore() {
        return Math.round(bullet[1] + survival[1] + curbullet[1]);
    }

    public void setEnemyEnergy(double d) {
        this.enemyEnergy = d;
    }

    public void setMyEnergy(double d) {
        this.myEnergy = d;
    }
}

