/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.gun;

import florent.XSeries.gun.GunStrategy;
import florent.XSeries.radar.Enemy;
import florent.XSeries.utils.RobocodeTools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public class HeadOnGun
extends GunStrategy {
    private AdvancedRobot me;
    private Line2D.Double lineOfFire;

    public HeadOnGun(AdvancedRobot me) {
        this.me = me;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
    }

    public void onMainLoop() {
        Enemy target = this.selector.getTarget();
        if (target == null) {
            return;
        }
        double firePower = this.power.getPower(target);
        if (firePower + 1.0 > this.me.getEnergy()) {
            return;
        }
        if (this.me.getGunTurnRemainingRadians() == 0.0) {
            this.me.setFireBullet(firePower);
        }
        Point2D.Double targetLocation = new Point2D.Double(target.location.x, target.location.y);
        targetLocation = RobocodeTools.projectMotion(targetLocation, target.heading, target.timeSinceScan * target.velocity);
        double enemyAbsoluteBearing = RobocodeTools.absoluteBearing(new Point2D.Double(this.me.getX(), this.me.getY()), targetLocation);
        this.lineOfFire = new Line2D.Double(new Point2D.Double(targetLocation.x, this.me.getBattleFieldHeight() - targetLocation.y), new Point2D.Double(this.me.getX(), this.me.getBattleFieldHeight() - this.me.getY()));
        this.me.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(enemyAbsoluteBearing - this.me.getGunHeadingRadians())));
    }

    public void onPaint(Graphics2D e) {
        e.setColor(Color.GRAY);
        e.draw(this.lineOfFire);
        this.selector.onPaint(e);
    }
}

