/*
 * Decompiled with CFR 0.152.
 */
package rdt199.movement;

import rdt199.util.BotFuncs;
import rdt199.util.Location;

public class GravityBullet {
    protected Location m_CurrentLocation;
    protected double m_dVelocityX;
    protected double m_dVelocityY;
    protected boolean m_bAlive;
    protected static double GRAVITY_STRENGTH = 200.0;

    public GravityBullet(Location sloc, Location tloc, double firepower) {
        double dVelocity = 20.0 - 3.0 * firepower;
        double dAngleRadians = BotFuncs.getAbsBearing(sloc, tloc);
        this.m_dVelocityX = dVelocity * Math.sin(dAngleRadians);
        this.m_dVelocityY = dVelocity * Math.cos(dAngleRadians);
        this.m_CurrentLocation = sloc;
        this.m_bAlive = true;
    }

    public void update() {
        this.m_CurrentLocation.setX(this.m_CurrentLocation.getX() + this.m_dVelocityX);
        this.m_CurrentLocation.setY(this.m_CurrentLocation.getY() + this.m_dVelocityY);
        if (!BotFuncs.isInBattlefield(this.m_CurrentLocation)) {
            this.m_bAlive = false;
        }
    }

    public boolean isAlive() {
        return this.m_bAlive;
    }

    public double getGravity(Location loc) {
        double dDistance = BotFuncs.getDistanceBetween(this.m_CurrentLocation, loc);
        return GRAVITY_STRENGTH / (dDistance * dDistance);
    }
}

