/*
 * Decompiled with CFR 0.152.
 */
package csm.genetic_trainer;

import csm.genetic_trainer.Population;
import csm.genetic_trainer.TrainableNumberCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import robocode.RobocodeFileOutputStream;

public class GeneSerializer {
    public static Population readPopulation(File file) {
        Population pop = null;
        try {
            FileInputStream istream = new FileInputStream(file);
            ObjectInputStream p = new ObjectInputStream(istream);
            pop = (Population)p.readObject();
            istream.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        return pop;
    }

    public static TrainableNumberCache readTrainableNumberCache(File file) {
        TrainableNumberCache numCache = null;
        try {
            FileInputStream istream = new FileInputStream(file);
            ObjectInputStream p = new ObjectInputStream(istream);
            numCache = (TrainableNumberCache)p.readObject();
            istream.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex.getMessage());
        }
        return numCache;
    }

    public static void writePopulation(File file, Population population) {
        try {
            RobocodeFileOutputStream ostream = new RobocodeFileOutputStream(file);
            ObjectOutputStream p = new ObjectOutputStream((OutputStream)ostream);
            p.writeObject(population);
            p.flush();
            ostream.close();
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void writeTrainableNumberCache(File file, TrainableNumberCache numCache) {
        try {
            RobocodeFileOutputStream ostream = new RobocodeFileOutputStream(file);
            ObjectOutputStream p = new ObjectOutputStream((OutputStream)ostream);
            p.writeObject(numCache);
            p.flush();
            ostream.close();
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }
}

