/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.gun;

import florent.XSeries.Configuration;
import florent.XSeries.radar.Enemy;
import florent.XSeries.radar.Tracker;
import florent.XSeries.team.Xmen;
import florent.XSeries.utils.RobocodeTools;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.concurrent.ConcurrentHashMap;

public class TargetSelector {
    private Tracker tracker;
    public ConcurrentHashMap<String, Enemy> enemies;
    private Xmen me;
    private Enemy target;
    private static TargetSelector instance;

    private TargetSelector(Xmen me, Tracker tracker) {
        this.tracker = tracker;
        this.enemies = tracker.getEnemies();
        this.me = me;
    }

    public Enemy getTarget() {
        if (this.target != null && !this.enemies.containsValue(this.target) || this.target != null && this.tracker.isDead(this.target)) {
            this.target = null;
        }
        if (this.enemies.size() == 0) {
            this.target = null;
        } else if (this.enemies.size() == 1) {
            String key = (String)this.enemies.keySet().iterator().next();
            this.target = this.enemies.get(key);
            if (this.me.isTeammate(this.target.name)) {
                this.target = null;
                RobocodeTools.log("dont shoot!");
            }
        } else {
            Point2D.Double myLocation = new Point2D.Double(this.me.getX(), this.me.getY());
            for (Enemy current : this.enemies.values()) {
                if (this.me.isTeammate(current.name)) continue;
                if (this.target == null) {
                    this.target = current;
                } else if (current.location.distance(myLocation) < this.target.location.distance(myLocation) - 200.0) {
                    this.target = current;
                }
                if (current.energy != 0.0) continue;
                return current;
            }
        }
        if (this.target != null && this.me.isTeammate(this.target.name)) {
            this.target = null;
            RobocodeTools.log("dont shoot!");
        }
        return this.target;
    }

    public void onPaint(Graphics2D e) {
    }

    public static TargetSelector getInstance(Xmen me, Tracker tracker) {
        if (instance == null) {
            instance = new TargetSelector(me, tracker);
        }
        return instance;
    }

    private int getRealOthers() {
        if (Configuration.team) {
            int friends = this.me.getTeammates() != null ? this.me.getTeammates().length : 0;
            return this.me.getOthers() - friends;
        }
        return this.me.getOthers();
    }

    public void setTarget(Enemy target) {
        this.target = target;
    }
}

