/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.movement;

import florent.XSeries.gun.TargetSelector;
import florent.XSeries.movement.MovementStrategy;
import florent.XSeries.radar.Enemy;
import florent.XSeries.radar.Tracker;
import florent.XSeries.team.Xmen;
import florent.XSeries.utils.RobocodeTools;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import robocode.ScannedRobotEvent;

public class Mirror
extends MovementStrategy {
    private double awayFactor = 1.0;
    private Rectangle2D.Double BF;
    private Xmen me;
    private Point2D.Double lastEnemyLocation;
    private Point2D.Double enemyLocation;
    private Point2D.Double myLocation;
    private Point2D.Double center;
    private Point2D.Double mirrorMyLocation;
    private Enemy enemy;
    private double distance;
    private int score;

    public Mirror(Xmen me) {
        this.me = me;
        this.BF = new Rectangle2D.Double(18.0, 18.0, me.getBattleFieldWidth() - 36.0, me.getBattleFieldHeight() - 36.0);
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.enemy = Tracker.getInstance().getEnemy(e.getName());
        this.lastEnemyLocation = this.enemyLocation;
        this.myLocation = new Point2D.Double(this.me.getX(), this.me.getY());
        this.enemyLocation = RobocodeTools.projectMotion(this.myLocation, this.me.getHeadingRadians() + e.getBearingRadians(), e.getDistance());
        if (this.lastEnemyLocation == null) {
            this.lastEnemyLocation = this.enemyLocation;
        }
        this.center = RobocodeTools.projectMotion(this.lastEnemyLocation, RobocodeTools.absoluteBearing(this.lastEnemyLocation, this.myLocation), e.getDistance() / 2.0);
        double tolerance = 0.0;
        double delta = 0.0;
        double dist = e.getDistance();
        do {
            this.mirrorMyLocation = RobocodeTools.projectMotion(this.enemyLocation, RobocodeTools.absoluteBearing(this.enemyLocation, this.center) - (double)this.enemy.myBearingDirection[0] * delta, (dist + 0.0 * tolerance) * this.awayFactor);
            tolerance += 5.0;
        } while (!this.BF.contains(this.mirrorMyLocation) && (delta += 0.1) < Math.PI * 2);
        this.distance = e.getDistance();
    }

    public void onMainLoop() {
        this.enemy = TargetSelector.getInstance(this.me, Tracker.getInstance()).getTarget();
        if (this.enemy != null) {
            boolean rammer;
            if (this.mirrorMyLocation == null) {
                this.mirrorMyLocation = this.myLocation = new Point2D.Double(this.me.getX(), this.me.getY());
            }
            this.awayFactor = (rammer = this.enemy.isRammer()) ? 1.1 : (this.distance < 50.0 ? 1.005 : 1.003);
            this.setAwayFactor(rammer ? 1.1 : (this.distance < 50.0 ? 1.005 : 1.003));
            this.me.setMaxVelocity(8.0);
            double theta = RobocodeTools.absoluteBearing(this.myLocation, this.mirrorMyLocation) - this.me.getHeadingRadians();
            this.me.setAhead(Math.cos(theta) * 100.0);
            this.me.setTurnRightRadians(Math.tan(theta));
        }
    }

    public void setAwayFactor(double awayFactor) {
        this.awayFactor = awayFactor;
    }

    public void execCondition() {
        this.enemy = TargetSelector.getInstance(this.me, Tracker.getInstance()).getTarget();
        this.score = this.me.getOthers() == 1 && this.enemy != null && this.enemy.distance < 200.0 && this.enemy.energy > 0.0 ? 75 : 0;
    }

    public int getScore() {
        return this.score;
    }
}

