/*
 * Decompiled with CFR 0.152.
 */
package de._4geeks.robots.guns;

import de._4geeks.robots.guns.GunManager;
import de._4geeks.robots.guns.LGun;
import de._4geeks.robots.guns.VCS.AllCombinedResearchGun;
import de._4geeks.robots.guns.VCS.Research.SurferLowCombinedResearchGun;
import de._4geeks.robots.guns.VCS.ResearchGun;
import de._4geeks.robots.guns.VCS.StatsBufferSet;
import de._4geeks.robots.guns.VGun;
import de._4geeks.robots.guns.manager.EnemyScan;
import de._4geeks.robots.guns.manager.Wave;
import de._4geeks.robots.utils.GuessFactorWindow;
import de._4geeks.robots.utils.SUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import robocode.AdvancedRobot;

public class VCSResearch
implements LGun {
    private static ArrayList<ResearchGun> guns;
    private ArrayList<VGun> vguns;
    private GunManager manager;
    private AdvancedRobot robot;

    public VCSResearch(AdvancedRobot robot, GunManager manager) {
        this.manager = manager;
        this.robot = robot;
        if (guns == null) {
            guns = new ArrayList();
            int history = 10000;
            int bins = 101;
            double influence = 0.125;
            guns.add(new SurferLowCombinedResearchGun(robot, bins, 5, 0.01));
            guns.add(new AllCombinedResearchGun(robot, bins, 10000, 0.125));
        }
        this.vguns = new ArrayList();
        for (ResearchGun gun : guns) {
            VCSGun g = new VCSGun(gun, gun.getName());
            this.vguns.add(g);
            manager.addVGun(g);
        }
    }

    public void battleOver() {
    }

    public void doLearning(Wave wave) {
        GuessFactorWindow window = new GuessFactorWindow(wave);
        for (StatsBufferSet statsBufferSet : guns) {
            statsBufferSet.registerWave(wave, window);
        }
    }

    public boolean receiveAllWaves() {
        return true;
    }

    public void roundOver() {
    }

    public void onPaint(Graphics2D g) {
        double bestError = Double.MAX_VALUE;
        VGun bestGun = null;
        Wave wave = this.manager.getCurrentWave();
        if (wave != null) {
            for (VGun gun : this.vguns) {
                wave.addGuess(gun.doAim(wave));
                if (!(gun.getError() < bestError)) continue;
                bestError = gun.getError();
                bestGun = gun;
            }
            double aim = bestGun.doAim(wave);
            double velocity = 20.0 - 3.0 * wave.getFirePower();
            EnemyScan enemy = wave.getEnemy();
            double startX = this.robot.getX();
            double startY = this.robot.getY();
            double bearing = enemy.getAbsoluteBearing();
            double forwardMEA = wave.getForwardMaxEscapeAngle();
            double reverseMEA = wave.getReverseMaxEscapeAngle();
            g.setColor(Color.ORANGE);
            g.drawLine((int)startX, (int)startY, (int)(startX + Math.sin(bearing + forwardMEA) * 1000.0), (int)(startY + Math.cos(bearing + forwardMEA) * 1000.0));
            g.setColor(Color.CYAN);
            g.drawLine((int)startX, (int)startY, (int)(startX + Math.sin(bearing + reverseMEA) * 1000.0), (int)(startY + Math.cos(bearing + reverseMEA) * 1000.0));
            double mea = aim > 0.0 ? Math.abs(forwardMEA) : Math.abs(reverseMEA);
            g.setColor(Color.GREEN);
            double gf = enemy.getAbsoluteBearing() + aim * mea * SUtils.sign(enemy.getAngularVelocity());
            g.drawLine((int)startX, (int)startY, (int)(startX + Math.sin(gf) * 1000.0), (int)(startY + Math.cos(gf) * 1000.0));
            g.setColor(Color.WHITE);
            g.drawString(bestGun.getGunName(), (int)startX + 20, (int)startY + 20);
            g.drawString(Double.toString(aim), (int)startX + 20, (int)startY + 40);
            if (bestGun instanceof VCSGun) {
                ResearchGun gun = (ResearchGun)((VCSGun)bestGun).getSet();
                double[] bins = gun.getBins(wave);
                double maxBin = 0.0;
                int maxIndex = -1;
                int i = 0;
                while (i < gun.getBins()) {
                    if (bins[i] > maxBin) {
                        maxBin = bins[i];
                        maxIndex = i;
                    }
                    ++i;
                }
                if (maxBin == 0.0) {
                    maxBin = 1.0;
                }
                g.setColor(Color.GREEN);
                i = 1;
                while (i < gun.getBins()) {
                    g.drawLine(20 + (i - 1) * 5, (int)(20.0 + bins[i - 1] * 100.0 / maxBin), 20 + i * 5, (int)(20.0 + bins[i] * 100.0 / maxBin));
                    ++i;
                }
                g.drawString(Double.toString(maxBin), 10, 10);
                if (maxIndex != -1) {
                    g.setColor(Color.GRAY);
                    g.drawLine(20 + maxIndex * 5, 20, 20 + maxIndex * 5, 120);
                }
            }
        }
    }

    class VCSGun
    extends VGun {
        StatsBufferSet set;
        String name;

        VCSGun(StatsBufferSet set, String name) {
            this.set = set;
            this.name = name;
        }

        public double doAim(Wave wave) {
            return this.set.doAim(wave);
        }

        public String getGunName() {
            return this.name;
        }

        public StatsBufferSet getSet() {
            return this.set;
        }
    }
}

